/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws;

import com.prosc.exception.UserCanceledException;
import com.prosc.io.Hostname;
import com.prosc.io.IOUtils;
import com.prosc.io.ProcessExecutionException;
import com.prosc.io.ProcessUtils;
import com.prosc.net.LocalhostLookup;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstanceMetadata {
    private static final Logger log = Logger.getLogger(InstanceMetadata.class.getName());
    private static String cachedPublicHostname = null;

    public static boolean isEC2Instance() {
        try {
            InstanceMetadata.getInfoForPath("/");
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getInfoForPath(String path) throws IOException {
        URLConnection connection = new URL("http", "169.254.169.254", 80, path).openConnection();
        connection.setConnectTimeout(1000);
        return IOUtils.urlConnectionAsString(connection);
    }

    public static String getAwsAccountNumber() throws IOException {
        return StringUtils.textBetween(InstanceMetadata.getInfoForPath("/latest/meta-data/iam/info"), "\"InstanceProfileArn\" : \"arn:aws:iam::", ":").orElse(null);
    }

    public static String getIamRole() throws IOException {
        return InstanceMetadata.getInfoForPath("/latest/meta-data/iam/security-credentials/");
    }

    public static String getPublicIPv4() throws IOException {
        return InstanceMetadata.getInfoForPath("/latest/meta-data/public-ipv4");
    }

    public static String getInstanceId() throws IOException {
        return InstanceMetadata.getInfoForPath("/latest/meta-data/instance-id");
    }

    public static String getInstanceProfileArn() throws IOException {
        return StringUtils.textBetween(InstanceMetadata.getInfoForPath("/latest/meta-data/iam/info/"), "\"InstanceProfileArn\" : \"", "\"").orElse(null);
    }

    public static String getPublicHostname(boolean validate) {
        if (InstanceMetadata.isEC2Instance()) {
            try {
                String result;
                String rawHostname = InstanceMetadata.getInfoForPath("/latest/meta-data/public-hostname");
                if (validate) {
                    if (cachedPublicHostname == null) {
                        try {
                            String osName = new String(ProcessUtils.doShellCommand(new String[]{"hostname"}, null, null)).replace("\n", "").replace("\r", "");
                            if (InstanceMetadata.validateDnsName(osName, "OS hostname")) {
                                cachedPublicHostname = osName;
                            }
                        }
                        catch (ProcessExecutionException e) {
                            log.log(Level.WARNING, "Could not execute the hostname OS function; will fall back to built-in Java functions", e);
                        }
                        catch (UserCanceledException e) {
                            log.log(Level.WARNING, "User canceled while attempting to get public hostname; will fall back to getCanonicalHostName instead", e);
                            Thread.currentThread().interrupt();
                        }
                        catch (IOException e) {
                            log.log(Level.WARNING, "Could not run a DNS lookup; will fall back to built-in Java functions", e);
                        }
                        if (cachedPublicHostname == null) {
                            try {
                                InetAddress localhost = InetAddress.getLocalHost();
                                String canonicalName = localhost.getCanonicalHostName();
                                if (InstanceMetadata.validateDnsName(canonicalName, "Canonical hostname")) {
                                    cachedPublicHostname = canonicalName;
                                }
                            }
                            catch (UnknownHostException e) {
                                log.log(Level.WARNING, "Could not call InetAddress.getLocalhost; using 127.0.0.1", e);
                            }
                        }
                        if (cachedPublicHostname == null && !StringUtils.isEmpty(rawHostname)) {
                            cachedPublicHostname = rawHostname;
                            log.info("No valid hostname could be found; will use the raw public host address '" + cachedPublicHostname + "' from the instance metadata.");
                        }
                        if (cachedPublicHostname == null) {
                            cachedPublicHostname = InstanceMetadata.getPublicIPv4();
                            log.info("No valid hostname could be found; will use the raw IP address '" + cachedPublicHostname + "' from the instance metadata.");
                        }
                    }
                    result = cachedPublicHostname;
                } else {
                    result = rawHostname;
                }
                return result;
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Could not get EC2 hostname; will use traditional hostname lookup process.");
                return Hostname.getPublicHostname();
            }
        }
        return LocalhostLookup.getLocalhostName();
    }

    private static boolean validateDnsName(String candidate, String sourceDescription) {
        String publicIPv4;
        try {
            publicIPv4 = InstanceMetadata.getPublicIPv4();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not get public IP address; validation cannot proceed.", e);
            return false;
        }
        try {
            InetAddress[] dnsLookups;
            for (InetAddress dnsLookup : dnsLookups = InetAddress.getAllByName(candidate)) {
                if (dnsLookup.getHostAddress().equals(publicIPv4)) {
                    log.info("Hostname '" + candidate + "' from " + sourceDescription + " is reachable via DNS; will use that as public hostname.");
                    return true;
                }
                log.info("Hostname '" + candidate + "' from " + sourceDescription + " does not resolve to public IP address of " + publicIPv4);
            }
            return false;
        }
        catch (UnknownHostException e) {
            log.log(Level.WARNING, "Hostname '" + candidate + " from " + sourceDescription + " is not a valid DNS name.");
            return false;
        }
    }
}

