/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.ws;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class SOAPLoggingHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger log = Logger.getLogger(SOAPLoggingHandler.class.getName());
    private String lastInboundMsg;
    private String lastOutboundMsg;
    private Level loggingLevel;
    private boolean prettyPrint = false;
    private static SOAPLoggingHandler handler;

    public void setLoggingLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public static SOAPLoggingHandler newInstance(Level loggingLevel, boolean prettyPrint) {
        if (handler == null) {
            handler = new SOAPLoggingHandler(loggingLevel, prettyPrint);
        }
        return handler;
    }

    public static SOAPLoggingHandler newInstance(Level loggingLevel) {
        if (handler == null) {
            handler = new SOAPLoggingHandler(loggingLevel);
        }
        return handler;
    }

    public static SOAPLoggingHandler newInstance() {
        if (handler == null) {
            handler = new SOAPLoggingHandler();
        }
        return handler;
    }

    public SOAPLoggingHandler() {
        this(Level.FINE);
    }

    public SOAPLoggingHandler(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public SOAPLoggingHandler(Level loggingLevel, boolean prettyPrint) {
        this.loggingLevel = loggingLevel;
        this.prettyPrint = prettyPrint;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        try {
            this.logToSystemOut(smc);
        }
        catch (Exception e) {
            String errMsg = "An error occurred while logging a SOAP message";
            log.log(Level.WARNING, errMsg, e);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext smc) {
        try {
            this.logToSystemOut(smc);
        }
        catch (Exception e) {
            String errMsg = "An error occurred while logging a SOAP fault";
            log.log(Level.WARNING, errMsg, e);
        }
        return true;
    }

    public void close(MessageContext mc) {
    }

    public String getLastInboundMsg() {
        return this.lastInboundMsg;
    }

    public void setLastInboundMsg(String lastInboundMsg) {
        this.lastInboundMsg = lastInboundMsg;
    }

    public String getLastOutboundMsg() {
        return this.lastOutboundMsg;
    }

    public void setLastOutboundMsg(String lastOutboundMsg) {
        this.lastOutboundMsg = lastOutboundMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logToSystemOut(SOAPMessageContext smc) throws XMLStreamException, IOException, SOAPException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        try (PrintStream outputStream = new PrintStream(byteArrayOutputStream);){
            String messageAsString;
            SOAPMessage m = smc.getMessage();
            m.writeTo((OutputStream)outputStream);
            if (this.prettyPrint) {
                StringReader reader = new StringReader(byteArrayOutputStream.toString());
                StringWriter writer = new StringWriter();
                try {
                    try {
                        this.prettyPrintXML(new StreamSource(reader), new StreamResult(writer));
                    }
                    catch (TransformerException e) {
                        throw new WebServiceException("An error occurred while pretty printing XML", (Throwable)e);
                    }
                    messageAsString = writer.toString();
                }
                finally {
                    reader.close();
                    writer.close();
                }
            }
            messageAsString = byteArrayOutputStream.toString();
            log.log(this.loggingLevel, messageAsString);
            if (!outboundProperty.booleanValue()) {
                this.setLastInboundMsg(messageAsString);
            } else {
                this.setLastOutboundMsg(messageAsString);
            }
        }
    }

    private void prettyPrintXML(Source source, Result result) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("indent-number", 4);
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }
}

