/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class ResizableGridLayout
implements LayoutManager2 {
    private static final Logger log = Logger.getLogger(ResizableGridLayout.class.getName());
    public static final int HORIZONTAL_FIRST = 0;
    public static final int VERTICAL_FIRST = 1;
    private final boolean isHorizontal;
    private final boolean hasMaxItems;
    private final List components = new LinkedList();
    private final int maxItems;
    private final int hgap;
    private final int vgap;
    private boolean fillSpace = false;

    public ResizableGridLayout(int orientation, int hgap, int vgap) {
        this(orientation, 0, hgap, vgap);
    }

    public ResizableGridLayout(int orientation, int maxItems, int hgap, int vgap) {
        this.isHorizontal = orientation == 0;
        this.hasMaxItems = maxItems > 0;
        this.maxItems = maxItems;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void setFillSpace(boolean b) {
        this.fillSpace = b;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.components.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension result = this.hasMaxItems ? this.calculateSizeWithMaxItems(1) : this.calculateSizeWithVariableItems(1);
        log.finest("preferredLayoutSize; parent size is: " + parent.getSize() + "; result is " + result);
        return result;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension result = this.hasMaxItems ? this.calculateSizeWithMaxItems(0) : this.calculateSizeWithVariableItems(0);
        log.finest("minimumLayoutSize; parent size is: " + parent.getSize() + "; result is " + result);
        return result;
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        Dimension result = this.hasMaxItems ? this.calculateSizeWithMaxItems(2) : this.calculateSizeWithVariableItems(2);
        log.finest("maximumLayoutSize; parent size is: " + parent.getSize() + "; result is " + result);
        return result;
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.hasMaxItems) {
            this.doLayoutWithMaxItems(parent, this.maxItems, this.hasMaxItems);
        } else {
            this.doLayoutWithVariableItems(parent);
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.components.add(comp);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        log.finest("invalidateLayout");
    }

    private Dimension calculateSizeWithMaxItems(int sizeSetting) {
        int clusterMinorSize = 0;
        int totalMinorSize = 0;
        int itemsInCluster = 0;
        int[] majorSizes = new int[this.maxItems];
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            if (itemsInCluster == this.maxItems) {
                totalMinorSize += clusterMinorSize;
                clusterMinorSize = 0;
                itemsInCluster = 0;
            }
            Component c = (Component)it.next();
            int itemHeight = this.getItemHeight(c, sizeSetting) + this.vgap;
            int itemWidth = this.getItemWidth(c, sizeSetting) + this.hgap;
            if (this.isHorizontal) {
                if (itemWidth > majorSizes[itemsInCluster]) {
                    majorSizes[itemsInCluster] = itemWidth;
                }
                if (itemHeight > clusterMinorSize) {
                    clusterMinorSize = itemHeight;
                }
            } else {
                if (itemHeight > majorSizes[itemsInCluster]) {
                    majorSizes[itemsInCluster] = itemHeight;
                }
                if (itemWidth > clusterMinorSize) {
                    clusterMinorSize = itemWidth;
                }
            }
            ++itemsInCluster;
        }
        totalMinorSize += clusterMinorSize;
        int totalMajorSize = 0;
        for (int n = 0; n < majorSizes.length; ++n) {
            totalMajorSize += majorSizes[n];
        }
        Dimension result = this.isHorizontal ? new Dimension(totalMajorSize - this.hgap, totalMinorSize - this.vgap) : new Dimension(totalMinorSize - this.hgap, totalMajorSize - this.vgap);
        return result;
    }

    private Dimension calculateSizeWithVariableItems(int sizeSetting) {
        int totalHeight = 0;
        int totalWidth = 0;
        for (Component c : this.components) {
            int itemHeight = this.getItemHeight(c, sizeSetting) + this.vgap;
            int itemWidth = this.getItemWidth(c, sizeSetting) + this.hgap;
            if (this.isHorizontal) {
                totalWidth += itemWidth;
                if (itemHeight <= totalHeight) continue;
                totalHeight = itemHeight;
                continue;
            }
            totalHeight += itemHeight;
            if (itemWidth <= totalWidth) continue;
            totalWidth = itemWidth;
        }
        return new Dimension(totalWidth - this.hgap, totalHeight - this.vgap);
    }

    private void doLayoutWithVariableItems(Container parent) {
        int containerMajorSize = this.isHorizontal ? parent.getSize().width : parent.getSize().height;
        int firstRowSize = 0;
        int itemsPerCluster = 0;
        for (Component c : this.components) {
            if ((firstRowSize += this.isHorizontal ? this.getItemWidth(c, 0) : this.getItemHeight(c, 0)) > containerMajorSize) break;
            firstRowSize += this.isHorizontal ? this.hgap : this.vgap;
            ++itemsPerCluster;
        }
        this.doLayoutWithMaxItems(parent, itemsPerCluster, false);
    }

    private void doLayoutWithMaxItems(Container parent, int itemsPerCluster, boolean areItemsFixed) {
        int itemHeight;
        int itemWidth;
        Component c;
        int majorAxisCalcLimit = this.isHorizontal ? parent.getSize().width : parent.getSize().height;
        int minorAxisCalcLimit = this.isHorizontal ? parent.getSize().height : parent.getSize().width;
        LinkedList<Integer> clusterMinorSizes = new LinkedList<Integer>();
        int clusterMinorSize = 0;
        int totalMinorSize = 0;
        int totalMajorSize = 0;
        int majorGapPerCluster = (itemsPerCluster - 1) * (this.isHorizontal ? this.hgap : this.vgap);
        int[] minClusterSizes = new int[itemsPerCluster];
        int itemsInCluster = 0;
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            int cellMinorSize;
            if (itemsInCluster == itemsPerCluster) {
                totalMinorSize += clusterMinorSize + (this.isHorizontal ? this.vgap : this.hgap);
                clusterMinorSizes.add(new Integer(clusterMinorSize));
                log.finest("New row/column: " + clusterMinorSize);
                clusterMinorSize = 0;
                itemsInCluster = 0;
                if (totalMinorSize >= minorAxisCalcLimit) break;
            }
            c = (Component)it.next();
            itemWidth = c.getMinimumSize().width;
            itemHeight = c.getMinimumSize().height;
            int cellMajorSize = this.isHorizontal ? itemWidth : itemHeight;
            int n = cellMinorSize = this.isHorizontal ? itemHeight : itemWidth;
            if (cellMajorSize > minClusterSizes[itemsInCluster]) {
                if (itemsPerCluster > 1 && !areItemsFixed && (totalMajorSize += cellMajorSize - minClusterSizes[itemsInCluster]) + majorGapPerCluster > majorAxisCalcLimit) {
                    this.doLayoutWithMaxItems(parent, --itemsPerCluster, false);
                    return;
                }
                minClusterSizes[itemsInCluster] = cellMajorSize;
            }
            if (cellMinorSize > clusterMinorSize) {
                clusterMinorSize = cellMinorSize;
            }
            ++itemsInCluster;
        }
        clusterMinorSizes.add(new Integer(clusterMinorSize));
        Iterator minorClusterSizeIterator = clusterMinorSizes.iterator();
        totalMinorSize = 0;
        int x = 0;
        int y = 0;
        int minorSize = (Integer)minorClusterSizeIterator.next();
        itemsInCluster = 0;
        Iterator it2 = this.components.iterator();
        while (it2.hasNext()) {
            if (itemsInCluster == itemsPerCluster) {
                if (this.isHorizontal) {
                    totalMinorSize += minorSize + this.vgap;
                    y += minorSize + this.vgap;
                    x = 0;
                } else {
                    totalMinorSize += minorSize + this.hgap;
                    x += minorSize + this.hgap;
                    y = 0;
                }
                if (totalMinorSize >= minorAxisCalcLimit) break;
                minorSize = (Integer)minorClusterSizeIterator.next();
                itemsInCluster = 0;
            }
            c = (Component)it2.next();
            if (this.isHorizontal) {
                itemWidth = minClusterSizes[itemsInCluster];
                c.setBounds(x, y, itemWidth, minorSize);
                x += itemWidth + this.hgap;
            } else {
                itemHeight = minClusterSizes[itemsInCluster];
                c.setBounds(x, y, minorSize, itemHeight);
                y += itemHeight + this.vgap;
            }
            ++itemsInCluster;
        }
    }

    private int getItemHeight(Component c, int sizeSetting) {
        if (sizeSetting == 1) {
            return c.getPreferredSize().height;
        }
        if (sizeSetting == 0) {
            return c.getMinimumSize().height;
        }
        return c.getMaximumSize().height;
    }

    private int getItemWidth(Component c, int sizeSetting) {
        if (sizeSetting == 1) {
            return c.getPreferredSize().width;
        }
        if (sizeSetting == 0) {
            return c.getMinimumSize().width;
        }
        return c.getMaximumSize().width;
    }
}

