/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.Component;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class PropertyListCellRenderer
extends DefaultListCellRenderer {
    private static final Logger log = Logger.getLogger(PropertyListCellRenderer.class.getName());
    private String propertyName;
    private Class lastClass = null;
    private PropertyDescriptor lastDescriptor = null;
    private Object[] noArgs = new Object[0];

    public PropertyListCellRenderer(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Object o = this.getReplacementValue(value);
        String newValue = o == null ? null : o.toString();
        return super.getListCellRendererComponent((JList<?>)list, newValue, index, isSelected, cellHasFocus);
    }

    private Object getReplacementValue(Object oldValue) {
        if (oldValue == null) {
            return "";
        }
        try {
            if (oldValue.getClass() != this.lastClass) {
                PropertyDescriptor[] descriptors;
                for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(oldValue.getClass()).getPropertyDescriptors()) {
                    if (!this.propertyName.equals(descriptor.getName())) continue;
                    this.lastDescriptor = descriptor;
                    this.lastClass = oldValue.getClass();
                    break;
                }
                if (this.lastDescriptor == null) {
                    throw new IllegalArgumentException("Could not find a property descriptor named \"" + this.propertyName + "\" for Class: " + oldValue.getClass());
                }
            }
            return this.lastDescriptor.getReadMethod().invoke(oldValue, this.noArgs);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not get replacementValue for " + oldValue, e);
            return oldValue;
        }
    }
}

