/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.format.ByteLengthFormat;
import java.awt.EventQueue;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class InputStreamRangeModel
extends FilterInputStream
implements BoundedRangeModel {
    private static final Logger log = Logger.getLogger(InputStreamRangeModel.class.getName());
    private EventListenerList changeListeners = new EventListenerList();
    private boolean valueIsAdjusting;
    private int extent;
    private int maximum;
    private long position = 0L;
    private int nextUpdate;
    private int zoomFactor;
    private long startedRead = -1L;
    private boolean finished = false;

    public InputStreamRangeModel(InputStream in) throws IOException {
        this(in, in.available());
    }

    public InputStreamRangeModel(InputStream in, long length) {
        super(in);
        if (length > Integer.MAX_VALUE) {
            this.zoomFactor = (int)Math.ceil((double)length / 2.147483647E9);
            this.maximum = (int)(length / (long)this.zoomFactor);
        } else {
            this.zoomFactor = 1;
            this.maximum = (int)length;
        }
        this.nextUpdate = this.extent = this.maximum / 100;
        log.finest("--> InputStreamRangeModel " + System.identityHashCode(this) + " was created");
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMinimum(int newMinimum) {
        if (newMinimum != 0) {
            this.ignoreMutation();
        }
    }

    @Override
    public synchronized int getMaximum() {
        return this.maximum;
    }

    @Override
    public synchronized void setMaximum(int newMaximum) {
        this.maximum = newMaximum;
    }

    @Override
    public synchronized int getValue() {
        return (int)(this.position / (long)this.zoomFactor);
    }

    @Override
    public void setValue(int newValue) {
        this.ignoreMutation();
    }

    @Override
    public synchronized void setValueIsAdjusting(boolean b) {
        this.valueIsAdjusting = b;
    }

    @Override
    public synchronized boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    @Override
    public synchronized int getExtent() {
        return this.extent;
    }

    @Override
    public synchronized void setExtent(int newExtent) {
        this.extent = newExtent;
    }

    @Override
    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
        this.ignoreMutation();
    }

    @Override
    public synchronized void addChangeListener(ChangeListener x) {
        this.changeListeners.add(ChangeListener.class, x);
    }

    @Override
    public synchronized void removeChangeListener(ChangeListener x) {
        this.changeListeners.remove(ChangeListener.class, x);
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.startedRead == -1L) {
            this.startedRead = System.currentTimeMillis();
        }
        if ((result = super.read()) == -1) {
            if (!this.finished) {
                this.finished = true;
                this.streamFinished();
            }
        } else {
            this.reposition(1L);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        if (this.startedRead == -1L) {
            this.startedRead = System.currentTimeMillis();
        }
        if ((result = super.read(b, off, len)) == -1) {
            if (!this.finished) {
                this.finished = true;
                this.streamFinished();
            }
        } else {
            this.reposition(result);
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = super.skip(n);
        this.reposition(result);
        return result;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        log.finest("<-- InputStreamRangeModel " + System.identityHashCode(this) + " was closed");
        Object[] list = this.changeListeners.getListenerList();
        Object[] listenersToRemove = new Object[list.length];
        System.arraycopy(list, 0, listenersToRemove, 0, listenersToRemove.length);
        for (int i = listenersToRemove.length - 2; i >= 0; i -= 2) {
            this.changeListeners.remove((Class)listenersToRemove[i], (EventListener)listenersToRemove[i + 1]);
        }
        try {
            super.close();
        }
        finally {
            if (!this.finished) {
                this.finished = true;
                this.streamFinished();
            }
        }
    }

    public synchronized int getBytesPerSecond() {
        long duration = System.currentTimeMillis() - this.startedRead;
        if (this.startedRead == -1L || duration == 0L) {
            return 0;
        }
        return (int)(this.position * 1000L / duration);
    }

    public synchronized Long getEstimatedTimeRemaining() {
        if (this.startedRead == -1L) {
            return null;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - this.startedRead;
        float finishedPortion = (float)this.position / (float)this.maximum;
        return (long)((float)elapsed / finishedPortion);
    }

    protected void streamFinished() {
    }

    private synchronized void reposition(long i) {
        this.position += i;
        if (!this.valueIsAdjusting && this.position >= (long)this.nextUpdate) {
            this.nextUpdate += this.extent;
            if (this.changeListeners.getListenerCount() > 0) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChangeEvent event = new ChangeEvent(InputStreamRangeModel.this);
                        Object[] array = InputStreamRangeModel.this.changeListeners.getListenerList();
                        for (int i = array.length - 2; i >= 0; i -= 2) {
                            if (array[i] != ChangeListener.class) continue;
                            ((ChangeListener)array[i + 1]).stateChanged(event);
                        }
                    }
                });
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Bytes per second: " + new ByteLengthFormat().format(this.getBytesPerSecond()) + "; estimated time remaining: " + this.getEstimatedTimeRemaining() / 1000L + " seconds (" + new Date(System.currentTimeMillis() + this.getEstimatedTimeRemaining()) + ")");
            }
        }
    }

    private void ignoreMutation() {
        log.log(Level.WARNING, "Ignored attempt to modify InputStreamRangeModel");
    }
}

