/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DraggableGlassPanel
extends JPanel
implements AWTEventListener {
    private final JFrame frame;
    private Point point = new Point();
    private int rectWidth;
    private int initialMousePosition;

    public DraggableGlassPanel(JFrame frame) {
        super(null);
        this.frame = frame;
        this.setOpaque(false);
    }

    public void setRectWidth(int rectWidth) {
        this.rectWidth = rectWidth;
    }

    public void setInitialMouseEvent(MouseEvent e) {
        this.setPoint(e);
        this.initialMousePosition = e.getPoint().x;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.point != null) {
            int h = 14;
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.GRAY.darker().darker());
            g2.setStroke(new BasicStroke(3.0f));
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            g2.drawRect(this.point.x - this.initialMousePosition, this.point.y - h / 2, this.rectWidth, h);
            g2.dispose();
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            if (!SwingUtilities.isDescendingFrom(me.getComponent(), this.frame)) {
                return;
            }
            this.setPoint(me);
            this.repaint();
        }
    }

    private MouseEvent setPoint(MouseEvent me) {
        if (me.getID() == 505 && me.getComponent() == this.frame) {
            this.point = null;
            return me;
        }
        MouseEvent converted = SwingUtilities.convertMouseEvent(me.getComponent(), me, this.frame.getGlassPane());
        this.point = converted.getPoint();
        return converted;
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.getMouseListeners().length == 0 && this.getMouseMotionListeners().length == 0 && this.getMouseWheelListeners().length == 0 && this.getCursor() == Cursor.getPredefinedCursor(0)) {
            return false;
        }
        return super.contains(x, y);
    }
}

