/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.exception.UserCanceledException;
import com.prosc.io.ProcessExecutionException;
import com.prosc.io.ProcessUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Hostname {
    private static final Logger log = Logger.getLogger(Hostname.class.getName());
    private static String publicHostname;

    public static String getPublicHostname() {
        if (publicHostname == null) {
            publicHostname = Hostname._getPublicHostname();
        }
        return publicHostname;
    }

    private static String _getPublicHostname() {
        InetAddress localhost;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.log(Level.WARNING, "Could not call InetAddress.getLocalhost; using 127.0.0.1", e);
            return "127.0.0.1";
        }
        try {
            InetAddress[] dnsLookups;
            String osName = new String(ProcessUtils.doShellCommand(new String[]{"hostname"}, null, null)).replace("\n", "").replace("\r", "");
            for (InetAddress dnsLookup : dnsLookups = InetAddress.getAllByName(osName)) {
                if (!Arrays.equals(dnsLookup.getAddress(), localhost.getAddress())) continue;
                log.info("Operating system hostname '" + osName + "' is reachable via DNS; will use that as public hostname.");
                return osName;
            }
        }
        catch (ProcessExecutionException e) {
            log.log(Level.WARNING, "Could not execute the hostname OS function; will fall back to built-in Java functions", e);
        }
        catch (UserCanceledException e) {
            log.log(Level.WARNING, "User canceled while attempting to call os hostname function; will fall back to getCanonicalHostName instead", e);
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not run a DNS lookup; will fall back to built-in Java functions", e);
        }
        String result = localhost.getCanonicalHostName();
        log.info("Canonical hostname returns '" + result + "'; will use that for public hostname");
        return result;
    }
}

