/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import com.prosc.format.SecondsDurationFormatter;
import java.io.PrintStream;
import java.text.NumberFormat;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AsciiProgressBar {
    private final BoundedRangeModel rangeModel;
    private final PrintStream out = System.out;
    private final StringBuilder statusBar;
    private final NumberFormat nf = NumberFormat.getNumberInstance();
    private int oldPercent;
    private long start;
    private SecondsDurationFormatter tdf = new SecondsDurationFormatter(true);
    private long lastUpdate;

    public AsciiProgressBar(int max) {
        this(new DefaultBoundedRangeModel(0, 0, 0, max));
    }

    private AsciiProgressBar(BoundedRangeModel rangeModel) {
        this.statusBar = new StringBuilder(32);
        for (int i = 0; i < this.statusBar.capacity(); ++i) {
            this.statusBar.append(' ');
        }
        this.statusBar.setCharAt(0, '>');
        this.rangeModel = rangeModel;
        this.rangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AsciiProgressBar.this.updateStatusLine();
            }
        });
    }

    private void updateStatusLine() {
        int newPercent;
        long now = System.currentTimeMillis();
        if (this.start == 0L) {
            this.start = now;
        }
        if ((newPercent = this.rangeModel.getValue() * 100 / this.rangeModel.getMaximum()) != this.oldPercent || now > this.lastUpdate + 1000L) {
            int startIndex = this.oldPercent * this.statusBar.capacity() / 100;
            int endIndex = Math.min(this.statusBar.capacity(), newPercent * this.statusBar.capacity() / 100);
            for (int index = startIndex; index < endIndex; ++index) {
                this.statusBar.setCharAt(index, '=');
                if (index >= this.statusBar.capacity() - 1) continue;
                this.statusBar.setCharAt(index + 1, '>');
            }
            this.oldPercent = newPercent;
            String additionalInfo = this.additionalInfo();
            String s = String.format("%3d%% [%s] %s ", newPercent, this.statusBar, additionalInfo == null ? "" : additionalInfo);
            this.out.print("\r");
            this.out.print(s);
            if (newPercent == 100) {
                this.out.print("\n");
            }
            this.lastUpdate = now;
        }
    }

    protected String additionalInfo() {
        String counts = this.nf.format(this.getRangeModel().getValue()) + " of " + this.nf.format(this.getRangeModel().getMaximum());
        long elapsed = System.currentTimeMillis() - this.start;
        double secondsPerRecord = (double)elapsed / (double)this.rangeModel.getValue();
        double remainingMillis = secondsPerRecord * (double)(this.rangeModel.getMaximum() - this.rangeModel.getValue());
        boolean isDone = this.rangeModel.getValue() >= this.rangeModel.getMaximum();
        String eta = isDone ? "elapsed " + this.tdf.format(elapsed / 1000L) : "eta " + this.tdf.format(remainingMillis / 1000.0);
        return counts + " " + eta;
    }

    public final BoundedRangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void increment() {
        this.getRangeModel().setValue(this.getRangeModel().getValue() + 1);
    }
}

