/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.xml;

import com.prosc.shared.Bool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class DomUtils {
    private static final Logger log = Logger.getLogger(DomUtils.class.getName());
    public static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public static String getRecursiveChildText(Element xml, String childTag) {
        NodeList nodeList = xml.getElementsByTagName(childTag);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0).getTextContent();
    }

    public static String getChildText(@NotNull Element xml) {
        if (xml == null) {
            DomUtils.$$$reportNull$$$0(0);
        }
        return xml.getFirstChild().getTextContent();
    }

    public static String getChildText(@Nullable Element xml, String childTag) {
        return DomUtils.getChildText(xml, childTag, true);
    }

    public static String getChildText(@Nullable Element xml, String childTag, boolean validateThatRecursiveCallMatches) {
        String recursiveResult;
        String result;
        Iterator<Element> elementsByTagName = DomUtils.getChildElements((Node)xml, childTag).iterator();
        if (elementsByTagName.hasNext()) {
            Element next = elementsByTagName.next();
            result = next.getTextContent();
        } else {
            result = null;
        }
        if (validateThatRecursiveCallMatches && !Bool.equals(result, recursiveResult = DomUtils.getRecursiveChildText(xml, childTag))) {
            log.log(Level.INFO, "Recursive result for child tag '" + childTag + "' is not the same as shallow result. This is not generally a problem, but it could be for legacy classes that assumed that all calls are recursive.\nShallow result: " + result + "\nRecursive result: " + recursiveResult + "\nXML input: " + DomUtils.dumpXml(xml.getOwnerDocument(), xml), new RuntimeException("Stack trace"));
        }
        return result;
    }

    public static Iterable<Element> getChildElements(@Nullable Node parent, String ... childNames) {
        if (parent == null) {
            return Collections.emptyList();
        }
        LinkedList<Element> result = new LinkedList<Element>();
        DomUtils.getChildElements(parent, result, childNames);
        return result;
    }

    private static void getChildElements(@NotNull Node parent, List<Element> result, String ... childName) {
        if (parent == null) {
            DomUtils.$$$reportNull$$$0(1);
        }
        String[] descendents = null;
        if (childName != null && childName.length > 1) {
            descendents = new String[childName.length - 1];
            System.arraycopy(childName, 1, descendents, 0, descendents.length);
        }
        NodeList nodeList = parent.getChildNodes();
        for (int n = 0; n < nodeList.getLength(); ++n) {
            Node item = nodeList.item(n);
            if (!(item instanceof Element)) continue;
            if (childName == null) {
                result.add((Element)item);
                continue;
            }
            if (!item.getNodeName().equals(childName[0])) continue;
            if (childName.length == 1) {
                result.add((Element)item);
                continue;
            }
            DomUtils.getChildElements(item, result, descendents);
        }
    }

    public static Iterable<Element> getChildElements(@Nullable Node parent) {
        return DomUtils.getChildElements(parent, (String[])null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String dumpXml(@NotNull Element element) {
        if (element == null) {
            DomUtils.$$$reportNull$$$0(2);
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            try (StringWriter sw = new StringWriter();){
                transformer.transform(new DOMSource(element), new StreamResult(sw));
                String string = sw.toString();
                return string;
            }
        }
        catch (IOException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static String dumpXml(Document document, @Nullable Element element) {
        return DomUtils.dumpXml(element);
    }

    public static Document parse(InputStream xml, Charset charset) throws SAXParseException {
        return DomUtils.parse(new InputSource(new InputStreamReader(xml, charset)));
    }

    public static Document parse(File xml, Charset charset) throws SAXParseException, IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(xml), charset);){
            Document document = DomUtils.parse(new InputSource(reader));
            return document;
        }
    }

    public static Document parse(String xml) throws SAXParseException {
        return DomUtils.parse(new InputSource(new StringReader(xml)));
    }

    public static Document parse(InputSource xml) throws SAXParseException {
        try {
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            return documentBuilder.parse(xml);
        }
        catch (SAXParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/prosc/xml/DomUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpXml";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

