/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing.editors;

import com.prosc.swing.editors.GenericEditor;
import java.beans.PropertyChangeEvent;

public abstract class NumberEditor
extends GenericEditor {
    private Number value = null;

    @Override
    public final void setValue(Object value) {
        this.value = (Number)value;
    }

    @Override
    public final Object getValue() {
        return this.value;
    }

    @Override
    public final String getAsText() {
        return this.value == null ? "" : this.value.toString();
    }

    @Override
    public final void setAsText(String text) throws IllegalArgumentException {
        Number oldValue = this.value;
        if (text == null || text.length() == 0) {
            this.value = null;
        } else {
            try {
                this.value = this.parseNumber(text);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(text + " cannot be parsed as a number", e);
            }
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, oldValue, this.value);
        this.firePropertyChangeEvent(evt);
    }

    protected abstract Number parseNumber(String var1) throws NumberFormatException;
}

