/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class TwoColumnTableLayout
extends GridBagLayout {
    public static final Object SPAN_BOTH_COLUMNS = 1;
    private GridBagConstraints labels = new GridBagConstraints();
    private GridBagConstraints fields;
    private GridBagConstraints twoColumnSpan;
    private boolean isLabel = true;

    public TwoColumnTableLayout(Insets fieldInsets) {
        this.labels.anchor = 13;
        this.fields = new GridBagConstraints();
        this.fields.anchor = 17;
        this.fields.fill = 1;
        this.fields.gridwidth = 0;
        this.fields.weightx = 1.0;
        if (fieldInsets != null) {
            this.fields.insets = fieldInsets;
        }
        this.twoColumnSpan = new GridBagConstraints();
        this.twoColumnSpan.anchor = 17;
        this.twoColumnSpan.fill = 1;
        this.twoColumnSpan.gridwidth = 0;
        this.twoColumnSpan.weightx = 1.0;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        super.addLayoutComponent(name, comp);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (SPAN_BOTH_COLUMNS.equals(constraints)) {
            if (!this.isLabel) {
                throw new IllegalArgumentException("Cannot span two columns unless we are on a label column");
            }
            super.addLayoutComponent(comp, this.twoColumnSpan);
        } else if (this.isLabel) {
            super.addLayoutComponent(comp, this.labels);
            this.isLabel = !this.isLabel;
        } else {
            super.addLayoutComponent(comp, this.fields);
            this.isLabel = !this.isLabel;
        }
    }
}

