/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.swing.Filter;
import com.prosc.swing.TextFilterable;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFilterableListModel<E>
implements ListModel<E>,
TextFilterable,
ListDataListener {
    private final ListModel<E> delegate;
    private final Filter<E> filter;
    private final List<E> filteredList = new ArrayList();
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    @Nullable
    private String filterText;
    private boolean narrowing = false;

    public TextFilterableListModel(ListModel<E> delegate, Filter<E> filter) {
        this.delegate = delegate;
        this.filter = filter;
        delegate.addListDataListener(this);
    }

    @Override
    public int getSize() {
        return this.filteredList.size();
    }

    @Override
    public void filter(@NotNull String filterText, boolean narrowing) {
        if (filterText == null) {
            TextFilterableListModel.$$$reportNull$$$0(0);
        }
        this.filterText = filterText;
        this.narrowing = narrowing;
        this.checkFilter();
    }

    private void checkFilter() {
        if (this.narrowing) {
            if (this.filterText != null) {
                Iterator<E> iterator = this.filteredList.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    E candidate = iterator.next();
                    if (candidate == null || !this.filter.matches(candidate, this.filterText)) {
                        iterator.remove();
                        ListDataEvent singleRemoveEvent = new ListDataEvent(this, 2, index, index);
                        EventQueue.invokeLater(() -> {
                            for (ListDataListener listener : this.listeners) {
                                listener.intervalRemoved(singleRemoveEvent);
                            }
                        });
                    }
                    ++index;
                }
            }
        } else {
            if (this.filteredList.size() > 0) {
                ListDataEvent removeAllEvent = new ListDataEvent(this, 2, 0, this.filteredList.size() - 1);
                EventQueue.invokeLater(() -> {
                    for (ListDataListener listener : this.listeners) {
                        listener.intervalRemoved(removeAllEvent);
                    }
                });
                this.filteredList.clear();
            }
            for (int n = 0; n < this.delegate.getSize(); ++n) {
                if (Thread.interrupted()) {
                    return;
                }
                E elementAt = this.delegate.getElementAt(n);
                if (elementAt == null || this.filterText != null && !this.filter.matches(elementAt, this.filterText)) continue;
                this.filteredList.add(elementAt);
            }
            if (this.filteredList.size() > 0) {
                ListDataEvent addAllEvent = new ListDataEvent(this, 1, 0, this.filteredList.size() - 1);
                EventQueue.invokeLater(() -> {
                    for (ListDataListener listener : this.listeners) {
                        listener.intervalRemoved(addAllEvent);
                    }
                });
            }
        }
    }

    @Override
    public E getElementAt(int index) {
        return this.filteredList.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.narrowing = false;
        this.checkFilter();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.narrowing = true;
        this.checkFilter();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.narrowing = false;
        this.checkFilter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterText", "com/prosc/swing/TextFilterableListModel", "filter"));
    }
}

