/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.infrastructure.ClassUtils;
import com.prosc.shared.IdentityHashSet;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ProgressSpinnerIcon
extends JLabel {
    private final Set<Object> markers = new IdentityHashSet<Object>();

    public ProgressSpinnerIcon() {
        this.setSize(32, 32);
        this.setPreferredSize(new Dimension(32, 32));
        this.setIcon(ClassUtils.getResource(this.getClass(), "spinner32.gif").map(ImageIcon::new).orElse(null));
        this.setToolTipText("Operation in progress...");
        this.setOpaque(false);
    }

    public void start(Object marker) {
        Runnable runnable = () -> {
            this.markers.add(marker);
            this.repaint();
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public void stop(Object marker) {
        Runnable runnable = () -> {
            this.markers.remove(marker);
            this.repaint();
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.markers.isEmpty()) {
            super.paintComponent(g);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("Test");
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new JLabel("Start"));
        ProgressSpinnerIcon progressSpinnerIcon = new ProgressSpinnerIcon();
        progressSpinnerIcon.start(frame);
        frame.getContentPane().add(progressSpinnerIcon);
        frame.getContentPane().add(new JLabel("End"));
        frame.pack();
        frame.setVisible(true);
        Thread.sleep(5000L);
        progressSpinnerIcon.stop(frame);
    }
}

