/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class ProgressDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(ProgressDialog.class.getName());
    private final JLabel statusLabel = new JLabel(" ");
    private final JProgressBar progress = new JProgressBar();
    private JButton cancelButton;

    public ProgressDialog(Frame owner, String title, boolean modal, BoundedRangeModel model, boolean isCancellable) throws HeadlessException {
        super(owner, title, modal);
        if (model == null) {
            this.progress.setIndeterminate(true);
        } else {
            this.progress.setModel(model);
        }
        if (isCancellable) {
            String cancelMessage = UIManager.getString("OptionPane.cancelButtonText");
            this.cancelButton = new JButton(cancelMessage);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressDialog.this.dispose();
                }
            });
        }
        this.setDefaultCloseOperation(2);
        this.progress.setPreferredSize(new Dimension(400, this.progress.getPreferredSize().height));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.statusLabel, "North");
        this.getContentPane().add((Component)this.progress, "Center");
        if (isCancellable) {
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            buttonPanel.add(this.cancelButton);
            this.getContentPane().add((Component)buttonPanel, "South");
        }
    }

    public void setProgressValue(final int newValue) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progress.setValue(newValue);
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    public void setStatusMessage(final String message) {
        log.info("Setting status to: " + message);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.statusLabel.setText(message);
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }
}

