/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListModelWrapper<E>
implements List<E>,
ListModel<E>,
ComboBoxModel<E>,
TableModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<E> data;
    private transient EventListenerList listListeners = new EventListenerList();
    private E selectedItem;
    private boolean immutable;
    protected transient int modCount = 0;
    private transient LinkedList<ListSelectionListener> listSelectionListeners;
    private transient short disableCount = 0;
    private transient BitSet modifiedItems = null;

    public ListModelWrapper(List<E> data) {
        if (data == null) {
            throw new IllegalArgumentException("ListModelWrapper created with null value");
        }
        this.data = data;
    }

    public List<E> getWrappedList() {
        return this.data;
    }

    public void setWrappedList(List<E> newValue) {
        if (this.isImmutable()) {
            throw new UnsupportedOperationException("ListModelWrapper is immutable");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("setWrappedList called with null value");
        }
        int oldSize = this.data.size();
        this.data = newValue;
        this.fireListEvent(0, 0, oldSize - 1);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    private void checkMutable() {
        if (this.immutable) {
            throw new UnsupportedOperationException("ListModelWrapper is immutable");
        }
        ++this.modCount;
    }

    public void enableListEvents(boolean isEnabled) {
        if (isEnabled) {
            if (this.disableCount > 0) {
                this.disableCount = (short)(this.disableCount - 1);
                if (this.disableCount == 0) {
                    this.fireListEvent(0, 0, this.data.size() - 1);
                    this.modifiedItems = null;
                }
            }
        } else {
            if (this.disableCount == 0) {
                this.modifiedItems = new BitSet(this.size());
            }
            this.disableCount = (short)(this.disableCount + 1);
        }
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        try {
            this.enableListEvents(false);
            Collections.sort(this.data, comparator);
        }
        finally {
            this.enableListEvents(true);
        }
    }

    @Override
    public boolean add(@Nullable E o) {
        this.checkMutable();
        boolean result = this.data.add(o);
        int index = this.data.size() - 1;
        this.fireListEvent(1, index, index);
        return result;
    }

    @Override
    public void add(int index, @Nullable E element) {
        this.checkMutable();
        this.data.add(index, element);
        this.fireListEvent(1, index, index);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        int index = this.data.size();
        int index2 = index + c.size() - 1;
        this.checkMutable();
        boolean result = this.data.addAll(c);
        this.fireListEvent(1, index, index2);
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        int index2 = index + c.size() - 1;
        this.checkMutable();
        boolean result = this.data.addAll(index, c);
        this.fireListEvent(1, index, index2);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.data.indexOf(o);
        this.checkMutable();
        boolean result = this.data.remove(o);
        if (result) {
            this.fireListEvent(2, index, index);
        }
        return result;
    }

    @Override
    public E remove(int index) {
        this.checkMutable();
        E result = this.data.remove(index);
        if (result != null) {
            this.fireListEvent(2, index, index);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        this.checkMutable();
        for (Object o : c) {
            E removed;
            int index = this.data.indexOf(o);
            if (index == -1 || (removed = this.remove(index)) == null) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            ListModelWrapper.$$$reportNull$$$0(0);
        }
        this.checkMutable();
        for (E aData : this.data) {
            if (c.contains(aData)) continue;
            int index = this.data.indexOf(aData);
            this.fireListEvent(2, index, index);
        }
        return this.data.retainAll(c);
    }

    @Override
    public void clear() {
        if (this.data.size() == 0) {
            return;
        }
        this.checkMutable();
        this.fireListEvent(2, 0, this.data.size() - 1);
        this.data.clear();
    }

    @Override
    public E set(int index, E element) {
        this.checkMutable();
        E result = this.data.set(index, element);
        this.fireListEvent(0, index, index);
        return result;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public Object[] toArray(@NotNull Object[] a) {
        if (a == null) {
            ListModelWrapper.$$$reportNull$$$0(1);
        }
        return this.data.toArray(a);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            ListModelWrapper.$$$reportNull$$$0(2);
        }
        return this.data.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.data.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.data.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.data.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public E getElementAt(int index) {
        return this.data.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listListeners.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listListeners.remove(ListDataListener.class, l);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        if (this.listSelectionListeners == null) {
            this.listSelectionListeners = new LinkedList();
        }
        this.listSelectionListeners.add(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        if (this.listSelectionListeners != null) {
            this.listSelectionListeners.remove(listener);
        }
    }

    @Override
    public int getRowCount() {
        return this.getSize();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return String.valueOf(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public E getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        return this.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return;
        }
        this.set(rowIndex, aValue);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listListeners.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listListeners.remove(TableModelListener.class, l);
    }

    private void fireListEvent(int type, int index0, int index1) {
        if (this.disableCount > 0) {
            return;
        }
        Object[] listeners = this.listListeners.getListenerList();
        ListDataEvent listEvent = null;
        TableModelEvent tableEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == ListDataListener.class) {
                ListDataListener eachListListener = (ListDataListener)listeners[i + 1];
                if (listEvent == null) {
                    listEvent = new ListDataEvent(this, type, index0, index1);
                }
                switch (type) {
                    case 0: {
                        eachListListener.contentsChanged(listEvent);
                        break;
                    }
                    case 1: {
                        eachListListener.intervalAdded(listEvent);
                        break;
                    }
                    case 2: {
                        eachListListener.intervalRemoved(listEvent);
                    }
                }
                continue;
            }
            if (listeners[i] != TableModelListener.class) continue;
            TableModelListener eachTableListener = (TableModelListener)listeners[i + 1];
            if (tableEvent == null) {
                int tableEventType = type == 1 ? 1 : (type == 2 ? -1 : 0);
                tableEvent = new TableModelEvent(this, index0, index1, 0, tableEventType);
            }
            eachTableListener.tableChanged(tableEvent);
        }
    }

    public int getListenerCount() {
        return this.listListeners.getListenerCount();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem;
        if (this.listSelectionListeners != null) {
            for (ListSelectionListener listSelectionListener : this.listSelectionListeners) {
                int index = this.data.indexOf(anItem);
                ListSelectionEvent event = new ListSelectionEvent(this, index, index, false);
                listSelectionListener.valueChanged(event);
            }
        }
    }

    @Override
    public E getSelectedItem() {
        return this.selectedItem;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listListeners = new EventListenerList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        objectArray2[1] = "com/prosc/swing/ListModelWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "retainAll";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "toArray";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = ListModelWrapper.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ListModelWrapper.this.set(this.lastRet, o);
                this.expectedModCount = ListModelWrapper.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E o) {
            this.checkForComodification();
            try {
                ListModelWrapper.this.add(this.cursor++, o);
                this.lastRet = -1;
                this.expectedModCount = ListModelWrapper.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = ListModelWrapper.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ListModelWrapper.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                Object next = ListModelWrapper.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ListModelWrapper.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = ListModelWrapper.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (ListModelWrapper.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException("Mod count was " + ListModelWrapper.this.modCount + "; expected " + this.expectedModCount + ".");
            }
        }
    }
}

