/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.beans.BeanUtils;
import com.prosc.shared.StringUtils;
import com.prosc.swing.ListModelWrapper;
import com.prosc.swing.TextFilterable;
import java.awt.EventQueue;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBeanTableModel<T>
extends AbstractTableModel
implements TextFilterable {
    private String[] propertyNames;
    private Class<?>[] propertyTypes;
    private String[] columnHeaders;
    private Method[] getters;
    private Method[] setters;
    private ListModel<T> data;
    private ListModel<T> visibleData;
    private int columnCount;
    private ListDataListener dataListener;
    boolean readOnly;

    public JavaBeanTableModel(Class<T> beanClass, ListModel<T> data, String[] propertyNames) throws IntrospectionException {
        if (beanClass == null || propertyNames == null || data == null) {
            throw new IllegalArgumentException("You cannot pass a null as a parameter.");
        }
        this.propertyNames = propertyNames;
        this.init(beanClass, data);
    }

    public JavaBeanTableModel(Class<T> beanClass, @Nullable ListModel<T> data) {
        try {
            if (beanClass == null) {
                throw new IllegalArgumentException("You cannot pass a null as a parameter.");
            }
            if (data == null) {
                data = new ListModelWrapper<T>(new ArrayList(0));
            }
            PropertyDescriptor[] properties = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
            String[] names = new String[properties.length - 1];
            int m = 0;
            for (PropertyDescriptor property : properties) {
                if ("class".equals(property.getName())) continue;
                names[m] = property.getDisplayName();
                ++m;
            }
            this.propertyNames = names;
            this.init(beanClass, data);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private void init(Class<T> beanClass, ListModel<T> data) throws IntrospectionException {
        this.columnHeaders = new String[this.propertyNames.length];
        for (int i = 0; i < this.propertyNames.length; ++i) {
            String propertyName = this.propertyNames[i];
            this.columnHeaders[i] = StringUtils.beautifyAttributeName(propertyName);
        }
        this.columnCount = this.propertyNames.length;
        this.getters = new Method[this.columnCount];
        this.setters = new Method[this.columnCount];
        this.propertyTypes = new Class[this.columnCount];
        for (int n = 0; n < this.columnCount; ++n) {
            String eachPropertyName = this.propertyNames[n];
            PropertyDescriptor descriptor = BeanUtils.getPropertyNamed(beanClass, eachPropertyName);
            this.propertyTypes[n] = descriptor.getPropertyType();
            this.getters[n] = descriptor.getReadMethod();
            this.setters[n] = descriptor.getWriteMethod();
        }
        this.data = data;
        this.visibleData = data;
        this.dataListener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                JavaBeanTableModel.this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                JavaBeanTableModel.this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                JavaBeanTableModel.this.fireTableDataChanged();
            }
        };
        data.addListDataListener(new WeakListDataListener<T>(this.dataListener, data));
    }

    @Override
    public final int getRowCount() {
        return this.visibleData.getSize();
    }

    @Override
    public final int getColumnCount() {
        return this.columnCount;
    }

    public final T getValueForRow(int rowIndex) {
        return this.visibleData.getElementAt(rowIndex);
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        T whichObject = this.visibleData.getElementAt(rowIndex);
        Method getter = this.getters[columnIndex];
        try {
            return getter == null ? null : getter.invoke(whichObject, new Object[0]);
        }
        catch (Exception e) {
            this.getters[columnIndex] = null;
            throw new RuntimeException("Unable to invoke " + getter + " on " + whichObject, e);
        }
    }

    @Override
    public final String getColumnName(int column) {
        if (this.columnHeaders != null) {
            return this.columnHeaders[column];
        }
        return this.propertyNames[column];
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        Class<Object> type = this.propertyTypes[columnIndex];
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                type = Boolean.class;
            } else if (type == Byte.TYPE) {
                type = Byte.class;
            } else if (type == Character.TYPE) {
                type = Character.class;
            } else if (type == Short.TYPE) {
                type = Short.class;
            } else if (type == Integer.TYPE) {
                type = Integer.class;
            } else if (type == Float.TYPE) {
                type = Float.class;
            } else if (type == Double.TYPE) {
                type = Double.class;
            } else if (type == Long.TYPE) {
                type = Long.class;
            }
        }
        return type;
    }

    @Override
    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.readOnly) {
            return false;
        }
        return this.setters[columnIndex] != null;
    }

    public final void setColumnHeaders(String[] columnHeaders) {
        if (columnHeaders.length != this.columnCount) {
            throw new IllegalStateException("columnHeaders array has " + columnHeaders.length + " elements; expected " + this.columnCount);
        }
        this.columnHeaders = columnHeaders;
    }

    @Override
    public final void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.readOnly) {
            return;
        }
        T whichObject = this.visibleData.getElementAt(rowIndex);
        Method setter = this.setters[columnIndex];
        try {
            setter.invoke(whichObject, aValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke " + setter + " on " + whichObject + " with value " + aValue, e);
        }
    }

    public final ListModel<T> getData() {
        return this.data;
    }

    public final ListModel<T> getVisibleData() {
        return this.visibleData;
    }

    @Override
    public final void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public final void filter(@NotNull String filterText, boolean narrowing) {
        if (filterText == null) {
            JavaBeanTableModel.$$$reportNull$$$0(0);
        }
        if (filterText.length() == 0) {
            this.visibleData = this.data;
        } else {
            ListModel<T> startingSource = narrowing ? this.visibleData : this.data;
            ArrayList<T> filteredList = new ArrayList<T>(startingSource.getSize());
            for (int n = 0; n < startingSource.getSize(); ++n) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                T eachObject = startingSource.getElementAt(n);
                if (eachObject == null || !this.objectMatchesFilter(eachObject, filterText)) continue;
                filteredList.add(eachObject);
            }
            this.visibleData = new ListModelWrapper<T>(filteredList);
        }
        EventQueue.invokeLater(this::fireTableDataChanged);
    }

    protected boolean objectMatchesFilter(@NotNull T eachObject, String filterText) {
        if (eachObject == null) {
            JavaBeanTableModel.$$$reportNull$$$0(1);
        }
        return eachObject.toString().toLowerCase().contains(filterText.toLowerCase());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachObject";
                break;
            }
        }
        objectArray2[1] = "com/prosc/swing/JavaBeanTableModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "filter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "objectMatchesFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WeakListDataListener<T>
    implements ListDataListener {
        final WeakReference<ListDataListener> ref;
        final ListModel<T> data;

        public WeakListDataListener(ListDataListener listDataListener, ListModel<T> data) {
            this.ref = new WeakReference<ListDataListener>(listDataListener);
            this.data = data;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            ListDataListener l = this.getListenerOrNull();
            if (l != null) {
                l.intervalAdded(e);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ListDataListener l = this.getListenerOrNull();
            if (l != null) {
                l.intervalRemoved(e);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ListDataListener l = this.getListenerOrNull();
            if (l != null) {
                l.contentsChanged(e);
            }
        }

        public ListDataListener getListenerOrNull() {
            ListDataListener listener = (ListDataListener)this.ref.get();
            if (listener == null) {
                this.removeListener();
            }
            return listener;
        }

        private void removeListener() {
            this.data.removeListDataListener(this);
        }
    }
}

