/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.shared.ExceptionUtils;
import com.prosc.swing.TextFilterable;
import com.prosc.thread.MyThreadFactory;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class FilterControl {
    private final JTextField searchField;
    private final TextFilterable filterable;
    private String lastSearch;
    private boolean searchOnKeystroke;
    private ExecutorService worker;
    private Future<?> future;

    public FilterControl(@NotNull JTextField searchField, @NotNull TextFilterable model) {
        if (searchField == null) {
            FilterControl.$$$reportNull$$$0(0);
        }
        if (model == null) {
            FilterControl.$$$reportNull$$$0(1);
        }
        this.lastSearch = null;
        this.worker = null;
        this.future = null;
        this.searchField = searchField;
        this.filterable = model;
        searchField.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (FilterControl.this.worker != null) {
                    FilterControl.this.worker.shutdownNow();
                    FilterControl.this.worker = null;
                }
            }
        });
    }

    public FilterControl setSearchOnKeystroke(boolean searchOnKeystroke) {
        this.searchOnKeystroke = searchOnKeystroke;
        return this;
    }

    public void install() {
        this.searchField.addActionListener(evt -> {
            String currentSearch = this.searchField.getText() == null ? "" : this.searchField.getText();
            this.doSearch(currentSearch);
        });
        if (this.searchOnKeystroke) {
            final Document document = this.searchField.getDocument();
            document.addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FilterControl.this.doSearch(document);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FilterControl.this.doSearch(document);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FilterControl.this.doSearch(document);
                }
            });
        }
    }

    private void doSearch(Document document) {
        try {
            String currentSearch = document.getText(0, document.getLength());
            this.doSearch(currentSearch);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void doSearch(String currentSearch) {
        if (this.worker == null) {
            this.worker = Executors.newSingleThreadExecutor(new MyThreadFactory("FilterControl"));
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
        boolean narrowing = this.lastSearch == null || currentSearch.startsWith(this.lastSearch);
        this.lastSearch = currentSearch;
        this.future = this.worker.submit(() -> {
            try {
                this.filterable.filter(currentSearch, narrowing);
            }
            catch (Exception e) {
                ExceptionUtils.reportAndLogException(Level.SEVERE, this.searchField, e.getMessage(), e);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "searchField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/prosc/swing/FilterControl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

