/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public abstract class FMProgressDialog {
    private static JProgressBar progressBar;
    private JLabel label;
    private JDialog dialog;
    private static final Logger log;

    public FMProgressDialog(Component parentComponent, String title) {
        log.fine("Created FMProgressDialog " + System.identityHashCode(this));
        log.fine("FMProgressDialog constructor...");
        progressBar.setIndeterminate(false);
        progressBar.setModel(new DefaultBoundedRangeModel());
        progressBar.setValue(0);
        this.label = new JLabel("");
        final String cancelMessage = UIManager.getString("OptionPane.cancelButtonText");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.label);
        Object[] components = new Object[]{panel, progressBar};
        Object[] options = new Object[]{cancelMessage};
        JOptionPane jOptionPane = new JOptionPane(components, -1, -1, null, options, null){

            @Override
            public void setValue(Object newValue) {
                if (cancelMessage.equals(newValue)) {
                    log.log(Level.INFO, "User cancelled progress dialog");
                    FMProgressDialog.this.onCancel();
                }
            }
        };
        this.dialog = jOptionPane.createDialog(parentComponent, title);
        this.label.setText(" ");
        this.label.setMinimumSize(new Dimension(100, this.label.getPreferredSize().height));
    }

    public void showDialog(Component centeredOn) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("FMProgressDialog#showDialog must be called from the EDT");
        }
        this.dialog.pack();
        if (centeredOn != null && centeredOn.getSize().equals(new Dimension(0, 0))) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int x = screenSize.width / 2 - this.dialog.getWidth() / 2;
            int y = screenSize.height / 2 - this.dialog.getHeight() / 2;
            this.dialog.setLocation(x, y);
        } else {
            this.dialog.setLocationRelativeTo(centeredOn != null ? centeredOn : JOptionPane.getRootFrame());
        }
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setModal(true);
        this.dialog.setResizable(true);
        this.dialog.setVisible(true);
    }

    public void showDialog(Point location) {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null.");
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("FMProgressDialog#showDialog must be called from the EDT");
        }
        this.dialog.pack();
        this.dialog.setLocation(location);
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
    }

    public void showDialog() {
        this.showDialog((Component)null);
    }

    public void setIndeterminate(boolean yn) {
        progressBar.setIndeterminate(yn);
    }

    public void setMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FMProgressDialog.this.label.setText(message);
            }
        });
    }

    public void setValue(final int i) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressBar.setValue(i);
            }
        });
    }

    public void close() {
        Runnable closeTask = new Runnable(){

            @Override
            public void run() {
                if (FMProgressDialog.this.dialog == null) {
                    throw new IllegalStateException("You must call showDialog before calling close().");
                }
                try {
                    progressBar.setModel(null);
                    FMProgressDialog.this.dialog.getContentPane().removeAll();
                    FMProgressDialog.this.dialog.dispose();
                    log.fine("After dispose...");
                    log.fine("Disposed FMPRogressDialog " + System.identityHashCode(FMProgressDialog.this));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Could not dispose dialog ", e);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            closeTask.run();
        } else {
            log.fine("We are on worker thread, calling invokeAndWait to close...");
            EventQueue.invokeLater(closeTask);
        }
    }

    public static void showSwingTimerQueue() {
        log.fine("*** Examining Swing TimerQueue...(5)");
        try {
            Class<?> timerQueueClass = Class.forName("javax.swing.TimerQueue");
            Method sharedInstanceMethod = timerQueueClass.getDeclaredMethod("sharedInstance", new Class[0]);
            sharedInstanceMethod.setAccessible(true);
            Object sharedInstance = sharedInstanceMethod.invoke(null, new Object[0]);
            log.fine("TimerQueue: " + sharedInstance + " / " + System.identityHashCode(sharedInstance));
            Field firstTimerField = timerQueueClass.getDeclaredField("firstTimer");
            firstTimerField.setAccessible(true);
            Field nextTimerField = Timer.class.getDeclaredField("nextTimer");
            nextTimerField.setAccessible(true);
            int extantTimers = 0;
            Timer nextTimer = (Timer)firstTimerField.get(sharedInstance);
            while (nextTimer != null) {
                ++extantTimers;
                nextTimer = (Timer)nextTimerField.get(nextTimer);
            }
            log.fine("Problem (extant) timers: " + extantTimers);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Couldn't get timer count", ex);
        }
    }

    public void setMin(int i) {
        progressBar.setMinimum(i);
    }

    public void setMax(int i) {
        progressBar.setMaximum(i);
    }

    public void setRangeModel(BoundedRangeModel model) {
        progressBar.setModel(model);
    }

    public abstract void onCancel();

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setProgressStringPainted(boolean b) {
        progressBar.setStringPainted(b);
    }

    public void setProgressString(String progressString) {
        progressBar.setString(progressString);
    }

    static {
        log = Logger.getLogger(FMProgressDialog.class.getName());
        progressBar = new JProgressBar();
    }
}

