/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jetbrains.annotations.NotNull;

public class ProscMail {
    private static final Logger log = Logger.getLogger(ProscMail.class.getName());
    @NotNull
    private static Sender sender = new SMTPTransportSender();

    public static void setSender(@NotNull Sender sender) {
        if (sender == null) {
            ProscMail.$$$reportNull$$$0(0);
        }
        ProscMail.sender = sender;
    }

    public static void quicksend(String from, String to, String subject, String body) throws MessagingException {
        ProscMail.quicksend(from, to, subject, body, null);
    }

    public static void quicksend(String from, String to, String subject, String body, DataSource[] attachments) throws MessagingException {
        Session session = Session.getDefaultInstance(System.getProperties());
        MimeMessage msg = ProscMail.createMessage(from, to, subject, body, attachments);
        ProscMail.sendMessage(msg);
    }

    public static void quicksend(String from, String to, String subject, String body, DataSource[] attachments, Properties properties) throws MessagingException {
        MimeMessage msg = ProscMail.createMessage(from, to, subject, body, attachments, properties);
        ProscMail.sendMessage(msg, properties);
    }

    public static void sendMessage(MimeMessage msg) throws MessagingException {
        ProscMail.sendMessage(msg, System.getProperties());
    }

    public static void sendMessage(MimeMessage msg, Properties p) throws MessagingException {
        log.log(Level.INFO, "Sending email from '" + msg.getFrom()[0] + "' to '" + Arrays.asList(msg.getAllRecipients()) + "', subject '" + msg.getSubject() + "'");
        sender.sendMessage(msg, p);
    }

    private static void dumpContentsRecursively(MimeMultipart multipart) throws MessagingException, IOException {
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart eachPart = multipart.getBodyPart(i);
            Object o = eachPart.getContent();
            if (o instanceof MimeMultipart) {
                ProscMail.dumpContentsRecursively((MimeMultipart)o);
                continue;
            }
            System.out.println("MESSAGE PART " + eachPart);
            System.out.println(o.toString());
        }
    }

    private static MimeMessage createEmptyMimeMessage(String from, String to, String subject, Properties properties) throws MessagingException {
        if (from == null) {
            throw new IllegalArgumentException("from must not be null.");
        }
        if (to == null) {
            throw new IllegalArgumentException("to must not be null.");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null.");
        }
        MimeMessage msg = new MimeMessage(Session.getInstance(properties));
        msg.setSentDate(new Date());
        msg.setFrom(new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
        msg.setSubject(subject);
        return msg;
    }

    private static MimeMessage createEmptyMimeMessage(String from, String to, String subject) throws MessagingException {
        if (from == null) {
            throw new IllegalArgumentException("from must not be null.");
        }
        if (to == null) {
            throw new IllegalArgumentException("to must not be null.");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null.");
        }
        MimeMessage msg = new MimeMessage(Session.getDefaultInstance(System.getProperties()));
        msg.setSentDate(new Date());
        msg.setFrom(new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
        msg.setSubject(subject);
        return msg;
    }

    public static MimeMessage createMessage(String from, String to, String subject, String body, DataSource[] attachments) throws MessagingException {
        HashMap<String, DataSource> map = new HashMap<String, DataSource>();
        if (attachments != null) {
            for (DataSource data : attachments) {
                if (data == null) continue;
                map.put(data.getName(), data);
            }
        }
        return ProscMail.createMessage(from, to, subject, body, map);
    }

    public static MimeMessage createMessage(String from, String to, String subject, String body, Map<String, DataSource> attachments) throws MessagingException {
        boolean isHtml;
        if (body == null) {
            throw new IllegalArgumentException("body must not be null.");
        }
        MimeMessage msg = ProscMail.createEmptyMimeMessage(from, to, subject);
        boolean bl = isHtml = body.length() > 0 && (body.startsWith("<HTML") || body.startsWith("<html") || body.startsWith("<!DOCTYPE ") || body.startsWith("<!doctype "));
        if (attachments != null) {
            MimeMultipart content = new MimeMultipart();
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(body);
            if (isHtml) {
                textPart.setHeader("content-type", "text/html");
            }
            ((Multipart)content).addBodyPart(textPart);
            for (String fileName : attachments.keySet()) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                attachmentPart.setDataHandler(new DataHandler(attachments.get(fileName)));
                attachmentPart.setFileName(fileName);
                ((Multipart)content).addBodyPart(attachmentPart);
            }
            msg.setContent(content);
        } else {
            msg.setText(body, "UTF-8");
            if (isHtml) {
                msg.setHeader("content-type", "text/html");
            }
        }
        return msg;
    }

    public static MimeMessage createMessage(String from, String to, String subject, String html, String plainText) throws MessagingException {
        int bodyCount = 0;
        if (html != null) {
            ++bodyCount;
        }
        if (plainText != null) {
            ++bodyCount;
        }
        if (bodyCount == 0) {
            throw new IllegalArgumentException("No html or plaintext specified");
        }
        MimeMessage mimeMessage = ProscMail.createEmptyMimeMessage(from, to, subject);
        MimeMultipart multipart = new MimeMultipart(bodyCount == 1 ? "mixed" : "alternative");
        mimeMessage.setContent(multipart);
        if (plainText != null) {
            MimeBodyPart plainTextPart = new MimeBodyPart();
            plainTextPart.setText(plainText, "UTF-8");
            multipart.addBodyPart(plainTextPart);
        }
        if (html != null) {
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent(html, "text/html; charset=UTF-8");
            multipart.addBodyPart(htmlPart);
        }
        return mimeMessage;
    }

    public static MimeMessage createMessage(String from, String to, String subject, String body, DataSource[] attachments, Properties properties) throws MessagingException {
        HashMap<String, DataSource> map = new HashMap<String, DataSource>();
        if (attachments != null) {
            for (DataSource data : attachments) {
                if (data == null) continue;
                map.put(data.getName(), data);
            }
        }
        return ProscMail.createMessage(from, to, subject, body, map, properties);
    }

    public static MimeMessage createMessage(String from, String to, String subject, String body, Map<String, DataSource> attachments, Properties properties) throws MessagingException {
        boolean isHtml;
        if (body == null) {
            throw new IllegalArgumentException("body must not be null.");
        }
        MimeMessage msg = ProscMail.createEmptyMimeMessage(from, to, subject, properties);
        boolean bl = isHtml = body.length() > 0 && (body.startsWith("<HTML") || body.startsWith("<html") || body.startsWith("<!DOCTYPE ") || body.startsWith("<!doctype "));
        if (attachments != null) {
            MimeMultipart content = new MimeMultipart();
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(body);
            if (isHtml) {
                textPart.setHeader("content-type", "text/html");
            }
            ((Multipart)content).addBodyPart(textPart);
            for (String fileName : attachments.keySet()) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                attachmentPart.setDataHandler(new DataHandler(attachments.get(fileName)));
                attachmentPart.setFileName(fileName);
                ((Multipart)content).addBodyPart(attachmentPart);
            }
            msg.setContent(content);
        } else {
            msg.setText(body, "UTF-8");
            if (isHtml) {
                msg.setHeader("content-type", "text/html");
            }
        }
        return msg;
    }

    public static MimeMessage createMessage(String from, String to, String subject, String html, String plainText, Properties properties) throws MessagingException {
        int bodyCount = 0;
        if (html != null) {
            ++bodyCount;
        }
        if (plainText != null) {
            ++bodyCount;
        }
        if (bodyCount == 0) {
            throw new IllegalArgumentException("No html or plaintext specified");
        }
        MimeMessage mimeMessage = ProscMail.createEmptyMimeMessage(from, to, subject, properties);
        MimeMultipart multipart = new MimeMultipart(bodyCount == 1 ? "mixed" : "alternative");
        mimeMessage.setContent(multipart);
        if (plainText != null) {
            MimeBodyPart plainTextPart = new MimeBodyPart();
            plainTextPart.setText(plainText, "UTF-8");
            multipart.addBodyPart(plainTextPart);
        }
        if (html != null) {
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent(html, "text/html; charset=UTF-8");
            multipart.addBodyPart(htmlPart);
        }
        return mimeMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/prosc/shared/ProscMail", "setSender"));
    }

    private static class SMTPTransportSender
    implements Sender {
        private SMTPTransportSender() {
        }

        @Override
        public void sendMessage(MimeMessage msg, Properties p) throws MessagingException {
            boolean devmode;
            Properties properties = msg.getSession().getProperties();
            String password = properties.getProperty("mail.smtp.password", properties.getProperty("mail.smtps.password"));
            boolean bl = devmode = Boolean.getBoolean("com.prosc.devmode") && !Boolean.getBoolean("mail.smtp.sendindevmode");
            if (!devmode) {
                if (password != null) {
                    String user = properties.getProperty("mail.smtp.user");
                    String host = properties.getProperty("mail.smtp.host");
                    int port = Integer.parseInt(properties.getProperty("mail.smtp.port", "-1"));
                    log.log(Level.INFO, "Authenticating to SMTP server " + host + " as " + user + ":xxxxx on " + (port == -1 ? "default port" : "port " + port));
                    Transport.send(msg, user, password);
                } else {
                    Transport.send(msg);
                }
            } else {
                try {
                    log.log(Level.WARNING, "DEVMODE: Message is not being delivered!  From: " + msg.getFrom()[0] + ", To: " + Arrays.asList(msg.getAllRecipients()) + ", Subject: " + msg.getSubject());
                    if (msg.getContent() instanceof MimeMultipart) {
                        MimeMultipart multipart = (MimeMultipart)msg.getContent();
                        ProscMail.dumpContentsRecursively(multipart);
                    } else {
                        System.out.println(msg.getContent());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static interface Sender {
        public void sendMessage(MimeMessage var1, Properties var2) throws MessagingException;
    }
}

