/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public final class ByteArrayDataSourceWithName
implements DataSource {
    private final String contentType;
    private final byte[] buf;
    private final int len;
    private final String name;

    public ByteArrayDataSourceWithName(byte[] buf, String contentType, String name) {
        this(buf, buf.length, contentType, name);
    }

    private ByteArrayDataSourceWithName(byte[] buf, int length, String contentType, String name) {
        this.buf = buf;
        this.len = length;
        this.contentType = contentType;
        this.name = name;
    }

    @Override
    public String getContentType() {
        return this.contentType == null ? "application/octet-stream" : this.contentType;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.len);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }
}

