/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.oauth.lambdafunction;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.prosc.oauth.OAuthWorkflow;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OAuthHandler
implements RequestHandler<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> {
    private static final Logger log = Logger.getLogger(OAuthHandler.class.getName());

    @Override
    public APIGatewayProxyResponseEvent handleRequest(APIGatewayProxyRequestEvent input, Context context) {
        String redirectUrl;
        String responseString;
        log.info(input.toString());
        Map<String, String> parameters = input.getQueryStringParameters();
        if (parameters.get("error") != null) {
            responseString = "There was an error processing your request.  Error Message: " + parameters.get("error");
            if (parameters.get("error_description") != null) {
                responseString = responseString + ". Error Description: " + parameters.get("error_description");
            }
            log.severe(responseString);
        } else {
            String state = parameters.get("state");
            AmazonDynamoDB client = (AmazonDynamoDB)AmazonDynamoDBClientBuilder.standard().build();
            HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
            item.put(OAuthWorkflow.OAUTHCODES_PRIMARY_KEY, new AttributeValue().withS(state));
            item.put(OAuthWorkflow.OAUTHCODES_QUERY_PARAMETERS, new AttributeValue().withM(this.convertParametersToDDBMap(parameters)));
            item.put(OAuthWorkflow.OAUTHCODES_TTL_TIMESTAMP, new AttributeValue().withN(String.valueOf(System.currentTimeMillis() / 1000L + 300L)));
            PutItemRequest putitem = new PutItemRequest().withTableName(OAuthWorkflow.OAUTHCODES_TABLENAME).withItem(item);
            PutItemResult putItemResult = client.putItem(putitem);
            log.info("PutItemResult: \n" + putItemResult.toString());
            responseString = "Success! Your login was successful, you may now close this browser window";
        }
        try {
            redirectUrl = "https://static.360works.com/oauth/response.html?responseString=" + URLEncoder.encode(responseString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new APIGatewayProxyResponseEvent().withStatusCode(302).withHeaders(Collections.singletonMap("Location", redirectUrl)).withBody(responseString);
    }

    public HashMap<String, AttributeValue> convertParametersToDDBMap(Map<String, String> parameters) {
        HashMap<String, AttributeValue> attributeMap = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            attributeMap.put(entry.getKey(), new AttributeValue().withS(entry.getValue()));
        }
        return attributeMap;
    }
}

