/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.oauth.ebay;

import com.prosc.oauth.OAuthWorkflow;
import com.prosc.oauth.TokenStore;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class EbayOAuthWorkflow
extends OAuthWorkflow {
    String ruName;

    public EbayOAuthWorkflow(String clientId, String clientSecret, String ruName) {
        super("https://api.ebay.com/identity/v1/oauth2/token", clientId, clientSecret, EbayOAuthWorkflow.getDefaultScopes());
        this.ruName = ruName;
    }

    public EbayOAuthWorkflow(String clientId, String clientSecret, String ruName, List<String> scopes) {
        super("https://api.ebay.com/identity/v1/oauth2/token", clientId, clientSecret, scopes);
        this.ruName = ruName;
    }

    @Override
    protected String _getLoginUrl() {
        try {
            return "https://signin.ebay.com/oauth2/authorize?client_id=" + this.clientId + "&redirect_uri=" + this.ruName + "&response_type=code&state=" + this.state + "&scope=" + URLEncoder.encode(this.getScopes().stream().collect(Collectors.joining(" ")), "UTF-8") + "&prompt=login";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TokenStore fetchTokenStore(String state) throws IOException {
        String grant_type = "authorization_code";
        String code = this.getAuthCode(state);
        String postData = "grant_type=" + URLEncoder.encode(grant_type, "UTF-8") + "&code=" + URLEncoder.encode(code, "UTF-8") + "&redirect_uri=" + URLEncoder.encode(this.ruName, "UTF-8");
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        String credentials = this.clientId + ":" + this.clientSecret;
        additionalHeaders.put("Authorization", "Basic " + new String(Base64.getEncoder().encode(credentials.getBytes())));
        return this.doPost(postData, additionalHeaders);
    }

    @Override
    public TokenStore refreshTokenStore(TokenStore currentTokenStore) throws IOException {
        String grant_type = "refresh_token";
        String postData = "grant_type=" + URLEncoder.encode(grant_type, "UTF-8") + "&refresh_token=" + URLEncoder.encode(currentTokenStore.refresh_token, "UTF-8") + "&scope=" + URLEncoder.encode(this.getScopes().stream().collect(Collectors.joining(" ")), "UTF-8");
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        String credentials = this.clientId + ":" + this.clientSecret;
        additionalHeaders.put("Authorization", "Basic " + new String(Base64.getEncoder().encode(credentials.getBytes())));
        TokenStore tokenStore = this.doPost(postData, additionalHeaders);
        if (tokenStore.refresh_token == null) {
            tokenStore.refresh_token = currentTokenStore.refresh_token;
        }
        return tokenStore;
    }

    static List<String> getDefaultScopes() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("https://api.ebay.com/oauth/api_scope/sell.inventory");
        strings.add("https://api.ebay.com/oauth/api_scope/sell.fulfillment");
        strings.add("https://api.ebay.com/oauth/api_scope");
        return strings;
    }

    public static void main(String[] args) throws InvocationTargetException, InterruptedException, IOException {
        String client_id = "JoeMarti-HoffmanP-PRD-45d7504c4-4fadacd4";
        String client_secret = "PRD-5d7504c43330-97d8-4ddd-a2a2-a174";
        String ruName = "Joe_Martin-JoeMarti-Hoffma-ojtnxpnv";
        EbayOAuthWorkflow ebayOAuthWorkflow = new EbayOAuthWorkflow(client_id, client_secret, ruName);
        String loginUrl = ebayOAuthWorkflow.getLoginUrl();
        System.out.println(loginUrl);
        SwingUtilities.invokeAndWait(() -> JOptionPane.showConfirmDialog(null, "tes"));
        TokenStore tokenStore = ebayOAuthWorkflow.fetchTokenStore();
        System.out.println(tokenStore.toString());
        SwingUtilities.invokeAndWait(() -> JOptionPane.showConfirmDialog(null, "tes"));
        TokenStore refreshed = ebayOAuthWorkflow.refreshTokenStore(tokenStore);
        System.out.println(refreshed.toString());
    }

    static {
        service_name = "eBay";
    }
}

