/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.oauth.dropbox;

import com.prosc.oauth.OAuthWorkflow;
import com.prosc.oauth.TokenStore;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.UUID;

public class DropboxOAuthWorkflow
extends OAuthWorkflow {
    final String tokenAccessType = "offline";
    String codeVerifier;

    public DropboxOAuthWorkflow() {
        super("https://api.dropboxapi.com/oauth2/token", "4rppagce78nm0j6", "awqmni27daak8nl", null);
    }

    @Override
    public String _getLoginUrl() {
        this.codeVerifier = UUID.randomUUID().toString() + UUID.randomUUID().toString();
        System.out.println("Code Verifier is: " + this.codeVerifier);
        String codeChallenge = DropboxOAuthWorkflow.sha256(this.codeVerifier);
        String codeChallengeMethod = "S256";
        return "https://www.dropbox.com/oauth2/authorize?client_id=" + this.getClientId() + "&redirect_uri=" + "https://oauth.360works.com/oauth" + "&response_type=code&code_challenge=" + codeChallenge + "&code_challenge_method=" + codeChallengeMethod + "&state=" + this.state + "&token_access_type=" + "offline";
    }

    @Override
    public TokenStore fetchTokenStore(String state) throws IOException {
        String code = URLEncoder.encode(this.getAuthCode(state), "UTF-8");
        String redirectUriEncoded = URLEncoder.encode("https://oauth.360works.com/oauth", "UTF-8");
        String postData = "code=" + code + "&grant_type=authorization_code&client_id=" + this.clientId + "&client_secret=" + this.clientSecret + "&redirect_uri=" + redirectUriEncoded + "&code_verifier=" + this.codeVerifier;
        return this.doPost(postData, null);
    }

    public static String sha256(String base) {
        try {
            byte[] bytes = base.getBytes(StandardCharsets.US_ASCII);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(bytes, 0, bytes.length);
            byte[] digest = md.digest();
            byte[] encode = Base64.getEncoder().encode(digest);
            String encodedString = new String(encode);
            return encodedString.replaceAll("\\+", "-").replaceAll("/", "_").replaceAll("=", "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        service_name = "Dropbox";
    }
}

