/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.oauth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.prosc.shared.StringUtils;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TokenStore {
    private static final Logger log = Logger.getLogger(TokenStore.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public String service;
    public String scope;
    public int expires_in;
    public int ext_expires_in;
    public String access_token;
    public String refresh_token;
    public String id_token;
    public long accessTokenExpires = -1L;
    public String token_type;
    public long tokenCreated = -1L;

    public boolean isAccessTokenExpired() {
        return this.accessTokenExpires < System.currentTimeMillis();
    }

    public boolean isRefreshTokenExpired() {
        return false;
    }

    public static TokenStore fromTokenResponse(String tokenResponse, String service) {
        TokenStore store = TokenStore.fromString(tokenResponse);
        if (store.accessTokenExpires == -1L) {
            store.accessTokenExpires = System.currentTimeMillis() + (long)store.expires_in * 1000L;
        }
        if (store.tokenCreated == -1L) {
            store.tokenCreated = System.currentTimeMillis();
        }
        store.service = service;
        return store;
    }

    public static TokenStore fromString(@NotNull String tokenStoreString) {
        try {
            return mapper.readValue(tokenStoreString, TokenStore.class);
        }
        catch (IOException e) {
            String message = "Failed to deserialize token store: " + e.getMessage() + ".  Token string: " + tokenStoreString;
            log.log(Level.SEVERE, message, e);
            throw new RuntimeException(message, e);
        }
    }

    public static TokenStore createFromFMString(@Nullable String tokenStoreString) {
        if (StringUtils.isEmptyOrWhitespace(tokenStoreString)) {
            return new TokenStore();
        }
        try {
            return TokenStore.fromString(tokenStoreString);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to deserialize tokenStore.  Will return new empty tokenStore.  Error message: " + e.getMessage());
            return new TokenStore();
        }
    }

    public String toString() {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize token store: " + e.getMessage(), e);
        }
    }
}

