/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.oauth;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.prosc.io.IOUtils;
import com.prosc.oauth.TokenStore;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OAuthWorkflow {
    private static final Logger log = Logger.getLogger(OAuthWorkflow.class.getName());
    public static String OAUTHCODES_TABLENAME = "OAuthRedirects";
    public static String OAUTHCODES_PRIMARY_KEY = "state";
    public static String OAUTHCODES_QUERY_PARAMETERS = "query_parameters";
    public static String OAUTHCODES_TTL_TIMESTAMP = "ttl_timestamp";
    public static final String REDIRECT_URI = "https://oauth.360works.com/oauth";
    public static final String ACCESS_TOKEN_INVALID = "ACCESS_TOKEN_INVALID";
    public static final String ALL_TOKENS_VALID = "ALL_TOKENS_VALID";
    public static final String NO_TOKENS_VALID = "NO_TOKENS_VALID";
    protected static String service_name;
    protected final String tokenApiUrl;
    protected final String clientId;
    protected final String clientSecret;
    protected final String tenantId;
    @Nullable
    private final List<String> scopes;
    public String state;

    public OAuthWorkflow(String tokenApiUrl, String clientId, String clientSecret, @Nullable List<String> scopes) {
        this.tokenApiUrl = tokenApiUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tenantId = null;
        this.scopes = scopes;
    }

    public OAuthWorkflow(String tokenApiUrl, String clientId, String clientSecret, @Nullable String tenantId, @Nullable List<String> scopes) {
        this.tokenApiUrl = tokenApiUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tenantId = tenantId;
        this.scopes = scopes;
    }

    public final String getLoginUrl(@Nullable String state) {
        this.setState(state);
        return this._getLoginUrl();
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public final String getLoginUrl() {
        return this.getLoginUrl(null);
    }

    protected abstract String _getLoginUrl();

    public void setState(@Nullable String state) {
        this.state = state != null ? state : UUID.randomUUID().toString();
    }

    protected String getAuthCode(@Nullable String state) throws IOException {
        String stateFinal;
        if (state != null) {
            stateFinal = state;
        } else if (this.state != null) {
            stateFinal = this.state;
        } else {
            throw new IllegalStateException("You must call getLoginUrl before calling getAuthCode, or supply a state parameter.");
        }
        AmazonDynamoDB client = OAuthWorkflow.getDDBClient();
        GetItemRequest request = new GetItemRequest().withTableName(OAUTHCODES_TABLENAME).withKey(Collections.singletonMap(OAUTHCODES_PRIMARY_KEY, new AttributeValue().withS(stateFinal)));
        GetItemResult result = client.getItem(request);
        if (result == null || result.getItem() == null) {
            throw new IOException("Auth code not found.  Be sure you have logged in using the login url.");
        }
        return this.getAuthCodeFromQueryParameters(result.getItem().get(OAUTHCODES_QUERY_PARAMETERS).getM());
    }

    protected String getAuthCodeFromQueryParameters(Map<String, AttributeValue> queryParameters) {
        return queryParameters.get("code").getS();
    }

    private static AmazonDynamoDB getDDBClient() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials(new AWSStaticCredentialsProvider(new BasicAWSCredentials("AKIAZX6Q4YT5QEQIKZAL", "5amzNSQ20UOkNRBsDyF9KXpMqJvh6XwGqZNZqPvJ")))).withRegion(Regions.US_EAST_1)).build();
    }

    public TokenStore fetchTokenStore(@Nullable String state) throws IOException {
        String grant_type = "authorization_code";
        String code = this.getAuthCode(state);
        String postData = "client_id=" + URLEncoder.encode(this.clientId, "UTF-8") + "&code=" + URLEncoder.encode(code, "UTF-8") + "&redirect_uri=" + URLEncoder.encode(REDIRECT_URI, "UTF-8") + "&grant_type=" + URLEncoder.encode(grant_type, "UTF-8") + "&client_secret=" + URLEncoder.encode(this.clientSecret, "UTF-8");
        return this.doPost(postData, null);
    }

    public TokenStore fetchTokenStore() throws IOException {
        return this.fetchTokenStore(null);
    }

    public TokenStore refreshTokenStore(TokenStore currentTokenStore) throws IOException {
        String refresh_token = currentTokenStore.refresh_token;
        String grant_type = "refresh_token";
        String postData = "client_id=" + URLEncoder.encode(this.clientId, "UTF-8") + "&refresh_token=" + URLEncoder.encode(refresh_token, "UTF-8") + "&grant_type=" + URLEncoder.encode(grant_type, "UTF-8") + "&client_secret=" + URLEncoder.encode(this.clientSecret, "UTF-8");
        if (this.scopes != null) {
            postData = postData + "&scope=" + URLEncoder.encode(String.join((CharSequence)" ", this.scopes), "UTF-8");
        }
        TokenStore tokenStore = this.doPost(postData, null);
        if (tokenStore.refresh_token == null) {
            tokenStore.refresh_token = currentTokenStore.refresh_token;
        }
        return tokenStore;
    }

    protected TokenStore doPost(String postData, Map<String, String> additionalHeaders) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(this.tokenApiUrl).openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("charset", "utf-8");
        conn.setRequestProperty("Content-Length", Integer.toString(postData.length()));
        if (additionalHeaders != null && additionalHeaders.size() > 0) {
            for (Map.Entry<String, String> header : additionalHeaders.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
            wr.write(postData.getBytes());
        }
        String response = IOUtils.urlConnectionAsString(conn);
        return TokenStore.fromTokenResponse(response, service_name);
    }

    public static String checkToken(@Nullable TokenStore store) {
        if (service_name == null) {
            throw new IllegalStateException("The service_name field must be set in a static block in the subclass for OAuthWorkflow.");
        }
        if (store == null || store.access_token == null && store.refresh_token == null || store.isAccessTokenExpired() && store.isRefreshTokenExpired() || !service_name.equals(store.service)) {
            return NO_TOKENS_VALID;
        }
        if (store.access_token == null || store.isAccessTokenExpired()) {
            return ACCESS_TOKEN_INVALID;
        }
        return ALL_TOKENS_VALID;
    }

    public static TokenStore fetchTokenWorkflow(@NotNull OAuthWorkflow oAuthWorkflow, @Nullable String tokenStore, @Nullable String state) throws IOException {
        TokenStore newTokenStore;
        TokenStore currentTokenStore;
        String tokenStatus;
        if (oAuthWorkflow == null) {
            OAuthWorkflow.$$$reportNull$$$0(0);
        }
        if (ALL_TOKENS_VALID.equals(tokenStatus = OAuthWorkflow.checkToken(currentTokenStore = TokenStore.createFromFMString(tokenStore)))) {
            newTokenStore = currentTokenStore;
        } else if (ACCESS_TOKEN_INVALID.equals(tokenStatus)) {
            newTokenStore = oAuthWorkflow.refreshTokenStore(currentTokenStore);
        } else if (NO_TOKENS_VALID.equals(tokenStatus)) {
            newTokenStore = oAuthWorkflow.fetchTokenStore(state);
        } else {
            throw new IllegalStateException("Could not determine status of tokens.  Token status: " + tokenStatus + ".  Token:\n" + tokenStore);
        }
        return newTokenStore;
    }

    private static String getLoginUrlForOAuthWorkflow(@Nullable String tokenStore, @Nullable String state, OAuthWorkflow workflow) {
        TokenStore currentTokenStore = TokenStore.createFromFMString(tokenStore);
        String tokenStatus = OAuthWorkflow.checkToken(currentTokenStore);
        boolean tokenRevoked = false;
        if (!NO_TOKENS_VALID.equals(tokenStatus)) {
            try {
                TokenStore tokenStore2 = workflow.refreshTokenStore(currentTokenStore);
            }
            catch (IOException e) {
                log.warning("Token failed to refresh with error, will return a new login url.  Error message: " + e.getMessage());
                tokenRevoked = true;
            }
        }
        if (tokenRevoked || NO_TOKENS_VALID.equals(tokenStatus)) {
            return workflow.getLoginUrl(state);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oAuthWorkflow", "com/prosc/oauth/OAuthWorkflow", "fetchTokenWorkflow"));
    }
}

