/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.net;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Optional;

public class IpAddressUtils {
    public static boolean isInetAddressNumeric(String address) throws UnknownHostException {
        return address.equals(InetAddress.getByName(address).getHostAddress());
    }

    public static Optional<Inet6Address> getPublicIPv6Address() throws SocketException {
        Enumeration<NetworkInterface> en1 = NetworkInterface.getNetworkInterfaces();
        while (en1.hasMoreElements()) {
            NetworkInterface anInterface = en1.nextElement();
            Enumeration<InetAddress> en2 = anInterface.getInetAddresses();
            while (en2.hasMoreElements()) {
                Inet6Address inet6;
                InetAddress address = en2.nextElement();
                if (!(address instanceof Inet6Address) || (inet6 = (Inet6Address)address).isLinkLocalAddress() || inet6.isLoopbackAddress()) continue;
                return Optional.of(inet6);
            }
        }
        return Optional.empty();
    }
}

