/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.security;

import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class NoDiffieSSLSocketFactory
extends SSLSocketFactory {
    public static final Logger log = Logger.getLogger(NoDiffieSSLSocketFactory.class.getName());
    private final SSLSocketFactory delegate = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private final boolean tlsv11Supported;
    private final boolean tlsv12Supported;
    private static final String TLSv11Proto = "TLSv1.1";
    private static final String TLSv12Proto = "TLSv1.2";

    public NoDiffieSSLSocketFactory() {
        Object[] supportedProtos;
        boolean tlsv11Supported = false;
        boolean tlsv12Supported = false;
        try {
            supportedProtos = SSLContext.getDefault().getSupportedSSLParameters().getProtocols();
            log.info(String.format("Supported protocols: %s", StringUtils.join(supportedProtos, ", ")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        for (Object proto : supportedProtos) {
            if (((String)proto).equals(TLSv11Proto)) {
                tlsv11Supported = true;
                continue;
            }
            if (!((String)proto).equals(TLSv12Proto)) continue;
            tlsv12Supported = true;
        }
        this.tlsv11Supported = tlsv11Supported;
        this.tlsv12Supported = tlsv12Supported;
    }

    private Socket fixupSocket(Socket sock) {
        if (!(sock instanceof SSLSocket)) {
            return sock;
        }
        SSLSocket sslSock = (SSLSocket)sock;
        HashSet<String> protos = new HashSet<String>(Arrays.asList(sslSock.getEnabledProtocols()));
        if (this.tlsv11Supported) {
            protos.add(TLSv11Proto);
        }
        if (this.tlsv12Supported) {
            protos.add(TLSv12Proto);
        }
        sslSock.setEnabledProtocols(protos.toArray(new String[protos.size()]));
        ArrayList<String> enabledCipherSuites = new ArrayList<String>();
        for (String cipherSuite : sslSock.getEnabledCipherSuites()) {
            if (cipherSuite.contains("DHE")) continue;
            enabledCipherSuites.add(cipherSuite);
        }
        sslSock.setEnabledCipherSuites(enabledCipherSuites.toArray(new String[enabledCipherSuites.size()]));
        log.info(String.format("Enabled cipher suites: %s", StringUtils.join(sslSock.getEnabledCipherSuites(), ", ")));
        log.info(String.format("Enabled protocols: %s", StringUtils.join(sslSock.getEnabledProtocols(), ", ")));
        return sslSock;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.fixupSocket(this.delegate.createSocket());
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.fixupSocket(this.delegate.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.fixupSocket(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.fixupSocket(this.delegate.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.fixupSocket(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.fixupSocket(this.delegate.createSocket(address, port, localAddress, localPort));
    }
}

