/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.net;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class Subnet {
    public static boolean isSameSubnet(InetAddress otherAddress) throws SocketException {
        if (otherAddress.isLoopbackAddress() || otherAddress.isLinkLocalAddress()) {
            return true;
        }
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        if (en == null) {
            return false;
        }
        while (en.hasMoreElements()) {
            NetworkInterface nic = en.nextElement();
            if (!nic.isUp() || nic.isLoopback() || !Subnet.isSameSubnet(nic, otherAddress)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameSubnet(NetworkInterface nic, InetAddress otherAddress) {
        for (InterfaceAddress interfaceAddress : nic.getInterfaceAddresses()) {
            BigInteger theirAddressShift;
            int uniqueBits;
            InetAddress nicAddress = interfaceAddress.getAddress();
            short subnetLength = interfaceAddress.getNetworkPrefixLength();
            if (nicAddress instanceof Inet4Address && otherAddress instanceof Inet4Address) {
                uniqueBits = 32 - subnetLength;
            } else {
                if (!(nicAddress instanceof Inet6Address) || !(otherAddress instanceof Inet6Address)) continue;
                uniqueBits = 64 - subnetLength;
            }
            BigInteger myAddress = new BigInteger(nicAddress.getAddress());
            BigInteger theirAddress = new BigInteger(otherAddress.getAddress());
            BigInteger myAddressShift = myAddress.shiftRight(uniqueBits);
            if (!myAddressShift.equals(theirAddressShift = theirAddress.shiftRight(uniqueBits))) continue;
            return true;
        }
        return false;
    }
}

