/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.io;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Scanner;

public class ReaderScanner {
    public static final int BUFFERSIZE = 8192;

    public final void scan(String regex, int maximumMatchLength, Reader reader, Writer writer) throws IOException {
        int charsRead;
        int buffLength = Math.max(maximumMatchLength * 2, 8192);
        char[] buffer = new char[buffLength];
        int bufferWritePos = 0;
        block0: while ((charsRead = reader.read(buffer, bufferWritePos, buffLength - bufferWritePos)) != -1) {
            int chunkLength = bufferWritePos + charsRead;
            String chunk = new String(buffer, 0, chunkLength);
            int chunkIndex = 0;
            Scanner scanner = new Scanner(chunk);
            int remainderLength = maximumMatchLength;
            while (true) {
                String matchingString;
                if ((matchingString = scanner.findWithinHorizon(regex, chunk.length())) == null) {
                    writer.write(buffer, chunkIndex, chunkLength - chunkIndex - remainderLength);
                    System.arraycopy(buffer, chunkLength - remainderLength, buffer, 0, remainderLength);
                    bufferWritePos = remainderLength;
                    continue block0;
                }
                int length = scanner.match().start() - chunkIndex;
                writer.write(buffer, chunkIndex, length);
                chunkIndex = scanner.match().end();
                remainderLength = Math.min(remainderLength, chunkLength - chunkIndex);
                this.handleMatch(writer, matchingString);
            }
        }
        writer.write(buffer, 0, bufferWritePos);
    }

    protected void handleMatch(Writer writer, String matchingString) throws IOException {
    }
}

