/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.infrastructure;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JavaVersionCheck {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: pathToJar [-max versionNumber] [-class unqualifiedClassName] filesOrDirectories...");
            System.exit(-1);
        }
        float maxVersion = 0.0f;
        String className = null;
        for (int n = 0; n < args.length; ++n) {
            String arg = args[n];
            if ("-max".equals(arg)) {
                maxVersion = Float.valueOf(args[++n]).floatValue();
                continue;
            }
            if ("-class".equals(arg)) {
                className = args[++n];
                continue;
            }
            File inputFile = new File(arg);
            if (!inputFile.exists()) {
                System.err.println("File does not exist at " + inputFile.getAbsolutePath());
                System.exit(-2);
            }
            JavaVersionCheck.processFile(inputFile, maxVersion, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFile(File inputFile, float maxVersion, String className) throws IOException {
        LinkedList<ClassVersion> result = new LinkedList<ClassVersion>();
        String filename = inputFile.getName();
        if (filename.endsWith(".class")) {
            String unqualifiedName = filename.substring(0, filename.length() - 6);
            if (className == null || className.equals(unqualifiedName)) {
                try (FileInputStream fileIn = new FileInputStream(inputFile);){
                    JavaVersionCheck.readClassBytes(result, unqualifiedName, fileIn);
                }
            }
        } else {
            if (inputFile.isDirectory()) {
                for (File file : inputFile.listFiles()) {
                    JavaVersionCheck.processFile(file, maxVersion, className);
                }
                return;
            }
            if (filename.endsWith(".jar") || filename.endsWith(".zip")) {
                JarFile jarFile = new JarFile(inputFile);
                Enumeration<JarEntry> en = jarFile.entries();
                while (en.hasMoreElements()) {
                    JarEntry eachEntry = en.nextElement();
                    String entryName = eachEntry.getName();
                    if (!entryName.endsWith(".class")) continue;
                    String noSuffixName = entryName.substring(0, entryName.length() - 6);
                    String unqualifiedName = noSuffixName.substring(noSuffixName.lastIndexOf(47) + 1);
                    if (className != null && !className.equals(unqualifiedName)) continue;
                    try (InputStream inputStream = jarFile.getInputStream(eachEntry);){
                        JavaVersionCheck.readClassBytes(result, noSuffixName, inputStream);
                    }
                }
            } else {
                return;
            }
        }
        Collections.sort(result, new Comparator<ClassVersion>(){

            @Override
            public int compare(ClassVersion o1, ClassVersion o2) {
                return o1.version.compareTo(o2.version);
            }
        });
        StringBuffer sb = new StringBuffer();
        for (ClassVersion entry : result) {
            if (entry.version.floatValue() <= maxVersion) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(entry.version + " " + entry.classname + " " + inputFile.getAbsolutePath());
        }
        if (sb.length() > 0) {
            System.out.println(sb.toString());
        }
    }

    private static void readClassBytes(List<ClassVersion> result, String name, InputStream inputStream) throws IOException {
        byte[] buff = new byte[4];
        int byteCount = 0;
        while (byteCount < 4) {
            byteCount = (int)((long)byteCount + inputStream.skip(4L));
        }
        for (byteCount = 0; byteCount < 4; byteCount += inputStream.read(buff, byteCount, 4 - byteCount)) {
        }
        short intPart = (short)((buff[2] << 8) + buff[3]);
        short decPart = (short)((buff[0] << 8) + buff[1]);
        float versionNumber = (float)((double)intPart + (double)decPart * 0.01);
        result.add(new ClassVersion(versionNumber, name));
    }

    private static class ClassVersion {
        private Float version;
        private String classname;

        private ClassVersion(float version, String classname) {
            this.version = Float.valueOf(version);
            this.classname = classname;
        }
    }
}

