/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.io.IOUtils;
import com.prosc.io.InputStreamRangeModel;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputStreamInfo
implements Closeable {
    private static final Logger log = Logger.getLogger(InputStreamInfo.class.getName());
    private final InputStream stream;
    private final String name;
    private final long length;
    private final String contentType;
    @NotNull
    private Charset charset = StandardCharsets.UTF_8;
    private final File file;
    private final byte[] bytes;
    private String contentEncoding;
    private long lastModified;
    private InputStreamRangeModel rangeModel;
    private final Collection<InputStream> streamsToClose = new ArrayList<InputStream>();

    public InputStreamInfo(File file) {
        this(file, null);
    }

    public InputStreamInfo(File file, @Nullable String optionalContentType) {
        this(null, file, null, file.getName(), file.length(), optionalContentType, file.lastModified());
        if (file.isDirectory()) {
            throw new IllegalArgumentException("You may not pass a directory into the InputStreamInfo constructor");
        }
    }

    public InputStreamInfo(InputStream stream, String name, long length, long lastModified) {
        this(stream, name, length, null, lastModified);
    }

    public InputStreamInfo(InputStream stream, String name, long length, @Nullable String optionalContentType, long lastModified) {
        this(stream, null, null, name, length, optionalContentType, lastModified);
    }

    public InputStreamInfo(byte[] bytes, String name, @Nullable String optionalContentType, long lastModified) {
        this(null, null, bytes, name, bytes.length, optionalContentType, lastModified);
    }

    private InputStreamInfo(@Nullable InputStream stream, @Nullable File file, byte[] bytes, String name, long length, @Nullable String optionalContentType, long lastModified) {
        this.stream = stream;
        this.file = file;
        this.bytes = bytes;
        this.name = name;
        this.length = length;
        this.contentType = optionalContentType;
        this.lastModified = lastModified;
    }

    public InputStream getStream() throws FileNotFoundException {
        InputStream result;
        if (this.stream != null) {
            return this.stream;
        }
        if (this.file != null) {
            result = new FileInputStream(this.file);
        } else if (this.bytes != null) {
            result = new ByteArrayInputStream(this.bytes);
        } else {
            throw new IllegalStateException("Could not generate stream - stream, file, and bytes are all null");
        }
        this.streamsToClose.add(result);
        return result;
    }

    public Reader getReader() {
        return new InputStreamReader(this.stream, this.charset);
    }

    public String getName() {
        return this.name;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isRepeatable() {
        return this.file != null || this.bytes != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStreamInfo repeatableStreamInfo(long diskThreshold) throws IOException {
        if (this.isRepeatable()) {
            return this;
        }
        try {
            if (this.length <= diskThreshold) {
                byte[] bytes = IOUtils.inputStreamAsBytes(this.stream);
                InputStreamInfo inputStreamInfo = new InputStreamInfo(bytes, this.name, this.contentType, this.lastModified);
                return inputStreamInfo;
            }
            final File tempFile = File.createTempFile("InputStreamInfoBuffer", "dat");
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                IOUtils.writeInputToOutput(this.stream, (OutputStream)fos, 65536);
            }
            InputStreamInfo inputStreamInfo = new InputStreamInfo(null, tempFile, null, this.name, tempFile.length(), this.contentType, this.lastModified){

                @Override
                public void close() {
                    super.close();
                    try {
                        IOUtils.deleteRecursive(tempFile);
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Could not delete temp buffer file for InputStreamInfo at " + tempFile.getAbsolutePath(), e);
                    }
                }
            };
            return inputStreamInfo;
        }
        finally {
            this.close();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public File getFile() {
        return this.file;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public void close() {
        for (InputStream inputStream : this.streamsToClose) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close internally generated InputStream", e);
            }
        }
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.charset;
        if (charset == null) {
            InputStreamInfo.$$$reportNull$$$0(0);
        }
        return charset;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            InputStreamInfo.$$$reportNull$$$0(1);
        }
        this.charset = charset;
    }

    public InputStreamRangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setRangeModel(InputStreamRangeModel rangeModel) {
        this.rangeModel = rangeModel;
    }

    public String toString() {
        return "InputStreamInfo{name='" + this.name + '\'' + ", length=" + this.length + ", contentType='" + this.contentType + '\'' + ", charset=" + this.charset + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/io/InputStreamInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/io/InputStreamInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

