/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.ClassUtils;
import com.prosc.infrastructure.Platform;
import com.prosc.io.AwsUrlEncoder;
import com.prosc.io.HttpIOException;
import com.prosc.io.ProcessExecutionException;
import com.prosc.io.ProcessUtils;
import com.prosc.shared.DebugTimer;
import com.prosc.shared.Retry;
import com.prosc.thread.MyThreadFactory;
import com.prosc.thread.ThreadUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IOUtils {
    private static final Logger log = Logger.getLogger(IOUtils.class.getName());
    public static final int CHUNK_SIZE = 8192;
    public static final String FILEPATH_SEPARATOR = System.getProperty("file.separator");
    private static final String encodingCharset = "utf-8";
    private static volatile ExecutorService downloadQueue = null;

    public static long writeInputToOutput(@NotNull InputStream in, @NotNull OutputStream out, int bufferSize) throws IOException {
        int lastBytesRead;
        if (in == null) {
            IOUtils.$$$reportNull$$$0(0);
        }
        if (out == null) {
            IOUtils.$$$reportNull$$$0(1);
        }
        byte[] buffer = new byte[bufferSize];
        long totalBytesRead = 0L;
        while ((lastBytesRead = in.read(buffer)) != -1) {
            IOUtils.sendChunkWithRetry(out, buffer, lastBytesRead);
            totalBytesRead += (long)lastBytesRead;
        }
        out.flush();
        return totalBytesRead;
    }

    private static void sendChunkWithRetry(@NotNull OutputStream out, byte[] buffer, int bytesToWrite) throws IOException {
        if (out == null) {
            IOUtils.$$$reportNull$$$0(2);
        }
        new Retry(){

            @Override
            protected void shouldRetry(@NotNull Exception e) throws Exception {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!"Error writing request body to server".equals(e.getMessage())) {
                    throw e;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/prosc/io/IOUtils$1", "shouldRetry"));
            }
        }.doTask(3, 100, IOException.class, (whichAttempt, maxAttempts) -> {
            out.write(buffer, 0, bytesToWrite);
            return null;
        });
    }

    public static long writeInputToOutputs(@NotNull InputStream in, @NotNull Collection<OutputStream> outputs, int bufferSize) throws IOException {
        if (in == null) {
            IOUtils.$$$reportNull$$$0(3);
        }
        if (outputs == null) {
            IOUtils.$$$reportNull$$$0(4);
        }
        byte[] buffer = new byte[bufferSize];
        long totalBytesRead = 0L;
        ExecutorService worker = Executors.newFixedThreadPool(outputs.size(), new MyThreadFactory("writeInputToOutputs"));
        try {
            int lastBytesRead;
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(outputs.size());
            while ((lastBytesRead = in.read(buffer)) != -1) {
                log.finest("Sending " + lastBytesRead + " bytes of input to " + outputs.size() + " outputs: " + outputs);
                futures.clear();
                for (OutputStream outputStream : outputs) {
                    int bytesToSend = lastBytesRead;
                    futures.add(worker.submit(() -> {
                        byte[] byArray = buffer;
                        synchronized (buffer) {
                            byte[] localBuffer = buffer;
                            // ** MonitorExit[var4_3] (shouldn't be in output)
                            IOUtils.sendChunkWithRetry(output, localBuffer, bytesToSend);
                            log.finest("Wrote " + bytesToSend + " bytes to " + output);
                            return null;
                        }
                    }));
                }
                totalBytesRead += (long)lastBytesRead;
                for (Future future : futures) {
                    ThreadUtil.getInterruptible(future, IOException.class);
                }
            }
            for (OutputStream outputStream : outputs) {
                outputStream.flush();
            }
            long l = totalBytesRead;
            return l;
        }
        catch (InterruptedException e) {
            InterruptedIOException exception = new InterruptedIOException("writeInputToOutputs was interrupted");
            exception.initCause(e);
            throw exception;
        }
        finally {
            worker.shutdown();
        }
    }

    public static long writeFixedByteCount(InputStream in, OutputStream out, long size) throws IOException {
        long nextChunk;
        long totalBytesRead;
        int bytesRead;
        byte[] buffer = new byte[Math.min(8192, (int)size)];
        for (totalBytesRead = 0L; totalBytesRead < size && (bytesRead = in.read(buffer, 0, (int)(nextChunk = Math.min(size - totalBytesRead, (long)buffer.length)))) != -1; totalBytesRead += (long)bytesRead) {
            out.write(buffer, 0, bytesRead);
        }
        return totalBytesRead;
    }

    public static long writeInputToOutput(InputStream in, OutputStream out, byte[] stopSequence) throws IOException {
        int eachByte;
        int result;
        int sequenceMark = 0;
        int sequenceLength = stopSequence.length;
        for (result = 0; sequenceMark < sequenceLength && result < 1600 && (eachByte = in.read()) != -1; ++result) {
            out.write(eachByte);
            if (eachByte == stopSequence[sequenceMark]) {
                ++sequenceMark;
                continue;
            }
            sequenceMark = 0;
        }
        return result;
    }

    public static byte[] inputStreamAsBytes(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            IOUtils.$$$reportNull$$$0(5);
        }
        int bufferSize = Math.max(stream.available(), 8192);
        try (ByteArrayOutputStream allBytes = new ByteArrayOutputStream(bufferSize);){
            IOUtils.writeInputToOutput(stream, (OutputStream)allBytes, bufferSize);
        }
        return allBytes.toByteArray();
    }

    public static byte[] inputStreamAsBytes(@NotNull InputStream stream, int length) throws IOException {
        int chunkSize;
        if (stream == null) {
            IOUtils.$$$reportNull$$$0(6);
        }
        if (length < 0) {
            return IOUtils.inputStreamAsBytes(stream);
        }
        byte[] result = new byte[length];
        for (int totalRead = 0; totalRead != length; totalRead += chunkSize) {
            chunkSize = stream.read(result, totalRead, length - totalRead);
            if (chunkSize != -1) continue;
            byte[] truncated = new byte[totalRead];
            System.arraycopy(result, 0, truncated, 0, totalRead);
            return truncated;
        }
        return result;
    }

    @NotNull
    public static String inputStreamAsString(InputStream stream) throws IOException {
        return IOUtils.inputStreamAsString(stream, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String inputStreamAsString(@NotNull InputStream stream, Charset charset) throws IOException {
        if (stream == null) {
            IOUtils.$$$reportNull$$$0(7);
        }
        return new String(IOUtils.inputStreamAsBytes(stream), charset);
    }

    @NotNull
    public static String inputStreamAsString(@NotNull InputStream stream, String charset) throws IOException {
        if (stream == null) {
            IOUtils.$$$reportNull$$$0(8);
        }
        return IOUtils.inputStreamAsString(stream, Charset.forName(charset));
    }

    @NotNull
    public static String readerAsString(@NotNull Reader reader, @Nullable Appendable toAppendTo) throws IOException {
        int charsRead;
        if (reader == null) {
            IOUtils.$$$reportNull$$$0(9);
        }
        if (toAppendTo == null) {
            toAppendTo = new StringBuilder();
        }
        char[] buffer = new char[8192];
        while ((charsRead = reader.read(buffer)) != -1) {
            toAppendTo.append(new String(buffer, 0, charsRead));
        }
        String string = toAppendTo.toString();
        if (string == null) {
            IOUtils.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static String urlEncoded(String formatString, Object ... values) {
        Object[] encodedArgs = new Object[values.length];
        for (int i = 0; i < encodedArgs.length; ++i) {
            Object eachValue = values[i];
            encodedArgs[i] = eachValue == null ? "" : AwsUrlEncoder.encode(eachValue.toString()).replace("+", "%20");
        }
        return new Formatter().format(formatString, encodedArgs).toString();
    }

    public static String urlDecoded(@Nullable String string) throws UnsupportedEncodingException {
        return string == null ? null : URLDecoder.decode(string, "UTF-8");
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static String urlConnectionAsString(URLConnection theConnection) throws IOException {
        InputStream theStream = theConnection.getInputStream();
        Throwable throwable = null;
        String string = IOUtils.inputStreamAsString(theStream);
        String string2 = string;
        if (string2 == null) {
            IOUtils.$$$reportNull$$$0(11);
        }
        return string2;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (theStream != null) {
                    if (throwable != null) {
                        try {
                            theStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        theStream.close();
                    }
                }
            }
            {
                catch (IOException e) {
                    if (theConnection instanceof HttpURLConnection) {
                        try {
                            ((HttpURLConnection)theConnection).getResponseCode();
                        }
                        catch (IOException e1) {
                            throw e;
                        }
                        throw IOUtils.rethrowHttpException(e, (HttpURLConnection)theConnection);
                    }
                    throw e;
                }
            }
        }
    }

    public static void postDataToUrlConnection(@NotNull String postArgs, URLConnection theConnection) throws IOException {
        if (postArgs == null) {
            IOUtils.$$$reportNull$$$0(12);
        }
        if (!theConnection.getDoOutput()) {
            theConnection.setDoOutput(true);
        }
        byte[] bytes = postArgs.getBytes(StandardCharsets.UTF_8);
        theConnection.setRequestProperty("content-length", "" + bytes.length);
        try (OutputStream outputStream = theConnection.getOutputStream();){
            outputStream.write(bytes);
        }
    }

    public static String getUrlContents(String theUrl) throws IOException {
        return IOUtils.getUrlContents(theUrl, null);
    }

    public static String getUrlContents(String theUrl, String postArgs) throws IOException {
        return IOUtils.getUrlContents(theUrl, postArgs, null);
    }

    public static String getUrlContents(String theUrl, @Nullable String postArgs, Integer timeout) throws IOException {
        log.log(Level.FINE, "Reading URL contents of " + theUrl + " postArgs size = " + (postArgs == null ? 0 : postArgs.length()));
        URLConnection theConnection = new URL(theUrl).openConnection();
        if (timeout != null) {
            theConnection.setConnectTimeout(timeout);
            theConnection.setReadTimeout(timeout);
        }
        if (postArgs != null) {
            IOUtils.postDataToUrlConnection(postArgs, theConnection);
        }
        return IOUtils.urlConnectionAsString(theConnection);
    }

    public static String getUrlContents(String theUrl, @Nullable String postArgs, Integer connectTimeout, Integer readTimeout) throws IOException {
        log.log(Level.FINE, "Reading URL contents of " + theUrl + " postArgs size = " + (postArgs == null ? 0 : postArgs.length()));
        URLConnection theConnection = new URL(theUrl).openConnection();
        if (connectTimeout != null) {
            theConnection.setConnectTimeout(connectTimeout);
        }
        if (readTimeout != null) {
            theConnection.setReadTimeout(readTimeout);
        }
        if (postArgs != null) {
            IOUtils.postDataToUrlConnection(postArgs, theConnection);
        }
        return IOUtils.urlConnectionAsString(theConnection);
    }

    public static void enableSSL() {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        try {
            Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] fileAsBytes(String whichFile) throws IOException {
        return IOUtils.fileAsBytes(new File(whichFile));
    }

    public static byte[] fileAsBytes(File whichFile) throws IOException {
        log.log(Level.FINE, "Reading file contents " + whichFile);
        byte[] data = new byte[(int)whichFile.length()];
        int bytesRead = 0;
        try (FileInputStream in = new FileInputStream(whichFile);){
            while ((bytesRead += in.read(data, bytesRead, data.length - bytesRead)) != data.length) {
            }
        }
        return data;
    }

    public static String fileAsString(File whichFile) throws IOException {
        return IOUtils.fileAsString(whichFile, "UTF-8");
    }

    public static String fileAsString(File whichFile, String charset) throws IOException {
        return new String(IOUtils.fileAsBytes(whichFile), charset);
    }

    public static synchronized File ensureUniqueFilename(File whichFile, boolean createEmptyFile) {
        block5: {
            block4: {
                if (!whichFile.exists()) break block4;
                int suffixMarker = whichFile.getName().lastIndexOf(46);
                String suffix = "";
                String prefix = whichFile.getPath();
                if (suffixMarker != -1) {
                    suffix = whichFile.getName().substring(suffixMarker);
                    prefix = whichFile.getParent() + File.separator + whichFile.getName().substring(0, suffixMarker);
                }
                int appendInt = 1;
                while (whichFile.exists()) {
                    whichFile = new File(prefix + '-' + appendInt + suffix);
                    ++appendInt;
                }
                break block5;
            }
            if (!createEmptyFile) break block5;
            try {
                whichFile.createNewFile();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not create new empty file", e);
            }
        }
        return whichFile;
    }

    public static String getMimeType(String fileName) {
        if (fileName == null) {
            return null;
        }
        String mimeType = IOUtils.getExactMimeType(fileName);
        if (mimeType == null) {
            mimeType = "untyped/binary";
        }
        return mimeType;
    }

    public static String getExactMimeType(String fileName) {
        if (fileName == null) {
            return null;
        }
        String mimeType = URLConnection.getFileNameMap().getContentTypeFor(fileName);
        if (mimeType == null) {
            String suffix;
            switch (suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) {
                case "js": {
                    mimeType = "text/javascript";
                    break;
                }
                case "tgz": {
                    mimeType = "application/x-tar";
                    break;
                }
                case "css": {
                    mimeType = "text/css";
                    break;
                }
                case "ico": {
                    mimeType = "image/x-icon";
                    break;
                }
                case "sit": {
                    mimeType = "application/x-stuffit";
                    break;
                }
                case "fdx": {
                    mimeType = "application/xml";
                    break;
                }
                case "mp4": {
                    mimeType = "video/quicktime";
                }
            }
        }
        return mimeType;
    }

    public static String urlEncodeMap(Map<String, ?> dict) {
        StringBuilder urlString = new StringBuilder();
        Iterator<String> iterator = dict.keySet().iterator();
        while (iterator.hasNext()) {
            String aKey = iterator.next();
            @Nullable Object anObject = dict.get(aKey);
            aKey = IOUtils.encode(aKey);
            if (anObject instanceof List) {
                Iterator en = ((List)anObject).iterator();
                while (en.hasNext()) {
                    String nextElement = (String)en.next();
                    urlString.append(aKey).append("=").append(IOUtils.encode(nextElement));
                    if (!en.hasNext()) continue;
                    urlString.append("&");
                }
            } else {
                if (anObject == null) {
                    anObject = "";
                }
                urlString.append(aKey).append("=").append(IOUtils.encode(String.valueOf(anObject)));
            }
            if (!iterator.hasNext()) continue;
            urlString.append("&");
        }
        return urlString.toString();
    }

    public static Map<String, String> urlDecodeToMap(String query) throws UnsupportedEncodingException {
        if (query == null) {
            return Collections.emptyMap();
        }
        Matcher matcher = Pattern.compile("[\\?&]?([^=&]+)(=([^&]*))?").matcher(query);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            result.put(IOUtils.urlDecoded(matcher.group(1)), IOUtils.urlDecoded(matcher.group(3)));
        }
        return result;
    }

    public static String encode(String input) {
        if (input == null) {
            throw new IllegalArgumentException("You cannot provide a null input value to encode()");
        }
        return AwsUrlEncoder.encode(input);
    }

    public static String decode(String input) {
        try {
            return URLDecoder.decode(input, encodingCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                String msg = "Failed to close " + closeable;
                log.log(Level.WARNING, msg, e);
            }
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                String msg = "Failed to close outputStream " + outputStream;
                log.log(Level.WARNING, msg, e);
            }
        } else {
            log.log(Level.INFO, "Received null outputStream");
        }
    }

    public static void closeQuietly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                String msg = "Failed to close reader " + reader;
                log.log(Level.WARNING, msg, e);
            }
        } else {
            log.log(Level.INFO, "Received null reader");
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close inputStream " + inputStream, e);
            }
        } else {
            log.log(Level.INFO, "Received null inputStream");
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close writer " + writer, e);
            }
        } else {
            log.log(Level.INFO, "Received null writer");
        }
    }

    public static File copyFile(File src, File dest) throws IOException {
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            IOUtils.writeInputToOutput((InputStream)in, (OutputStream)out, 8192);
        }
        return dest;
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            IOUtils.ensureDirectoryIsReady(dstDir);
            if (!dstDir.exists() && !IOUtils.mkdirs(dstDir)) {
                throw new IOException("Directory could not be copied because a destination directory could not be created: " + dstDir.getAbsolutePath());
            }
            String[] children = srcDir.list();
            if (children == null) {
                throw new IOException("copyDirectory failed because a list of items in source directory '" + srcDir + "' could not be obtained");
            }
            for (String eachChild : children) {
                IOUtils.copyDirectory(new File(srcDir, eachChild), new File(dstDir, eachChild));
            }
        } else {
            IOUtils.copyFile(srcDir, dstDir);
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close socket " + socket, e);
            }
        } else {
            log.log(Level.INFO, "Received null socket");
        }
    }

    public static void closeQuietly(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close socket " + socket, e);
            }
        } else {
            log.log(Level.INFO, "Received null socket");
        }
    }

    public static long writeReaderToWriter(Reader reader, Writer writer) throws IOException {
        return IOUtils.writeReaderToWriter(reader, writer, new char[1024]);
    }

    public static long writeReaderToWriter(Reader reader, Writer writer, char[] buffer) throws IOException {
        int charsRead;
        int len = buffer.length;
        long totalChars = 0L;
        while ((charsRead = reader.read(buffer, 0, len)) > 0) {
            writer.write(buffer, 0, charsRead);
            totalChars += (long)charsRead;
        }
        return totalChars;
    }

    public static long writeReaderToWriterThreaded(final Reader reader, final Writer writer, final int bufferSize) throws IOException {
        return new Callable<Long>(){
            final char[][] buffers;
            final int[] sizes;
            IOException inException;
            final Object lock;
            int inIndex;
            int outIndex;
            {
                this.buffers = new char[3][bufferSize];
                this.sizes = new int[3];
                this.inException = null;
                this.lock = new Object();
                this.inIndex = 0;
                this.outIndex = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws IOException {
                try (final DebugTimer dt = new DebugTimer("Starting", false);){
                    Object object;
                    int chunkSize;
                    long result = 0L;
                    new Thread("Read source to buffer"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void run() {
                            try {
                                while (true) {
                                    int totalChunkSize = 0;
                                    dt.markTime("Reading a chunk of chars to out");
                                    int chunkRead = reader.read(buffers[inIndex]);
                                    Object object = lock;
                                    synchronized (object) {
                                        lock.notifyAll();
                                        if (chunkRead == -1) {
                                            sizes[inIndex] = -1;
                                            inIndex = -1;
                                            return;
                                        }
                                        sizes[inIndex] = totalChunkSize += chunkRead;
                                        ++inIndex;
                                        if (inIndex == 3) {
                                            inIndex = 0;
                                        }
                                        while (inIndex == outIndex) {
                                            try {
                                                dt.markTime("In thread waiting for available buffer...");
                                                lock.wait();
                                            }
                                            catch (InterruptedException e) {
                                                log.log(Level.SEVERE, "Received an interruption while fulling buffer on multi-threaded transfer; ignoring and continuing to wait", e);
                                            }
                                        }
                                    }
                                }
                            }
                            catch (IOException e) {
                                log.log(Level.SEVERE, "Error reading from InputStream", e);
                                Object object = lock;
                                synchronized (object) {
                                    inException = e;
                                    lock.notifyAll();
                                    return;
                                }
                            }
                        }
                    }.start();
                    do {
                        object = this.lock;
                        synchronized (object) {
                            ++this.outIndex;
                            if (this.outIndex == 3) {
                                this.outIndex = 0;
                            }
                            this.lock.notifyAll();
                            while (this.inIndex == this.outIndex && this.inException == null) {
                                try {
                                    dt.markTime("Out thread waiting for available buffer...");
                                    this.lock.wait();
                                }
                                catch (InterruptedException e) {
                                    log.log(Level.SEVERE, "Received an interruption while draining buffer on multi-threaded transfer; ignoring and continuing to wait", e);
                                }
                            }
                            chunkSize = this.sizes[this.outIndex];
                            if (this.inException != null) {
                                throw this.inException;
                            }
                        }
                        if (chunkSize == -1) continue;
                        dt.markTime("Writing a chunk of " + chunkSize + " chars to out");
                        writer.write(this.buffers[this.outIndex], 0, chunkSize);
                        result += (long)chunkSize;
                    } while (chunkSize != -1);
                    object = result;
                    return object;
                }
            }
        }.call();
    }

    public static void deleteRecursive(File fileToDelete) throws IOException {
        if (fileToDelete.exists()) {
            log.log(Level.FINE, "Deleting " + fileToDelete + " recursively");
            IOUtils._deleteRecursive(fileToDelete.toPath());
            if (fileToDelete.exists()) {
                log.log(Level.WARNING, "Deletion seemed to work, but file still exists at " + fileToDelete.getAbsolutePath());
            }
        } else {
            log.finest("Will not delete " + fileToDelete + " because it does not exist");
        }
    }

    private static void _deleteRecursive(Path fileToDelete) throws IOException {
        if (Files.exists(fileToDelete, LinkOption.NOFOLLOW_LINKS)) {
            if (Files.isDirectory(fileToDelete, new LinkOption[0])) {
                File[] children;
                while ((children = fileToDelete.toFile().listFiles()) != null && children.length != 0) {
                    for (File child : children) {
                        IOUtils._deleteRecursive(child.toPath());
                    }
                }
            }
            Files.delete(fileToDelete);
        }
    }

    public static void deleteRecursiveJava8(File fileToDelete) throws IOException {
        if (fileToDelete == null) {
            return;
        }
        Files.walkFileTree(fileToDelete.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                super.visitFile(file, attrs);
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                super.postVisitDirectory(dir, exc);
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void zipDir(String dir2zip, String zipFileName) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName), 65536));){
            IOUtils._zipDir(dir2zip, zos);
        }
    }

    public static void _zipDir(String dir2zip, ZipOutputStream zos) throws IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        if (dirList == null) {
            throw new IOException("Could not get list of files in " + zipDir.getAbsolutePath());
        }
        byte[] readBuffer = new byte[8192];
        for (String s : dirList) {
            int bytesIn;
            File f = new File(zipDir, s);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                IOUtils._zipDir(filePath, zos);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            ZipEntry anEntry = new ZipEntry(f.getPath());
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
            fis.close();
        }
    }

    public static void unzipDir(String file2unzip) throws IOException {
        ZipFile zipfile = new ZipFile(file2unzip);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            int count;
            ZipEntry entry = e.nextElement();
            log.info("Extracting: " + entry);
            BufferedInputStream is = new BufferedInputStream(zipfile.getInputStream(entry));
            byte[] data = new byte[8192];
            FileOutputStream fos = new FileOutputStream(entry.getName());
            BufferedOutputStream dest = new BufferedOutputStream(fos, 8192);
            while ((count = is.read(data, 0, 8192)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            is.close();
        }
    }

    public static boolean unzipStream(ZipInputStream stream, File dir) throws IOException {
        ZipEntry eachEntry;
        boolean hasEntries = false;
        while ((eachEntry = stream.getNextEntry()) != null) {
            hasEntries = true;
            String entryName = eachEntry.getName();
            if (File.separatorChar == '/') {
                entryName = entryName.replace('\\', File.separatorChar);
            }
            File eachFile = new File(dir, entryName);
            if (eachEntry.isDirectory()) {
                IOUtils.mkdirs(eachFile);
            } else {
                IOUtils.mkdirs(eachFile.getParentFile());
                try (FileOutputStream outStream = new FileOutputStream(eachFile);){
                    IOUtils.writeInputToOutput((InputStream)stream, (OutputStream)outStream, 8192);
                }
            }
            if (eachEntry.getTime() == -1L || eachFile.setLastModified(eachEntry.getTime())) continue;
            log.warning("Could not set loast modified timestamp for " + eachFile.getAbsolutePath());
        }
        return hasEntries;
    }

    public static void moveFile(File source, File dest) throws IOException {
        IOUtils.moveFile(source, dest, false);
    }

    public static void moveFile(@NotNull File source, @NotNull File dest, boolean overwriteDest) throws IOException {
        if (source == null) {
            IOUtils.$$$reportNull$$$0(13);
        }
        if (dest == null) {
            IOUtils.$$$reportNull$$$0(14);
        }
        if (dest.exists() && !overwriteDest) {
            throw new IOException("File already exists.  " + dest.getAbsolutePath() + " already exists.");
        }
        if (source.getCanonicalPath().equals(dest.getCanonicalPath())) {
            return;
        }
        if (!source.renameTo(dest)) {
            if (source.isDirectory()) {
                IOUtils.copyDirectory(source, dest);
            } else {
                IOUtils.copyFile(source, dest);
            }
            if (!source.delete()) {
                log.warning("After moving file from " + source.getAbsolutePath() + " to " + dest.getAbsolutePath() + ", could not delete source file - a copy of it will be left");
            }
        }
    }

    public static boolean mkdirs(File dir) throws IOException {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return false;
            }
            throw new FileNotFoundException("Could not create directory at " + dir.getAbsolutePath() + ", because a non-directory file exists at that location");
        }
        File parentFile = dir.getParentFile();
        if (!(parentFile == null || parentFile.exists() && parentFile.isDirectory())) {
            IOUtils.mkdirs(parentFile);
        }
        Files.createDirectory(Paths.get(dir.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        return true;
    }

    public static IOException ioExceptionWithCause(IOException ioException, Throwable e) {
        if (e != null) {
            ioException.initCause(e);
        }
        return ioException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areInputStreamsEqual(InputStream i1, InputStream i2) throws IOException {
        byte[] buf1 = new byte[8192];
        byte[] buf2 = new byte[8192];
        try {
            int len;
            DataInputStream d2 = new DataInputStream(i2);
            while ((len = i1.read(buf1)) > 0) {
                d2.readFully(buf2, 0, len);
                for (int i = 0; i < len; ++i) {
                    if (buf1[i] == buf2[i]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = d2.read() < 0;
            return bl;
        }
        catch (EOFException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            i1.close();
            i2.close();
        }
    }

    public static File findWriteableTempDirectory() throws IOException {
        File result = new File(System.getProperty("java.io.tmpdir"));
        if (result.canWrite()) {
            return result;
        }
        File file = result = Platform.isWin() ? new File("C:\\Windows\\TEMP") : new File("/tmp/");
        if (result.canWrite()) {
            return result;
        }
        return IOUtils.findWriteablePersistentDirectory(false);
    }

    public static File findWriteablePersistentDirectory(boolean preferUserDir) throws IOException {
        File result;
        if (preferUserDir) {
            result = IOUtils.findWriteablePersistentUserDirectory();
            if (result == null) {
                result = IOUtils.findWriteablePersistentSystemDirectory();
            }
        } else {
            result = IOUtils.findWriteablePersistentSystemDirectory();
            if (result == null) {
                result = IOUtils.findWriteablePersistentUserDirectory();
            }
        }
        if (result != null) {
            return result;
        }
        throw new IOException("Could not find a writeable directory");
    }

    private static File findWriteablePersistentSystemDirectory() {
        File result = null;
        if (Platform.isMac()) {
            result = new File("/Library/Application Support/360Works");
        } else if (!Platform.isWin()) {
            if (Platform.isLin()) {
                result = new File("/var/lib/360Works");
            } else {
                log.log(Level.WARNING, "Unsupported platform: " + (Object)((Object)Platform.current));
            }
        }
        if (result != null) {
            try {
                IOUtils.ensureDirectoryIsReady(result);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Could not find writeable system directory", e);
                result = null;
            }
        }
        return result;
    }

    private static File findWriteablePersistentUserDirectory() {
        File result = new File(System.getProperty("user.home"));
        if (result.canWrite()) {
            return result;
        }
        return null;
    }

    public static void ensureDirectoryIsReady(File targetDir) throws IOException {
        IOUtils.ensureDirectoryIsReady(targetDir, false);
    }

    public static void ensureDirectoryIsReady(File targetDir, boolean writeableForAll) throws IOException {
        block11: {
            if (targetDir == null) {
                throw new IllegalArgumentException("No value is specified for target directory");
            }
            while (targetDir.exists()) {
                if (targetDir.isDirectory()) {
                    if (!targetDir.canRead()) {
                        throw new FileNotFoundException("There is an existing directory at " + targetDir + ", but it is not readable.");
                    }
                    if (!targetDir.canWrite()) {
                        throw new FileNotFoundException("There is an existing directory at " + targetDir + ", but it is not writeable.");
                    }
                    break block11;
                }
                log.warning("Deleting non-directory file at " + targetDir + " to allow creation of directory at that location");
                if (targetDir.delete()) continue;
                throw new FileNotFoundException("An existing file at " + targetDir + " could not be deleted; the directory cannot be created.");
            }
            if (IOUtils.mkdirs(targetDir)) {
                log.log(Level.FINE, "successfully created '" + targetDir.getAbsolutePath() + "'");
            } else {
                String message = "The directory at " + targetDir.getAbsolutePath() + " does not exist and cannot be created.";
                File currentDir = targetDir;
                while ((currentDir = currentDir.getParentFile()) != null) {
                    if (!currentDir.exists() || currentDir.canWrite()) continue;
                    message = message + " This is because a parent directory at " + currentDir + " is not writeable.";
                    break;
                }
                throw new FileNotFoundException(message);
            }
        }
        if (writeableForAll && (Platform.isMac() || Platform.isLin())) {
            try {
                ProcessUtils.doShellCommand(new String[]{"/bin/chmod", "-R", "777", targetDir.getAbsolutePath()}, null, null);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Directory exists at " + targetDir.getAbsolutePath() + ", but it could not be changed to allow access for all users.", e);
            }
        }
    }

    public static void ensureFileIsReady(File file, boolean readable, boolean writeable) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("A directory already exists at " + file.getAbsolutePath() + " so no file can be created at that path.");
            }
            if (readable && !file.canRead()) {
                throw new IOException("File already exists at " + file.getAbsolutePath() + ", but it is not readable.");
            }
            if (writeable && !file.canWrite()) {
                throw new IOException("File already exists at " + file.getAbsolutePath() + ", but it is not writeable.");
            }
        } else if (!file.getParentFile().exists()) {
            IOUtils.ensureDirectoryIsReady(file.getParentFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpIOException rethrowHttpException(IOException e, HttpURLConnection connection) throws HttpIOException {
        String newMessage;
        int responseCode;
        InputStream errStream = connection.getErrorStream();
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException e1) {
            responseCode = -1;
        }
        if (errStream == null) {
            throw new HttpIOException(e, connection.getURL(), null, responseCode, connection.getHeaderFields());
        }
        String errorString = null;
        try {
            errorString = IOUtils.inputStreamAsString(errStream);
            newMessage = e.getMessage() + ". HTTP Server message: " + errorString;
        }
        catch (IOException e1) {
            log.log(Level.SEVERE, "Could not read error stream from HTTP server", e1);
            newMessage = e.getMessage();
        }
        finally {
            IOUtils.closeQuietly(errStream);
        }
        HttpIOException rethrow = new HttpIOException(newMessage, connection.getURL(), errorString, responseCode, connection.getHeaderFields());
        rethrow.initCause(e);
        throw rethrow;
    }

    public static void setRequestAuthentication(URLConnection connection, String username, String password) {
        byte[] bytes = (username + ":" + password).getBytes(StandardCharsets.UTF_8);
        String encodedAuth = IOUtils.base64Encode(bytes);
        encodedAuth = encodedAuth.replace("\n", "");
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
    }

    public static void setBearerTokenAuthentication(URLConnection connection, @NotNull String token) {
        if (token == null) {
            IOUtils.$$$reportNull$$$0(15);
        }
        connection.setRequestProperty("Authorization", "Bearer " + token);
    }

    public static String base64Encode(byte[] bytes) {
        try {
            Object encoder = Class.forName("java.util.Base64").getMethod("getEncoder", new Class[0]).invoke(null, new Object[0]);
            return (String)encoder.getClass().getMethod("encodeToString", byte[].class).invoke(encoder, new Object[]{bytes});
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> encoderClass = Class.forName("sun.misc.BASE64Encoder");
                return (String)encoderClass.getMethod("encode", byte[].class).invoke(encoderClass.newInstance(), new Object[]{bytes});
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] base64Decode(String base64) {
        try {
            Object decoder = Class.forName("java.util.Base64").getMethod("getDecoder", new Class[0]).invoke(null, new Object[0]);
            return (byte[])decoder.getClass().getMethod("decode", String.class).invoke(decoder, base64);
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> decoderClass = Class.forName("sun.misc.Base64Decoder");
                return (byte[])decoderClass.getMethod("decodeBuffer", String.class).invoke(decoderClass.newInstance(), base64);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void openConnectionInterruptibly(HttpURLConnection urlConnection) throws InterruptedException, IOException {
        if (downloadQueue == null) {
            downloadQueue = Executors.newCachedThreadPool(new MyThreadFactory("Interruptible URL connection"){

                @Override
                public Thread newThread(@NotNull Runnable r) {
                    if (r == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Thread result = super.newThread(r);
                    result.setDaemon(true);
                    return result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/prosc/io/IOUtils$4", "newThread"));
                }
            });
        }
        ThreadUtil.getInterruptible(downloadQueue.submit(() -> {
            urlConnection.getInputStream();
            return null;
        }), IOException.class);
    }

    public static String resourceAsString(Class<?> contextClass, String resourceName) throws IOException {
        URL resource = ClassUtils.getResource(contextClass, resourceName).orElseThrow(() -> new IllegalArgumentException("There is no resource named '" + resourceName + "' associated with class '" + contextClass.getName() + "'"));
        return IOUtils.urlConnectionAsString(resource.openConnection());
    }

    public static String safeFilename(String filename) {
        return filename.replace('/', '_').replace('\\', '_');
    }

    public static String dumpResponseHeaders(URLConnection connection) {
        int headerCount = connection.getHeaderFields().size();
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < headerCount; ++n) {
            String key = connection.getHeaderFieldKey(n);
            String value = connection.getHeaderField(key);
            sb.append(key + ": " + value + "\n");
        }
        return sb.toString();
    }

    public static boolean areFilesIdentical(File file1, File file2) throws IOException {
        if (file1.length() != file2.length()) {
            return false;
        }
        if (file1.length() == 0L) {
            return true;
        }
        if (file1.length() > Integer.MAX_VALUE) {
            return true;
        }
        int bufferSize = Math.min(65536, (int)file1.length());
        byte[] buffer1 = new byte[bufferSize];
        byte[] buffer2 = new byte[bufferSize];
        try (FileInputStream stream1 = new FileInputStream(file1);
             FileInputStream stream2 = new FileInputStream(file2);){
            byte[][] buffers = new byte[][]{buffer1, buffer2};
            InputStream[] streams = new InputStream[]{stream1, stream2};
            int totalBytesRemaining = (int)file1.length();
            while (true) {
                if (totalBytesRemaining > 0) {
                    int chunkLength = Math.min(totalBytesRemaining, bufferSize);
                    for (int n = 0; n < 2; ++n) {
                        int chunkBytesRemaining;
                        int bytesRead = 0;
                        while ((chunkBytesRemaining = chunkLength - bytesRead) > 0) {
                            bytesRead += streams[n].read(buffers[n], bytesRead, chunkBytesRemaining);
                        }
                    }
                    totalBytesRemaining -= chunkLength;
                    if (Arrays.equals(buffer1, buffer2)) continue;
                    boolean bl = false;
                    return bl;
                    continue;
                }
                break;
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        Writer devNull = new Writer(){

            @Override
            public void write(@NotNull char[] cbuf, int off, int len) {
                if (cbuf == null) {
                    5.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbuf", "com/prosc/io/IOUtils$5", "write"));
            }
        };
        FileWriter tmpWriter = new FileWriter("/tmp/deleteMe");
        StringReader reader = new StringReader(new String(new char[100000000]));
        try (DebugTimer dt = new DebugTimer("Writing streams");){
            long bytesWritten = IOUtils.writeReaderToWriter(reader, tmpWriter);
            dt.markTime("Finished writing " + bytesWritten + " bytes");
        }
    }

    public static File relativeFile(File baseDir, String relativePath) {
        if (relativePath.startsWith(FILEPATH_SEPARATOR)) {
            return new File(relativePath);
        }
        return new File(baseDir, relativePath);
    }

    public static void changeGroup(File targetDir, String groupName, boolean recursive) throws ProcessExecutionException {
        try {
            String[] commandArray = recursive ? new String[]{"/usr/bin/chgrp", "-R", groupName, targetDir.getAbsolutePath()} : new String[]{"/usr/bin/chgrp", groupName, targetDir.getAbsolutePath()};
            ProcessUtils.doShellCommand(commandArray, null, targetDir);
        }
        catch (UserCanceledException e) {
            throw new RuntimeException(e);
        }
        catch (ProcessExecutionException e) {
            log.log(Level.WARNING, "Could not change group on destination file " + targetDir.getAbsolutePath() + " to '" + groupName + "' because of this error: " + e, e);
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputs";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/io/IOUtils";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postArgs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/io/IOUtils";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readerAsString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "urlConnectionAsString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeInputToOutput";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sendChunkWithRetry";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeInputToOutputs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inputStreamAsBytes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "inputStreamAsString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readerAsString";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "postDataToUrlConnection";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setBearerTokenAuthentication";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

