/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.core.AppSettings;
import com.prosc.shared.ProscMail;
import com.prosc.thread.MyThreadFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class EmailLogHandler
extends Handler {
    private static final Logger log = Logger.getLogger(EmailLogHandler.class.getName());
    private final ExecutorService sender = Executors.newSingleThreadExecutor(new MyThreadFactory("Email Log sender"));
    private static final String TO_ADDRESS_KEY;
    private static final String FROM_ADDRESS_KEY;
    private static final String SMTP_SERVER_KEY;
    private static final String SMTP_PORT_KEY;
    private static final String ipAddress;
    private final List<LogRecord> queuedMessages = new LinkedList<LogRecord>();
    private String toAddress;
    private String fromAddress;
    private String smtpHost;
    private String smtpPort;

    public EmailLogHandler() {
        this.configure();
    }

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        this.setFormatter(new SimpleFormatter());
        this.toAddress = manager.getProperty(TO_ADDRESS_KEY);
        this.fromAddress = manager.getProperty(FROM_ADDRESS_KEY);
        if (this.fromAddress == null) {
            this.fromAddress = "EmailLogHandler@360works.com";
        }
        this.smtpHost = manager.getProperty(SMTP_SERVER_KEY);
        if (this.smtpHost == null) {
            this.smtpHost = System.getProperty("mail.smtp.host");
        }
        if (this.smtpHost == null) {
            this.smtpHost = AppSettings.getSharedInstance().getProperty("mail.smtp.host");
        }
        this.smtpPort = manager.getProperty(SMTP_PORT_KEY);
        if (this.smtpPort == null) {
            this.smtpPort = System.getProperty("mail.smtp.port");
        }
        if (this.smtpPort == null) {
            this.smtpPort = AppSettings.getSharedInstance().getProperty("mail.smtp.port");
        }
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (!super.isLoggable(record)) {
            return false;
        }
        boolean result = true;
        if (this.toAddress == null) {
            System.err.println("EmailLogHandler cannot send a message because the " + TO_ADDRESS_KEY + " logging property is not configured.");
            result = false;
        }
        if (this.smtpHost == null) {
            System.err.println("EmailLogHandler cannot send a message because neither the " + SMTP_SERVER_KEY + " logging property or the mail.smtp.host system property are configured.");
            result = false;
        }
        if (this.fromAddress == null) {
            System.err.println("EmailLogHandler cannot send a message because the " + FROM_ADDRESS_KEY + " logging property is not configured, or is set to null.");
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        List<LogRecord> list = this.queuedMessages;
        synchronized (list) {
            this.queuedMessages.add(record);
        }
    }

    protected void sendEmail(String subject, String messageText) throws MessagingException {
        MimeMessage mimeMessage = ProscMail.createMessage(this.fromAddress, this.toAddress, subject, null, messageText);
        Properties properties = new Properties(AppSettings.getSharedInstance());
        if (this.smtpHost != null) {
            properties.setProperty("mail.smtp.host", this.smtpHost);
        }
        if (this.smtpPort != null) {
            properties.setProperty("mail.smtp.port", this.smtpPort);
        }
        ProscMail.sendMessage(mimeMessage, properties);
        System.out.println("Sent e-mail successfully via SMTP");
    }

    @Override
    public void flush() {
        this.sender.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = EmailLogHandler.this.queuedMessages;
                synchronized (list) {
                    if (EmailLogHandler.this.queuedMessages.size() == 0) {
                        return;
                    }
                    LogRecord firstMessage = (LogRecord)EmailLogHandler.this.queuedMessages.get(0);
                    String subject = "Log message from " + firstMessage.getLoggerName() + " running on " + ipAddress;
                    StringBuilder sb = new StringBuilder();
                    String delim = "";
                    for (LogRecord record : EmailLogHandler.this.queuedMessages) {
                        sb.append(delim).append(EmailLogHandler.this.getFormatter().format(record));
                        delim = "\n\n";
                    }
                    try {
                        EmailLogHandler.this.sendEmail(subject, sb.toString());
                    }
                    catch (MessagingException e) {
                        System.err.println("Could not send e-mail log message because an exception occurred: " + e);
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void close() throws SecurityException {
        log.info("close() called on EmailLogHandler");
        this.flush();
        this.sender.shutdown();
        try {
            this.sender.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        String className = EmailLogHandler.class.getName();
        TO_ADDRESS_KEY = className + ".to";
        FROM_ADDRESS_KEY = className + ".from";
        SMTP_SERVER_KEY = className + ".smtpHost";
        SMTP_PORT_KEY = className + ".smtpPort";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

