/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.unicode;

import com.prosc.fmkit.unicode.Debug;
import com.prosc.fmkit.unicode.EndOfInputException;
import com.prosc.fmkit.unicode.Expand;
import com.prosc.fmkit.unicode.IllegalInputException;

public class Display
extends Expand {
    static final String[] uCommand = new String[]{"<UC0>", "<UC1>", "<UC2>", "<UC3>", "<UC4>", "<UC5>", "<UC6>", "<UC7>", "<UD0>", "<UD1>", "<UD2>", "<UD3>", "<UD4>", "<UD5>", "<UD6>", "<UD7>", "<UQU>", "<UDX>", "<Urs>"};
    static final String[] sCommand = new String[]{"<NUL>", "<SQ0>", "<SQ1>", "<SQ2>", "<SQ3>", "<SQ4>", "<SQ5>", "<SQ6>", "<SQ7>", "<TAB>", "<NL>", "<SDX>", "<Srs>", "<CR>", "<SQU>", "<SCU>", "<SC0>", "<SC1>", "<SC2>", "<SC3>", "<SC4>", "<SC5>", "<SC6>", "<SC7>", "<SD0>", "<SD1>", "<SD2>", "<SD3>", "<SD4>", "<SD5>", "<SD6>", "<SD7>"};

    private void output(String command, StringBuffer sb) {
        sb.append(command);
        this.iOut += command.length();
    }

    @Override
    protected int expandUnicode(byte[] in, int iCur, StringBuffer sb) throws IllegalInputException, EndOfInputException {
        while (iCur < in.length - 1) {
            byte b = in[iCur];
            if (b >= -32 && b <= -25) {
                this.output(uCommand[b - -32], sb);
                this.selectWindow(b - -32);
                return iCur;
            }
            if (b >= -24 && b <= -17) {
                this.output(uCommand[b - -32], sb);
                this.defineWindow(b - -24, in[iCur + 1]);
                return iCur + 1;
            }
            if (b == -15) {
                this.output(uCommand[b - -32], sb);
                if (iCur >= in.length - 2) break;
                this.defineExtendedWindow(Display.charFromTwoBytes(in[iCur + 1], in[iCur + 2]));
                return iCur + 2;
            }
            if (b == -16) {
                this.output(uCommand[b - -32], sb);
                if (iCur >= in.length - 2) break;
                ++iCur;
            }
            char ch = Display.charFromTwoBytes(in[iCur], in[iCur + 1]);
            sb.append(ch);
            ++this.iOut;
            iCur += 2;
        }
        if (iCur == in.length) {
            return iCur;
        }
        throw new EndOfInputException();
    }

    @Override
    protected String expandSingleByte(byte[] in) throws IllegalInputException, EndOfInputException {
        int iCur;
        StringBuffer sb = new StringBuffer(in.length);
        this.iOut = 0;
        block9: for (iCur = 0; iCur < in.length; ++iCur) {
            int iStaticWindow = 0;
            int iDynamicWindow = this.getCurrentWindow();
            switch (in[iCur]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.output(sCommand[in[iCur]], sb);
                    if (iCur >= in.length - 1) {
                        Debug.out("SQn missing argument: ", in, iCur);
                        break block9;
                    }
                    iDynamicWindow = iStaticWindow = in[iCur] - 1;
                    ++iCur;
                }
                default: {
                    int ch;
                    if (in[iCur] >= 0) {
                        ch = in[iCur] + staticOffset[iStaticWindow];
                        sb.append((char)ch);
                        ++this.iOut;
                        continue block9;
                    }
                    ch = in[iCur] + 256;
                    ch -= 128;
                    Debug.out("Dynamic: ", (char)(ch += this.dynamicOffset[iDynamicWindow]));
                    if (ch < 65536) {
                        sb.append((char)ch);
                        ++this.iOut;
                        continue block9;
                    }
                    Debug.out("Extension character: ", ch);
                    sb.append((char)(55296 + ((ch -= 65536) >> 10)));
                    ++this.iOut;
                    sb.append((char)(56320 + (ch & 0xFFFF03FF)));
                    ++this.iOut;
                    continue block9;
                }
                case 11: {
                    this.output(sCommand[in[iCur]], sb);
                    if ((iCur += 2) >= in.length) {
                        Debug.out("SDn missing argument: ", in, iCur - 1);
                        break block9;
                    }
                    this.defineExtendedWindow(Display.charFromTwoBytes(in[iCur - 1], in[iCur]));
                    continue block9;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this.output(sCommand[in[iCur]], sb);
                    if (++iCur >= in.length) {
                        Debug.out("SDn missing argument: ", in, iCur - 1);
                        break block9;
                    }
                    this.defineWindow(in[iCur - 1] - 24, in[iCur]);
                    continue block9;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    this.output(sCommand[in[iCur]], sb);
                    this.selectWindow(in[iCur] - 16);
                    continue block9;
                }
                case 15: {
                    this.output(sCommand[in[iCur]], sb);
                    iCur = this.expandUnicode(in, iCur + 1, sb);
                    continue block9;
                }
                case 14: {
                    this.output(sCommand[in[iCur]], sb);
                    if ((iCur += 2) >= in.length) {
                        Debug.out("SQU missing argument: ", in, iCur - 2);
                        break block9;
                    }
                    int ch = Display.charFromTwoBytes(in[iCur - 1], in[iCur]);
                    Debug.out("Quoted: ", (char)ch);
                    sb.append((char)ch);
                    ++this.iOut;
                    continue block9;
                }
                case 12: {
                    this.output(sCommand[in[iCur]], sb);
                    throw new IllegalInputException();
                }
            }
        }
        if (iCur >= in.length) {
            sb.setLength(this.iOut);
            this.iIn = iCur;
            return sb.toString();
        }
        Debug.out("Length ==" + in.length + " iCur =", iCur);
        throw new EndOfInputException();
    }
}

