/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.unicode;

public class Debug {
    static boolean debug = false;

    public static void set(boolean debug) {
        Debug.debug = debug;
    }

    public static void out(char[] chars) {
        Debug.out(chars, 0);
    }

    public static void out(char[] chars, int iStart) {
        if (!debug) {
            return;
        }
        for (int i = iStart; i < chars.length; ++i) {
            if (chars[i] >= '\u0000' && chars[i] <= '\u001a') {
                System.out.print("^" + (char)(chars[i] + 64));
                continue;
            }
            if (chars[i] <= '\u00ff') {
                System.out.print(chars[i]);
                continue;
            }
            System.out.print("\\u" + Integer.toString(chars[i], 16));
        }
        System.out.println();
    }

    public static void out(byte[] bytes) {
        Debug.out(bytes, 0);
    }

    public static void out(byte[] bytes, int iStart) {
        if (!debug) {
            return;
        }
        for (int i = iStart; i < bytes.length; ++i) {
            System.out.print(bytes[i] + ",");
        }
        System.out.println();
    }

    public static void out(String str) {
        if (!debug) {
            return;
        }
        System.out.println(str);
    }

    public static void out(String msg, int iData) {
        if (!debug) {
            return;
        }
        System.out.print(msg);
        System.out.println(iData);
    }

    public static void out(String msg, char ch) {
        if (!debug) {
            return;
        }
        System.out.print(msg);
        System.out.print("[U+" + Integer.toString(ch, 16) + "]");
        System.out.println(ch);
    }

    public static void out(String msg, byte bData) {
        if (!debug) {
            return;
        }
        System.out.print(msg);
        System.out.println(bData);
    }

    public static void out(String msg, String str) {
        if (!debug) {
            return;
        }
        System.out.print(msg);
        System.out.println(str);
    }

    public static void out(String msg, char[] data) {
        if (!debug) {
            return;
        }
        System.out.print(msg);
        Debug.out(data);
    }

    public static void out(String msg, byte[] data) {
        if (!debug) {
            return;
        }
        System.out.print(msg);
        Debug.out(data);
    }

    public static void out(String msg, char[] data, int iStart) {
        if (!debug) {
            return;
        }
        System.out.print(msg + "(" + iStart + "): ");
        Debug.out(data, iStart);
    }

    public static void out(String msg, byte[] data, int iStart) {
        if (!debug) {
            return;
        }
        System.out.print(msg + "(" + iStart + "): ");
        Debug.out(data, iStart);
    }
}

