/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.design;

public class FieldType {
    private final String storageType;
    private final String dataType;
    private final boolean indexed;
    private final int repetitions;

    public FieldType(String fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("fieldType must not be null.");
        }
        String[] strings = fieldType.split("\\s");
        this.storageType = strings[0];
        this.dataType = strings[1];
        this.indexed = "Indexed".equals(strings[2]);
        this.repetitions = Integer.parseInt(strings[3]);
    }

    public String getStorageType() {
        return this.storageType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public boolean isStandardStorageType() {
        return "Standard".equals(this.storageType);
    }

    public boolean isCalculatedStorageType() {
        return "StoredCalc".equals(this.storageType) || "UnstoredCalc".equals(this.storageType);
    }

    public boolean isSummaryStorageType() {
        return "Summary".equals(this.storageType);
    }

    public boolean isGlobalStorageType() {
        return "Global".equals(this.storageType);
    }

    public boolean isContainerDataType() {
        return "Container".equals(this.dataType);
    }
}

