/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.prosc.fmkit.BugReporter;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.ProscPlugin;
import com.prosc.fmkit.RegisterablePlugin;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.Registration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;

public class ProscPluginConfigDialog2
extends JDialog {
    private static final Logger log = Logger.getLogger(ProscPluginConfigDialog2.class.getName());
    private JPanel rootPanel;
    private JTextField licenseKey;
    private JTextField registeredTo;
    private JButton sendProblemReportButton;
    private JButton registerButton;
    private JButton OKButton;
    private JTextPane licenseInfo;
    private JPanel registrationPanel;
    private final ProscPlugin whichplugin;

    public ProscPluginConfigDialog2(ProscPlugin whichPlugin, Registration registration, Frame owner) throws HeadlessException {
        super(owner, whichPlugin.getName() + " configuration", true);
        this.$$$setupUI$$$();
        this.whichplugin = whichPlugin;
        this.setContentPane(this.rootPanel);
        this.setLocationRelativeTo(null);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setAutoRequestFocus(true);
        this.setFocusableWindowState(true);
        if (whichPlugin instanceof RegisterablePlugin) {
            Registration pluginRegistration = ((RegisterablePlugin)whichPlugin).getRegistration();
            if (pluginRegistration != null) {
                this.licenseKey.setText(pluginRegistration.getLicenseKey());
                this.registeredTo.setText(pluginRegistration.getCompanyName());
            }
            this.registerButton.addActionListener(event -> {
                try {
                    RegisterablePlugin plugin = (RegisterablePlugin)whichPlugin;
                    plugin.defaultRegister(this.licenseKey.getText(), this.registeredTo.getText());
                    String info = this.getLicenseInfo(plugin);
                    this.licenseInfo.setText(info);
                    plugin.storeRegistration();
                    JOptionPane.showConfirmDialog(this, "Successfully Registered: \n\n" + info, "Success", -1, 1);
                }
                catch (InvalidLicenseException e) {
                    String message = "Error During Registration: " + e.getMessage();
                    log.log(Level.SEVERE, message, e);
                    new JOptionPane(message, 0, -1).createDialog(this, "Error").setVisible(true);
                }
            });
            this.licenseInfo.setText(this.getLicenseInfo((RegisterablePlugin)whichPlugin));
            this.registrationPanel.setVisible(true);
        } else {
            this.registrationPanel.setVisible(false);
        }
        this.sendProblemReportButton.addActionListener(e -> {
            BugReporter reporter = new BugReporter((Dialog)this, (Plugin)whichPlugin, registration);
            reporter.pack();
            reporter.setVisible(true);
        });
        this.OKButton.addActionListener(e -> this.dispose());
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProscPluginConfigDialog2.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
    }

    private String getLicenseInfo(RegisterablePlugin plugin) {
        String info = plugin.getName() + " v" + plugin.getVersion().stringVersion;
        try {
            plugin.getRegistration().checkLicense();
            info = info + "\n" + plugin.getRegistration().getLicenseInfo().replaceAll("Major.*\n", "");
        }
        catch (InvalidLicenseException e) {
            info = info + "\n" + e.getLocalizedMessage();
        }
        return info;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.whichplugin.getContext().reactivateJavaWindow();
        }
    }

    private void $$$setupUI$$$() {
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.rootPanel.setMinimumSize(new Dimension(250, 220));
        this.rootPanel.setPreferredSize(new Dimension(550, 275));
        this.registrationPanel = new JPanel();
        this.registrationPanel.setLayout(new GridLayoutManager(3, 3, new Insets(15, 15, 15, 15), -1, -1));
        this.rootPanel.add((Component)this.registrationPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.licenseKey = new JTextField();
        this.registrationPanel.add((Component)this.licenseKey, new GridConstraints(0, 1, 1, 2, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.registeredTo = new JTextField();
        this.registrationPanel.add((Component)this.registeredTo, new GridConstraints(1, 1, 1, 2, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("License Key:");
        this.registrationPanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Registered To:");
        this.registrationPanel.add((Component)label2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.registerButton = new JButton();
        this.registerButton.setText("Register");
        this.registrationPanel.add((Component)this.registerButton, new GridConstraints(2, 2, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.licenseInfo = new JTextPane();
        this.licenseInfo.setEditable(false);
        this.licenseInfo.setForeground(new Color(-5526360));
        this.licenseInfo.setMargin(new Insets(10, 0, 10, 10));
        this.licenseInfo.setOpaque(false);
        this.licenseInfo.setText("JaCK tests v1.0605\nType: Demo version(0)\nRegistered To: null\nExpires on: Apr 30, 2019, 7:29:44 PM");
        this.registrationPanel.add((Component)this.licenseInfo, new GridConstraints(2, 1, 1, 1, 0, 3, 4, 4, null, new Dimension(150, 50), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(1, 2, new Insets(15, 15, 15, 15), -1, -1));
        this.rootPanel.add((Component)panel1, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.sendProblemReportButton = new JButton();
        this.sendProblemReportButton.setText("Send Problem Report");
        panel1.add((Component)this.sendProblemReportButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.OKButton = new JButton();
        this.OKButton.setText("OK");
        panel1.add((Component)this.OKButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.rootPanel.add((Component)panel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JSeparator separator1 = new JSeparator();
        panel2.add((Component)separator1, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 4, null, null, null, 0, false));
        label1.setLabelFor(this.licenseKey);
        label2.setLabelFor(this.registeredTo);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }
}

