/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.deployment.DeploymentInfo;
import com.prosc.fmkit.Configurable;
import com.prosc.fmkit.FileMakerOperation;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.GuiMode;
import com.prosc.fmkit.IdleHandler;
import com.prosc.fmkit.PluginBridge2;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.StaticFunction;
import com.prosc.fmkit.VersionInfo;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.infrastructure.LogUtils;
import com.prosc.infrastructure.Platform;
import com.prosc.shared.CaseInsensitiveMap;
import com.prosc.shared.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.BufferedOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class Plugin {
    private static final Logger log = Logger.getLogger(Plugin.class.getName());
    private Throwable lastError;
    private Short applicationType;
    private LinkedList<PluginFunction> currentFunctions = new LinkedList();
    private PluginBridge2 pluginBridge;
    private boolean errorCapture = false;
    private boolean windowManagementEnabled = true;
    final Deque<PluginContext> currentContextStack = new ArrayDeque<PluginContext>();
    final LinkedList<FileMakerOperation> operationQueue = new LinkedList();
    Exception lastOperationStackTrace = null;
    Throwable lastErrorComplainedAbout = null;
    boolean isErrorVisible = false;
    private JDialog dialogForFocus = null;
    private Frame frame = null;

    public abstract QuadChar getShortId();

    public abstract String getName();

    public abstract String getHelpText();

    protected abstract VersionInfo getVersion();

    public final PluginContext getContext() {
        return this.currentContextStack.peek();
    }

    @NotNull
    public PluginBridge2 getPluginBridge() {
        PluginBridge2 pluginBridge2 = this.pluginBridge;
        if (pluginBridge2 == null) {
            Plugin.$$$reportNull$$$0(0);
        }
        return pluginBridge2;
    }

    final void init(PluginBridge2 pluginBridge, boolean firstInstance) {
        this.pluginBridge = pluginBridge;
        if (pluginBridge == null) {
            String msg = "Plugin Bridge is null. How is this possible?";
            log.severe(msg);
            throw new RuntimeException(msg);
        }
        log.config("Created new plugin instance: " + this.getClass().getName() + " named " + this.getName() + " on thread: " + Thread.currentThread().getName() + "; version: " + this.getVersion().stringVersion);
        this.init(firstInstance);
    }

    public final PluginFunction getCurrentFunction() {
        return this.currentFunctions.getLast();
    }

    public final Object[] maskParameters(Object[] parameters, HashMap replacementParameters) {
        LinkedHashMap<String, Object> requiredMap = new LinkedHashMap<String, Object>();
        CaseInsensitiveMap<String> additionalMap = new CaseInsensitiveMap<String>();
        String prototype = this.getCurrentFunction().getPrototype();
        int indexOfAdditional = prototype.indexOf("{");
        String[] arguments = indexOfAdditional >= 0 ? prototype.substring(0, indexOfAdditional).replace(" ", "").split(";") : prototype.replace(" ", "").split(";");
        Pattern noLogPattern = Pattern.compile(".*noLog.*", 2);
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (parameter instanceof Object[]) {
                Object[] additionalParameters;
                for (Object additionalParameter : additionalParameters = (Object[])parameter) {
                    String[] nameValuePair = String.valueOf(additionalParameter).split("=");
                    if (nameValuePair.length != 2) continue;
                    if (nameValuePair[0] != null && nameValuePair[1] != null && noLogPattern.matcher(nameValuePair[0]).matches()) {
                        nameValuePair[1] = "<NOT_LOGGED>";
                    }
                    additionalMap.put(nameValuePair[0], nameValuePair[0] + "=" + nameValuePair[1]);
                }
                continue;
            }
            if (i >= arguments.length) continue;
            String requiredParameterName = arguments[i];
            if (noLogPattern.matcher(requiredParameterName).matches()) {
                requiredMap.put(requiredParameterName, "<NOT_LOGGED>");
                continue;
            }
            requiredMap.put(requiredParameterName, parameter);
        }
        for (Object replacementParameter : replacementParameters.keySet()) {
            if (requiredMap.containsKey(replacementParameter)) {
                requiredMap.put((String)replacementParameter, replacementParameters.get(replacementParameter));
            }
            if (!additionalMap.containsKey(replacementParameter)) continue;
            additionalMap.put(replacementParameter, replacementParameter + "=" + replacementParameters.get(replacementParameter));
        }
        Object[] result = new Object[parameters.length];
        int i = 0;
        Iterator it = requiredMap.values().iterator();
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        if (!additionalMap.isEmpty()) {
            result[i] = additionalMap.values().toArray();
        }
        return result;
    }

    public void init(boolean isFirstInstance) {
    }

    public boolean customizeFunction(StaticFunction eachFunction) {
        return true;
    }

    protected FMType handleException(Throwable e, Object[] params) {
        return this.handleExceptionByStoringError(e, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeFunctionNoErrors(PluginFunction whichFunction, PluginContext context, Object[] convertedParams, Exception paramConvertException, GuiMode guiMode) {
        block16: {
            if (!(whichFunction.getName().endsWith("LastError") || whichFunction.getName().endsWith("LastErrorMessage") || whichFunction.getName().endsWith("LastStackTrace"))) {
                this.lastError = null;
            }
            try {
                this.currentFunctions.addLast(whichFunction);
                if (paramConvertException != null) {
                    throw paramConvertException;
                }
                if (log.isLoggable(Level.FINER)) {
                    ArrayList<String> paramsForLogging = new ArrayList<String>(convertedParams.length);
                    for (Object parameter : convertedParams) {
                        String eachParam = String.valueOf(parameter);
                        if (eachParam.length() > 1024) {
                            eachParam = eachParam.substring(0, 1024) + "...";
                        }
                        paramsForLogging.add(eachParam);
                    }
                    log.log(Level.CONFIG, "PluginFunction {0} invoked with converted args {1}", new Object[]{this, paramsForLogging});
                }
                try {
                    if (guiMode == GuiMode.Swing) {
                        FutureTask<FMType> invokePluginFunctionTask = new FutureTask<FMType>(() -> {
                            FMType type;
                            try {
                                this.initFrame();
                                type = this.invokeFunction(whichFunction, convertedParams);
                            }
                            catch (HeadlessException e) {
                                throw new RuntimeException("Dialog windows cannot be shown while running in this environment: " + e.getMessage(), e);
                            }
                            finally {
                                this.disposeFrame();
                            }
                            return type;
                        });
                        SwingUtilities.invokeLater(invokePluginFunctionTask);
                        try {
                            context.setFunctionResult(invokePluginFunctionTask.get());
                            break block16;
                        }
                        catch (ExecutionException e) {
                            throw e.getCause();
                        }
                    }
                    FMType result = this.invokeFunction(whichFunction, convertedParams);
                    context.setFunctionResult(result);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable throwable) {
                context.setFunctionResult(this.handleException(throwable, convertedParams));
            }
            finally {
                this.currentFunctions.removeLast();
            }
        }
    }

    protected FMType invokeFunction(PluginFunction function, Object[] parameters) throws Exception {
        return (FMType)function.invoke(this, parameters);
    }

    public void shutdown() throws IOException {
    }

    public void onSessionEnd() {
    }

    public void onSessionBegin() {
    }

    public void onFileClose(long fileId) {
    }

    public boolean isVersionCompatible(short apiVersion, short applicationType) {
        return true;
    }

    protected void setLastError(Throwable t, Object[] parameters) {
        if (t == null) {
            throw new IllegalArgumentException("lastError throwable must not be null.");
        }
        PluginFunction f = this.currentFunctions.getLast();
        this.lastError = t;
        if (parameters == null) {
            log.log(Level.SEVERE, "PluginFunction " + f + " got an error", t);
        } else {
            ArrayList<Object> paramList = new ArrayList<Object>(parameters.length);
            for (Object parameter : parameters) {
                if (parameter instanceof Object[]) {
                    paramList.add(Arrays.asList((Object[])parameter));
                    continue;
                }
                paramList.add(parameter);
            }
            log.log(Level.SEVERE, "PluginFunction " + f + " got an error with converted args " + paramList, t);
        }
    }

    protected Throwable getLastError() {
        return this.lastError;
    }

    protected FMText defaultLastError() {
        String result = this.getLastErrorString();
        return result == null ? null : new FMText(this.getContext(), result);
    }

    protected String getLastErrorString() {
        Throwable t = this.getLastError();
        if (t == null) {
            return null;
        }
        String result = t instanceof Error || t instanceof RuntimeException || t.getMessage() == null ? t.toString() : t.getLocalizedMessage();
        return result;
    }

    protected FMType defaultVersion() {
        return new FMText(this.getContext(), this.getVersion().stringVersion);
    }

    protected void defaultSetErrorCapture(boolean errorCapture) {
        log.info("errorCapture set to " + errorCapture);
        this.errorCapture = errorCapture;
    }

    protected void defaultSetWindowManagement(boolean windowManagementEnabled) {
        if (!windowManagementEnabled) {
            this.getContext().disableWindowManagement();
        } else {
            this.getContext().enableWindowManagement();
        }
        this.windowManagementEnabled = windowManagementEnabled;
    }

    protected FMText handleExceptionByStoringError(Throwable e, Object[] params) {
        try {
            this.setLastError(e, params);
            return this.failureValue();
        }
        catch (Exception e1) {
            log.log(Level.SEVERE, "There was an error in the error handler itself!", e1);
            return new FMText(this.getContext(), "ERROR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportProblem(String emailAddress, String problemDescription, String phoneNumber, Integer orderId, String licenseInfo, boolean includeLog) throws IOException {
        HttpURLConnection urlConnection;
        block18: {
            String bugReportUrl = "https://bugreporter.360works.com/BugReporter/Plugin";
            urlConnection = (HttpURLConnection)new URL(bugReportUrl).openConnection();
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(urlConnection.getOutputStream()), "utf-8");){
                this.sendData(writer, "email", emailAddress, true);
                this.sendData(writer, "phone", phoneNumber, false);
                this.sendData(writer, "problemReport", problemDescription, false);
                this.sendData(writer, "pluginName", this.getName(), false);
                this.sendData(writer, "pluginVersion", this.getVersion().toString(), false);
                if (this.getPluginBridge() != null) {
                    String systemEnvironment = LogUtils.getSystemInfo(true, true, true);
                    try {
                        DeploymentInfo deploymentInfo = DeploymentInfo.getApplicationInstance();
                        systemEnvironment = systemEnvironment + "\n\n" + deploymentInfo.getSummary() + " " + deploymentInfo.getURL();
                    }
                    catch (Exception deploymentInfo) {
                        // empty catch block
                    }
                    try {
                        String filemakerVersion = this.getContext().evaluateExpression("Get(ApplicationVersion)").getStringData(this.getContext());
                        systemEnvironment = systemEnvironment + "\nFileMaker version:" + filemakerVersion;
                        log.info("Successfully retrieved fileMaker version during configure: " + filemakerVersion);
                    }
                    catch (FmCalculationException e) {
                        if (e.getErrorCode() == 100) {
                            log.warning("Couldn't get FileMaker version because there is no file open.");
                        }
                        log.warning("Couldn't get FileMaker version: " + e.toString());
                    }
                    this.sendData(writer, "systemEnvironment", systemEnvironment, false);
                }
                if (licenseInfo != null) {
                    if (orderId > 0) {
                        this.sendData(writer, "orderId", "" + orderId, false);
                    }
                    this.sendData(writer, "licenseInfo", licenseInfo, false);
                }
                if (!includeLog || !this.getPluginBridge().getLogFile().exists()) break block18;
                writer.write("&log=");
                char[] buff = new char[8192];
                try (FileReader logReader = new FileReader(this.getPluginBridge().getLogFile());){
                    int charsRead;
                    while ((charsRead = logReader.read(buff)) != -1) {
                        String logChunk = new String(buff, 0, charsRead);
                        writer.write(URLEncoder.encode(logChunk, "utf-8"));
                    }
                }
            }
        }
        if (urlConnection.getResponseCode() < 200 || urlConnection.getResponseCode() >= 300) {
            InputStream err = urlConnection.getErrorStream();
            try {
                byte[] errBytes = new byte[err.available()];
                int count = err.read(errBytes);
                String errString = new String(errBytes, 0, count);
                throw new IllegalStateException(errString);
            }
            catch (Throwable throwable) {
                err.close();
                throw throwable;
            }
        }
    }

    private void sendData(Writer writer, String key, String value, boolean isFirst) throws IOException {
        if (!isFirst) {
            writer.write("&");
        }
        writer.write(URLEncoder.encode(key, "utf-8") + "=" + URLEncoder.encode(value, "utf-8"));
    }

    protected FMText failureValue() {
        return new FMText(this.getContext(), "ERROR");
    }

    protected void setApplicationType(Short type) {
        this.applicationType = type;
    }

    protected Short getApplicationType() {
        return this.applicationType;
    }

    String getOptionString() {
        StringBuilder buffer = new StringBuilder(11);
        buffer.append(this.getShortId().toString());
        buffer.append("1");
        buffer.append(this instanceof Configurable ? "Y" : "n");
        buffer.append("n");
        buffer.append("Y");
        buffer.append(this instanceof IdleHandler ? "Y" : "n");
        buffer.append("Y");
        buffer.append("n");
        String result = buffer.toString();
        assert (result.length() == 11);
        return result;
    }

    public void setPluginBridge(PluginBridge2 bridge) {
        this.pluginBridge = bridge;
    }

    public boolean isErrorCapture() {
        return this.errorCapture;
    }

    public boolean isWindowManagementEnabled() {
        return this.windowManagementEnabled;
    }

    public void pushContext(PluginContext pluginContext) {
        if (this.currentContextStack.size() > 0) {
            ArrayList<PluginFunction> previousCalls = new ArrayList<PluginFunction>(this.currentContextStack.size());
            for (PluginContext context : this.currentContextStack) {
                previousCalls.add(context.getWhichFunction());
            }
            log.log(Level.WARNING, "pushContext called with function (" + pluginContext.getWhichFunction() + ") when stack size is " + this.currentContextStack.size() + "; this either means it was called re-entrantly, an idle handler was called without waiting for a return from a previous call, or pop was not called from last invocation. Current thread: " + Thread.currentThread().getName() + StringUtils.CR + "Previous calls: " + previousCalls);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Here is the first operation on the context stack", this.lastOperationStackTrace);
            }
        } else if (log.isLoggable(Level.FINE)) {
            this.lastOperationStackTrace = new RuntimeException("First item on context queue is plugin function: " + pluginContext.getWhichFunction());
        }
        this.currentContextStack.push(pluginContext);
    }

    public void popContext() {
        try {
            PluginContext context = this.currentContextStack.pop();
            if (context.getWhichFunction() != null) {
                log.fine("Popped context for function " + context.getWhichFunction());
            }
            LinkedList<FileMakerOperation> queueCopy = new LinkedList<FileMakerOperation>(this.operationQueue);
            this.operationQueue.clear();
            for (FileMakerOperation operation : queueCopy) {
                try {
                    operation.run(context);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Unexpected error while calling queued FileMakerOperation", e);
                }
            }
        }
        catch (EmptyStackException e) {
            log.log(Level.WARNING, "popContext was called with an empty currentContextStack. Current thread: " + Thread.currentThread().getName(), e);
        }
    }

    public void initFrame() {
        if (!this.windowManagementEnabled) {
            return;
        }
        log.info("Initiating Frame for platform: " + Platform.current.toString());
        if (Platform.isWin()) {
            long windowHandle = this.getContext().getWindowHandle();
            if (this.frame != null) {
                this.frame.dispose();
                this.frame = null;
            }
            log.log(Level.INFO, "Instantiating new Parent Frame for plugin...");
            try {
                Class<?> aClass = Class.forName("sun.awt.windows.WEmbeddedFrame");
                Constructor<?> constructor = aClass.getConstructor(Long.TYPE);
                this.frame = (Frame)constructor.newInstance(windowHandle);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                String msg;
                if (e instanceof InvocationTargetException) {
                    String s = ((InvocationTargetException)e).getTargetException().getMessage();
                    msg = "Could not load WEmbeddedFrame: " + s;
                } else {
                    msg = "Could not load WEmbeddedFrame: " + e.getMessage();
                }
                throw new RuntimeException(msg, e);
            }
            log.log(Level.INFO, "Creating new Dialog For Focus...");
            this.dialogForFocus = new JDialog(this.frame);
            this.dialogForFocus.setUndecorated(true);
            this.dialogForFocus.setOpacity(0.0f);
            this.dialogForFocus.setBounds(0, 0, 50, 50);
            this.dialogForFocus.setAutoRequestFocus(true);
            this.dialogForFocus.setFocusableWindowState(true);
            this.dialogForFocus.setModalityType(Dialog.ModalityType.MODELESS);
            this.dialogForFocus.setVisible(true);
            log.log(Level.INFO, "Disabling FM Windows...");
            this.getContext().disableFmWindows();
        } else {
            this.frame = new JFrame();
            this.dialogForFocus = new JDialog(this.frame);
            this.dialogForFocus.setUndecorated(true);
            this.dialogForFocus.setOpacity(0.0f);
            this.dialogForFocus.setBounds(0, 0, 50, 50);
            this.dialogForFocus.setAutoRequestFocus(true);
            this.dialogForFocus.setFocusableWindowState(true);
            this.dialogForFocus.setModalityType(Dialog.ModalityType.MODELESS);
            this.dialogForFocus.setVisible(true);
            this.getContext().disableFmWindows();
            this.getContext().enableFmWindows();
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void disposeFrame() {
        if (this.frame == null || !this.windowManagementEnabled) {
            return;
        }
        if (this.dialogForFocus != null) {
            if (Platform.isWin()) {
                this.getContext().enableFmWindows();
            }
            this.dialogForFocus.dispose();
            this.dialogForFocus = null;
        }
        this.frame.dispose();
        this.frame = null;
    }

    public String toString() {
        return "Plugin " + this.getName() + " / id " + System.identityHashCode(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/fmkit/Plugin", "getPluginBridge"));
    }
}

