/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class JackInputStream
extends DataInputStream {
    public static final Logger log = Logger.getLogger(JackInputStream.class.getName());

    public JackInputStream(InputStream in) {
        super(in);
    }

    public String readUTF16String() throws IOException {
        return new String(this.readByteArray(), "UTF-16LE");
    }

    public byte[] readByteArray() throws IOException {
        int chunkSize;
        int bytesLength = this.readInt();
        log.fine("About to read " + bytesLength + " bytes");
        byte[] buffer = new byte[bytesLength];
        for (int totalBytesRead = 0; totalBytesRead != bytesLength; totalBytesRead += chunkSize) {
            chunkSize = this.read(buffer, totalBytesRead, buffer.length - totalBytesRead);
            if (chunkSize != -1) continue;
            throw new EOFException("Expected to read " + bytesLength + " bytes, but only received " + totalBytesRead);
        }
        return buffer;
    }
}

