/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.emailplugin.CountOutputStream;
import com.prosc.io.IOUtils;
import com.prosc.io.InterruptibleOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public class PluginMessage {
    private static final Logger log = Logger.getLogger(PluginMessage.class.getName());
    private MyMimeMessage mimeMessage;
    private MyMimeMessage completeMessage;
    private MimeBodyPart plainTextPart;
    private String plainTextOriginal;
    private String htmlTextOriginal;
    private MimeBodyPart htmlPart;
    private MimeBodyPart unknownPart;
    private List<DataSource> attachments = new LinkedList<DataSource>();
    private List<MimeBodyPart> inlineAttachments = new LinkedList<MimeBodyPart>();
    private String characterSet = "UTF-8";
    private String htmlOverride;
    private String plaintextOverride;
    private boolean didSend = false;
    private String accessKey;
    private String secretKey;
    private String sender;

    public PluginMessage(Session session, String xMailerHeader) {
        this.checkSession(session);
        try {
            this.mimeMessage.setHeader("X-Mailer", xMailerHeader);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public PluginMessage(Session session) {
        this.checkSession(session);
    }

    private void checkSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null.");
        }
        this.mimeMessage = new MyMimeMessage(session);
    }

    public String getPlainTextOriginal() {
        return this.plainTextOriginal;
    }

    public String getfirstattachment() {
        return this.attachments.get(0).getName();
    }

    public String getfirstinlineattachment() throws MessagingException {
        return this.inlineAttachments.get(0).getFileName();
    }

    public void setSenderEmailAddress(String sender) {
        this.sender = sender;
    }

    public String getSenderEmailAddress() {
        return this.sender;
    }

    public String getHtmlTextOriginal() {
        return this.htmlTextOriginal;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean credentialsCheck() {
        return !this.accessKey.isEmpty() && !this.secretKey.isEmpty();
    }

    public void setPlainText(String plainText) throws MessagingException {
        this.completeMessage = null;
        if (plainText == null) {
            this.plainTextPart = null;
        } else {
            if (this.plainTextPart == null) {
                this.plainTextPart = new MimeBodyPart();
            }
            this.plainTextPart.setText(plainText, this.characterSet);
            this.plaintextOverride = plainText;
            if (this.plainTextOriginal == null) {
                this.plainTextOriginal = plainText;
            }
        }
    }

    public String getPlainText() {
        return this.plaintextOverride != null ? this.plaintextOverride : this.plainTextOriginal;
    }

    public void setUnknownText(String unknownText, String contentType) throws MessagingException {
        this.unknownPart = new MimeBodyPart();
        this.unknownPart.setText(unknownText, this.characterSet, contentType);
        this.completeMessage = null;
    }

    public void setHtmlText(String htmlText) throws MessagingException {
        this.completeMessage = null;
        if (htmlText == null) {
            this.htmlPart = null;
        } else {
            if (this.htmlPart != null) {
                // empty if block
            }
            this.htmlPart = new MimeBodyPart();
            this.completeMessage = null;
            this.htmlOverride = htmlText;
            this.htmlPart.setText(htmlText, this.characterSet, "html");
            if (this.htmlTextOriginal == null) {
                this.htmlTextOriginal = htmlText;
            } else {
                log.log(Level.INFO, "Updated html text, new content type " + this.htmlPart.getContentType());
            }
        }
    }

    public String getHtmlText() {
        return this.htmlOverride != null ? this.htmlOverride : this.htmlTextOriginal;
    }

    public void addAttachment(DataSource attachment) {
        this.attachments.add(attachment);
        this.completeMessage = null;
    }

    public void addAmazonInlineAttachment(String contentID, DataHandler attachment) throws MessagingException {
        MimeBodyPart amazonInline = new MimeBodyPart();
        amazonInline.setDataHandler(attachment);
        amazonInline.setHeader("Content-ID", contentID);
        String attachmentName = attachment.getDataSource().getName();
        String attachmentContentType = attachmentName.endsWith(".png") ? "image/png" : (attachmentName.endsWith(".jpg") || attachmentName.endsWith(".jpeg") ? "image/jpeg" : new MimetypesFileTypeMap().getContentType(attachmentName));
        amazonInline.setHeader("Content-type", attachmentContentType);
        amazonInline.setHeader("Content-Disposition", "inline");
        this.inlineAttachments.add(amazonInline);
    }

    public void addInlineAttachment(String contentId, DataHandler attachment) throws MessagingException {
        MimeBodyPart inline = new MimeBodyPart();
        inline.setContentID("<" + contentId + ">");
        inline.setDataHandler(attachment);
        inline.setFileName(attachment.getName());
        this.inlineAttachments.add(inline);
        this.completeMessage = null;
    }

    public void setFrom(InternetAddress from) throws MessagingException {
        this.encodePersonalName(from);
        this.sender = from.toString();
        this.mimeMessage.setFrom(from);
    }

    private void encodePersonalName(InternetAddress address) {
        if (address.getPersonal() != null) {
            try {
                address.setPersonal(address.getPersonal(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.log(Level.WARNING, "Unable to encode personal name '" + address.getPersonal() + "'");
            }
        }
    }

    public void setSubject(String subject) throws MessagingException {
        this.mimeMessage.setSubject(subject, "UTF-8");
    }

    public String getSubject() throws MessagingException {
        return this.mimeMessage.getSubject();
    }

    public void setBody(String body) throws MessagingException {
        if (body == null) {
            this.setHtmlText(null);
            this.setPlainText(null);
        } else if (body.length() > 10 && body.substring(0, 9).trim().toLowerCase().startsWith("<html")) {
            this.setHtmlText(body);
        } else {
            this.setPlainText(body);
        }
    }

    public MyMimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public Address[] getAllRecipients() throws MessagingException {
        return this.mimeMessage.getAllRecipients();
    }

    public void setRecipients(Message.RecipientType type, String to1) throws MessagingException {
        Address[] addrArray = InternetAddress.parse(to1, false);
        for (int i = 0; i < addrArray.length; ++i) {
            InternetAddress eachAddr = addrArray[i];
            this.encodePersonalName(eachAddr);
        }
        this.mimeMessage.setRecipients(type, addrArray);
    }

    public void addFroms(String froms) throws MessagingException {
        Address[] addrArray = InternetAddress.parse(froms, false);
        for (int i = 0; i < addrArray.length; ++i) {
            InternetAddress eachAddr = addrArray[i];
            this.encodePersonalName(eachAddr);
        }
        this.mimeMessage.addFrom(addrArray);
    }

    public void addRecipients(Message.RecipientType type, String recipientList) throws MessagingException {
        Address[] addrArray = InternetAddress.parse(recipientList, false);
        for (int i = 0; i < addrArray.length; ++i) {
            InternetAddress eachAddr = addrArray[i];
            this.encodePersonalName(eachAddr);
        }
        this.mimeMessage.addRecipients(type, addrArray);
    }

    public void clearRecipients() throws MessagingException {
        Address[] emptyRecipientList = new InternetAddress[]{};
        MyMimeMessage message = this.mimeMessage;
        message.setRecipients(MimeMessage.RecipientType.TO, emptyRecipientList);
        message.setRecipients(MimeMessage.RecipientType.CC, emptyRecipientList);
        message.setRecipients(MimeMessage.RecipientType.BCC, emptyRecipientList);
    }

    public String[] getHeaders(String name) {
        try {
            return this.mimeMessage.getHeader(name);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.mimeMessage.setHeader(name, value);
    }

    public MyMimeMessage buildMimeMessage() throws MessagingException, IOException {
        if (this.completeMessage != null) {
            return this.completeMessage;
        }
        int bodyCount = 0;
        if (this.plainTextPart != null) {
            ++bodyCount;
        }
        if (this.htmlPart != null) {
            ++bodyCount;
        }
        if (this.unknownPart != null) {
            ++bodyCount;
        }
        if (bodyCount == 0 && this.attachments.isEmpty() && this.inlineAttachments.isEmpty()) {
            this.mimeMessage.setText("");
        } else if (this.attachments.isEmpty() && this.inlineAttachments.isEmpty() && bodyCount == 1) {
            if (this.plainTextPart != null) {
                this.mimeMessage.setText(this.getPlainText(), this.characterSet);
            } else if (this.htmlPart != null) {
                this.mimeMessage.setText(this.getHtmlText(), this.characterSet, "html");
            } else {
                this.mimeMessage.setContent(this.unknownPart.getContent(), this.unknownPart.getContentType());
            }
        } else if (this.inlineAttachments.isEmpty()) {
            MimeBodyPart part;
            MimeMultipart multipart = new MimeMultipart(bodyCount == 1 ? "mixed" : "alternative");
            this.mimeMessage.setContent(multipart);
            if (this.plainTextPart != null) {
                multipart.addBodyPart(this.plainTextPart);
            }
            if (!(this.htmlPart == null && this.unknownPart == null || this.attachments.isEmpty())) {
                MimeMultipart tmpMulti = new MimeMultipart();
                part = new MimeBodyPart();
                part.setContent(tmpMulti);
                multipart.addBodyPart(part);
                multipart = tmpMulti;
            }
            if (this.htmlPart != null) {
                multipart.addBodyPart(this.htmlPart);
            }
            if (this.unknownPart != null) {
                multipart.addBodyPart(this.unknownPart);
            }
            if (multipart.getCount() == 0) {
                MimeBodyPart blankBody = new MimeBodyPart();
                blankBody.setText(" ");
                multipart.addBodyPart(blankBody);
            }
            for (DataSource eachDataSource : this.attachments) {
                part = new MimeBodyPart();
                part.setDataHandler(new DataHandler(eachDataSource));
                part.setFileName(eachDataSource.getName());
                if (eachDataSource.getName().endsWith(".tab") || eachDataSource.getName().endsWith(".txt") || eachDataSource.getName().endsWith(".csv")) {
                    part.setHeader("Content-Transfer-Encoding", "quoted-printable");
                }
                multipart.addBodyPart(part);
            }
        } else {
            MimeMultipart attachmentAndContent = new MimeMultipart("mixed");
            MimeMultipart textAndInlineAttachments = new MimeMultipart("related");
            MimeMultipart textParts = new MimeMultipart("alternative");
            if (this.plainTextPart != null) {
                textParts.addBodyPart(this.plainTextPart);
            }
            if (this.htmlPart != null) {
                textParts.addBodyPart(this.htmlPart);
            }
            if (textParts.getCount() == 0) {
                MimeBodyPart blankBody = new MimeBodyPart();
                blankBody.setText(" ");
                textParts.addBodyPart(blankBody);
            }
            MimeBodyPart mbpBody = new MimeBodyPart();
            mbpBody.setContent(textParts);
            textAndInlineAttachments.addBodyPart(mbpBody);
            MimeBodyPart textAndInlinBodyPart = new MimeBodyPart();
            textAndInlinBodyPart.setContent(textAndInlineAttachments);
            attachmentAndContent.addBodyPart(textAndInlinBodyPart);
            for (MimeBodyPart eachResourcePart : this.inlineAttachments) {
                textAndInlineAttachments.addBodyPart(eachResourcePart);
            }
            for (DataSource eachDataSource : this.attachments) {
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(new DataHandler(eachDataSource));
                part.setFileName(eachDataSource.getName());
                attachmentAndContent.addBodyPart(part);
            }
            this.mimeMessage.setContent(attachmentAndContent);
        }
        this.completeMessage = this.mimeMessage;
        return this.mimeMessage;
    }

    public void removeHeader(String header) throws MessagingException {
        this.mimeMessage.removeHeader(header);
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public void setBodyFile(URL url, boolean embedResources) throws IOException, MessagingException {
        String pathLower = url.getPath().toLowerCase();
        if (pathLower.endsWith(".mhtml") || pathLower.endsWith(".mht")) {
            this.setBodyFileMHTML(url);
        } else {
            this.setBodyFileHTML(url, embedResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBodyFileMHTML(URL url) throws IOException, MessagingException {
        try (InputStream asStream = url.openStream();){
            MimeMessage tmpMessage = new MimeMessage(Session.getDefaultInstance(System.getProperties()), asStream);
            MimeMultipart tmpContent = (MimeMultipart)tmpMessage.getContent();
            BodyPart mainBodyPart = tmpContent.getBodyPart(0);
            String html = (String)mainBodyPart.getContent();
            html = html.replaceAll("^[^<]*", "");
            PluginMessage message = this;
            for (int i = 1; i < tmpContent.getCount(); ++i) {
                BodyPart part = tmpContent.getBodyPart(i);
                String[] contentLocationHeader = part.getHeader("Content-Location");
                if (contentLocationHeader == null || contentLocationHeader.length == 0) continue;
                MimePartDataSource ds = new MimePartDataSource((MimePart)((Object)part));
                DataHandler dh = new DataHandler(ds);
                String contentId = String.valueOf(System.currentTimeMillis()) + "." + Math.random();
                message.addInlineAttachment(contentId, dh);
                html = html.replaceAll(contentLocationHeader[0], "cid:" + contentId);
            }
            message.setHtmlText(html);
        }
    }

    private void setBodyFileHTML(URL url, boolean embedResources) throws IOException, MessagingException {
        String finalHtml;
        String html = IOUtils.getUrlContents(url.toString());
        if (embedResources) {
            Matcher matcher = Pattern.compile("(<[^>]+src=\"|<[^>]+href=\")([^\"]+)(\")", 10).matcher(html);
            StringBuffer sb = new StringBuffer((int)((double)html.length() * 1.1));
            LinkedList<MimeBodyPart> resources = new LinkedList<MimeBodyPart>();
            while (matcher.find()) {
                String location = matcher.group(2);
                URL absoluteResourceUrl = new URL(url, location);
                boolean didEmbed = false;
                if (embedResources && this.isEmbeddable(matcher.group())) {
                    try {
                        log.log(Level.INFO, "Fetching HTML page resource " + location + " from tag " + matcher.group());
                        String contentId = "resource" + (resources.size() + 1);
                        MimeBodyPart resourcePart = new MimeBodyPart();
                        resourcePart.setContentID("<" + contentId + ">");
                        resourcePart.setDisposition("inline");
                        resourcePart.setDataHandler(new DataHandler(absoluteResourceUrl));
                        resources.add(resourcePart);
                        matcher.appendReplacement(sb, "$1cid:" + contentId + "$3");
                        didEmbed = true;
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, "Could not get content for message resource " + matcher.group());
                    }
                }
                if (didEmbed) continue;
                matcher.appendReplacement(sb, "$1" + absoluteResourceUrl + "$3");
            }
            matcher.appendTail(sb);
            finalHtml = sb.toString();
            this.inlineAttachments = resources;
        } else {
            finalHtml = html;
        }
        this.htmlTextOriginal = null;
        this.setHtmlText(finalHtml);
    }

    private boolean isEmbeddable(String s) {
        if (s.startsWith("<img ")) {
            return true;
        }
        return s.startsWith("<link ") && s.indexOf("\"stylesheet\"") > 0;
    }

    public void bodySubstitute(String searchString, String replaceString) throws MessagingException {
        String templateToUse;
        Pattern p = Pattern.compile("\\Q" + searchString + "\\E", 2);
        replaceString = replaceString.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
        if (this.didSend) {
            this.htmlOverride = null;
            this.plaintextOverride = null;
            this.didSend = false;
        }
        if (this.htmlTextOriginal != null) {
            log.log(Level.INFO, "Replacing '" + searchString + "' with '" + replaceString + "' in HTML part");
            templateToUse = this.htmlOverride == null ? this.htmlTextOriginal : this.htmlOverride;
            this.setHtmlText(p.matcher(templateToUse).replaceAll(replaceString));
        }
        if (this.plainTextOriginal != null) {
            log.log(Level.INFO, "Replacing '" + searchString + "' with '" + replaceString + "' in plaintext part");
            templateToUse = this.plaintextOverride == null ? this.plainTextOriginal : this.plaintextOverride;
            this.setPlainText(p.matcher(templateToUse).replaceAll(replaceString));
        }
    }

    public void setDidSend(boolean yn) {
        this.didSend = yn;
    }

    public int calculateMessageSize() throws MessagingException, IOException {
        CountOutputStream outputStream = new CountOutputStream();
        MyMimeMessage message = this.buildMimeMessage();
        try {
            message.writeTo(outputStream);
        }
        finally {
            message.resetBytesSent();
        }
        return outputStream.getLength();
    }

    public int getBytesSent() throws MessagingException, IOException {
        MyMimeMessage message = this.buildMimeMessage();
        return message.getBytesSent();
    }

    public Callable<Integer> getProgressMonitor() throws MessagingException, IOException {
        return this.buildMimeMessage().getProgressMonitor();
    }

    public String getRawMessageContent() throws IOException, MessagingException {
        MyMimeMessage myMimeMessage = this.buildMimeMessage();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        myMimeMessage.writeTo(baos);
        return new String(baos.toByteArray(), "US-ASCII");
    }

    public void setRawMessageContent(Session session, String raw) throws UnsupportedEncodingException, MessagingException {
        this.completeMessage = this.mimeMessage = new MyMimeMessage(session, new ByteArrayInputStream(raw.getBytes("UTF-8")));
        this.sender = this.mimeMessage.getFrom().length == 0 ? null : this.mimeMessage.getFrom()[0].toString();
    }

    public class MyMimeMessage
    extends MimeMessage {
        private String messageIdOverride;
        private InterruptibleOutputStream outputStreamSendWrapper;

        public MyMimeMessage(Session session) {
            super(session);
        }

        public MyMimeMessage(Session session, InputStream raw) throws MessagingException {
            super(session, raw);
        }

        public int getBytesSent() {
            InterruptibleOutputStream interruptibleOutputStream = this.outputStreamSendWrapper;
            return interruptibleOutputStream == null ? 0 : interruptibleOutputStream.getBytesTransferred();
        }

        public void resetBytesSent() {
            this.outputStreamSendWrapper = null;
        }

        @Override
        public void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
            this.outputStreamSendWrapper = new InterruptibleOutputStream(os);
            super.writeTo(this.outputStreamSendWrapper, ignoreList);
        }

        public Callable<Integer> getProgressMonitor() {
            return new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return MyMimeMessage.this.outputStreamSendWrapper == null ? 0 : MyMimeMessage.this.outputStreamSendWrapper.getBytesTransferred();
                }
            };
        }

        @Override
        protected void updateMessageID() throws MessagingException {
            if (this.messageIdOverride != null) {
                this.setHeader("Message-ID", this.messageIdOverride);
            } else {
                super.updateMessageID();
            }
        }

        @Override
        public void setHeader(String name, String value) throws MessagingException {
            super.setHeader(name, value);
            if ("message-id".equalsIgnoreCase(name) && value != null && value.length() != 0) {
                this.messageIdOverride = value;
            }
        }
    }
}

