/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.emailplugin.AttachmentInfo;
import com.prosc.fmkit.PluginUtils;
import com.prosc.io.IOUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

public class PartExtractor {
    private static final Logger log = Logger.getLogger(PartExtractor.class.getName());
    private File downloadDir;
    private String plainText;
    private int attachmentCount;
    private boolean altDecoding;
    private String richText;
    private String html;
    private List<AttachmentInfo> attachmentInfos = new LinkedList<AttachmentInfo>();
    private boolean concatenateMultiplePlaintextParts = true;
    private boolean concatenateMultipleHtmlParts = true;

    public PartExtractor(File downloadDir) {
        this.downloadDir = downloadDir;
        if (downloadDir != null) {
            if (!downloadDir.exists() && !downloadDir.mkdirs()) {
                throw new RuntimeException("Could not create temporary directory to download attachments to.  Please ensure that the directory is writeable: " + downloadDir);
            }
            downloadDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isFile()) {
                        log.log(Level.INFO, "Deleting old file " + pathname);
                        pathname.delete();
                    }
                    return false;
                }
            });
        }
    }

    public void extract(MimePart part, Properties p) throws InterruptedException, MessagingException, IOException {
        this.altDecoding = PluginUtils.booleanForString(p.getProperty("alternateDecoding"), false);
        if (this.altDecoding) {
            log.log(Level.INFO, "Successfully set flag to use alternate decoding process");
        }
        this.extract(part);
    }

    public void extract(MimePart part) throws MessagingException, IOException, InterruptedException {
        Object content;
        String contentType = null;
        try {
            contentType = part.getContentType();
        }
        catch (MessagingException e) {
            if (e.getMessage() != null && e.getMessage().toLowerCase().contains("unable to load bodystructure")) {
                log.log(Level.WARNING, "Error while loading message.  Will attempt to reconstruct message locally.  This could cause issues when trying to set flags or move this message on the server.  Error message: " + e.getMessage(), e);
                MimeMessage msgDownloaded = new MimeMessage((MimeMessage)part);
                this.extract(msgDownloaded);
                return;
            }
            throw e;
        }
        String contentDisposition = this.firstHeader(part.getHeader("content-disposition"));
        if (contentType != null) {
            contentType = contentType.toLowerCase(Locale.US);
        }
        int size = part.getSize();
        try {
            content = part.getContent();
        }
        catch (OutOfMemoryError e) {
            log.log(Level.SEVERE, "Ran out of memory trying to get content of type " + contentType + " and size " + size + " for message ");
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            if (contentType != null && contentType.toLowerCase().startsWith("text/plain")) {
                log.log(Level.WARNING, "Caught UnsupportedEncodingException while trying to read part contents.  This can happen with text/plain messages.  Will attempt to read in as text/plain.", e);
                content = null;
            }
            throw e;
        }
        if (content == null || content instanceof String && "".equals(content)) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            part.writeTo(stream);
            content = this.readContentFromStream(new ByteArrayInputStream(stream.toByteArray()), part.getEncoding(), contentType);
        }
        if (content instanceof String) {
            if (contentDisposition != null && contentDisposition.toLowerCase().indexOf("attachment") != -1) {
                this.handleAttachment(part, content, contentType);
            } else if (contentType != null && contentType.toLowerCase().startsWith("text/plain")) {
                if (this.plainText == null) {
                    this.plainText = (String)content;
                } else if (this.concatenateMultiplePlaintextParts) {
                    this.plainText = this.plainText + "\n\n" + content;
                } else {
                    this.handleAttachment(part, content, contentType);
                }
            } else {
                this.richText = (String)content;
                if (contentType != null && contentType.indexOf("html") != -1) {
                    this.html = this.html == null ? this.richText : (this.concatenateMultipleHtmlParts ? this.html + this.richText : this.richText);
                }
            }
        } else if (content instanceof MimeMultipart) {
            MimeMultipart mmp = (MimeMultipart)content;
            for (int i = 0; i < mmp.getCount(); ++i) {
                BodyPart eachPart = mmp.getBodyPart(i);
                try {
                    this.extract((MimePart)((Object)eachPart));
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Could not extract message part for " + eachPart + ": " + e.toString(), e);
                }
            }
        } else if (content instanceof MimeBodyPart) {
            this.extract(part);
        } else if (content instanceof InputStream) {
            this.handleAttachment(part, content, contentType);
        } else if (contentDisposition != null && contentDisposition.toLowerCase().indexOf("attachment") != -1) {
            this.handleAttachment(part, content, contentType);
        } else if (content instanceof MimeMessage) {
            part.setFileName("encapsulated_message.eml");
            this.handleAttachment(part, content, contentType);
        } else {
            log.log(Level.WARNING, "Unknown content type: " + content + " (" + content.getClass().getName() + ")");
        }
    }

    private String readContentFromStream(InputStream in, String encoding, String contentType) throws IOException {
        String line;
        BufferedReader reader = null;
        if (encoding == null) {
            reader = new BufferedReader(new InputStreamReader(in));
        } else {
            try {
                reader = new BufferedReader(new InputStreamReader(in, encoding));
            }
            catch (UnsupportedEncodingException e) {
                log.log(Level.INFO, e.toString() + ", falling back to default encoding for mime type " + contentType);
                reader = new BufferedReader(new InputStreamReader(in));
            }
        }
        boolean restIsContent = false;
        StringBuilder content = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if ("".equals(line)) {
                restIsContent = true;
                continue;
            }
            if (!restIsContent) continue;
            if (this.altDecoding) {
                if (encoding.equalsIgnoreCase("quoted-printable")) {
                    if (line.endsWith("=")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    if (line.contains("=3D")) {
                        line = line.replace("=3D", "=");
                    }
                }
                if (encoding.equalsIgnoreCase("base64")) {
                    try {
                        line = new String(Base64.getMimeDecoder().decode(line));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        line = new String(Base64.getMimeDecoder().decode(line), 0, line.length() * 2);
                        line = line.trim();
                    }
                    content.append(line);
                    continue;
                }
                content.append(line);
                continue;
            }
            content.append(line);
        }
        return content.toString();
    }

    private String firstHeader(String[] header) {
        return header == null || header.length == 0 ? null : header[0];
    }

    private void handleAttachment(MimePart part, Object content, String contentType) throws MessagingException, InterruptedException, IOException {
        if (contentType != null && contentType.toLowerCase().indexOf("applefile") != -1) {
            return;
        }
        String fileName = part.getFileName();
        if (fileName == null || fileName.length() == 0) {
            part.getAllHeaderLines();
            Enumeration<String> enumeration = part.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                int index;
                String eachHeaderLine = enumeration.nextElement();
                if (eachHeaderLine == null || !eachHeaderLine.toLowerCase().startsWith("content-type") || (index = eachHeaderLine.indexOf("name=")) == -1) continue;
                fileName = MimeUtility.decodeText(eachHeaderLine.substring(index + "name=".length()));
                break;
            }
            if (fileName == null || fileName.length() == 0) {
                String suffix = "unknown";
                fileName = "attachment" + ++this.attachmentCount + "." + suffix;
            }
        }
        if (fileName.startsWith("=?")) {
            try {
                fileName = MimeUtility.decodeText(fileName);
            }
            catch (UnsupportedEncodingException e) {
                log.log(Level.WARNING, "Unable to decode text for " + fileName, e);
            }
        }
        fileName = PartExtractor.cleanupFilename(fileName);
        if (this.isCancelled()) {
            throw new InterruptedException("Cancelled");
        }
        if (this.downloadAttachmentsEnabled()) {
            File f = new File(this.downloadDir, fileName);
            f = IOUtils.ensureUniqueFilename(f, true);
            f.deleteOnExit();
            log.log(Level.INFO, "Downloading attachment to " + f);
            FileOutputStream out = new FileOutputStream(f);
            if (content instanceof InputStream) {
                IOUtils.writeInputToOutput((InputStream)content, (OutputStream)out, 1024);
            } else if (content instanceof String) {
                out.write(String.valueOf(content).getBytes("UTF-8"));
            } else if (content instanceof MimeMessage) {
                ((MimeMessage)content).writeTo(out);
            }
            IOUtils.closeQuietly(out);
            String fmPath = PluginUtils.fmPathForFile(f);
            log.log(Level.INFO, "Attachment is available at " + fmPath);
            this.attachmentInfos.add(new AttachmentInfo(part, f, fmPath));
        } else {
            this.attachmentInfos.add(new AttachmentInfo(part, null, fileName));
        }
    }

    public List<AttachmentInfo> getAttachmentInfos() {
        return this.attachmentInfos;
    }

    protected boolean isCancelled() {
        return false;
    }

    static String cleanupFilename(String fileName) {
        return fileName == null ? null : fileName.replaceAll("[<>/\\\\:\\*\\?\\|\"]", "");
    }

    public boolean downloadAttachmentsEnabled() {
        return this.downloadDir != null;
    }

    public String getAttachmentUrls() {
        StringBuilder result = new StringBuilder();
        for (AttachmentInfo eachAtt : this.attachmentInfos) {
            if (result.length() != 0) {
                result.append("\n");
            }
            result.append(eachAtt.getFmPath());
        }
        return result.toString();
    }

    public String getAttachmentUrlsExcludingInlineDownloadedAttachments() {
        if (!this.downloadAttachmentsEnabled()) {
            return this.getAttachmentUrls();
        }
        StringBuilder result = new StringBuilder();
        for (AttachmentInfo eachAtt : this.attachmentInfos) {
            if (this.isInlineAttachment(eachAtt)) continue;
            if (result.length() != 0) {
                result.append("\n");
            }
            result.append(eachAtt.getFmPath());
        }
        return result.toString();
    }

    public boolean isInlineAttachment(AttachmentInfo eachAtt) {
        try {
            String contentID = this.stripAngledBrackets(eachAtt.getPart().getContentID());
            return this.html != null && this.html.indexOf(contentID) != -1;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to determine whether " + eachAtt + " is an inline attachment");
            return false;
        }
    }

    public String getInlineAttachments() {
        if (!this.downloadAttachmentsEnabled()) {
            return this.getAttachmentUrls();
        }
        StringBuilder result = new StringBuilder();
        for (AttachmentInfo eachAtt : this.attachmentInfos) {
            if (!this.isInlineAttachment(eachAtt)) continue;
            if (result.length() != 0) {
                result.append("/n");
            }
            result.append(eachAtt.getFmPath());
        }
        return result.toString();
    }

    private String stripAngledBrackets(String contentID) {
        if (contentID == null || contentID.length() < 3 || contentID.charAt(0) != '<') {
            return contentID;
        }
        return contentID.substring(1, contentID.length() - 1);
    }

    public String getPlainText() {
        return this.plainText;
    }

    public static void main(String[] args) throws IOException, MessagingException, InterruptedException {
        if (args.length == 0) {
            System.out.println("Usage: PartExtractor /path/to/email/data");
            System.exit(0);
        }
        String path = args[0];
        MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance(System.getProperties()), new FileInputStream(path));
        PartExtractor partExtractor = new PartExtractor(null);
        partExtractor.extract(mimeMessage);
        String attachmentUrls = partExtractor.getAttachmentUrls();
        System.out.println("Got attachments: " + attachmentUrls);
    }

    public String getHtml() {
        return this.html;
    }

    public String getAttachmentContentIds() throws MessagingException {
        StringBuilder result = new StringBuilder();
        for (AttachmentInfo eachAttInfo : this.attachmentInfos) {
            String contentID;
            if (result.length() != 0) {
                result.append("\r");
            }
            result.append((contentID = eachAttInfo.getPart().getContentID()) == null ? "" : contentID);
        }
        return result.toString();
    }

    public String toString() {
        try {
            return this.getAttachmentContentIds();
        }
        catch (MessagingException e) {
            String s = super.toString();
            log.log(Level.WARNING, "Could not get attachment content ids for " + s, e);
            return s;
        }
    }

    public AttachmentInfo getAttachmentInfoByContentId(String cid) throws MessagingException {
        String cidWithBrackets = "<" + cid + ">";
        for (AttachmentInfo eachAttInfo : this.attachmentInfos) {
            if (!eachAttInfo.getPart().getContentID().equalsIgnoreCase(cid) && !eachAttInfo.getPart().getContentID().equalsIgnoreCase(cidWithBrackets)) continue;
            return eachAttInfo;
        }
        return null;
    }

    public void clearDownloadDirectory() {
        try {
            IOUtils.deleteRecursiveJava8(this.downloadDir);
        }
        catch (IOException e) {
            log.warning("Could not delete attachment download directory at: " + this.downloadDir.getAbsolutePath() + " : Error: " + e.getMessage());
        }
    }
}

