/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.emailplugin.MsgExceptionHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

final class MsgValueGetter {
    private static final Logger log = Logger.getLogger(MsgValueGetter.class.getName());

    private MsgValueGetter() {
    }

    static Date getSentDate(MimeMessage eachMessage, MsgExceptionHandler handler) {
        try {
            return eachMessage.getSentDate();
        }
        catch (MessagingException e) {
            return (Date)handler.valueAfterException(eachMessage, e);
        }
    }

    static Address[] getReplyTo(MimeMessage eachMessage, MsgExceptionHandler handler) {
        try {
            return eachMessage.getReplyTo();
        }
        catch (MessagingException e) {
            return (Address[])handler.valueAfterException(eachMessage, e);
        }
    }

    public static Address[] getFrom(MimeMessage eachMessage, MsgExceptionHandler handler) {
        try {
            return eachMessage.getFrom();
        }
        catch (MessagingException e) {
            return (Address[])handler.valueAfterException(eachMessage, e);
        }
    }

    public static Address[] getRecipients(MimeMessage eachMessage, MsgExceptionHandler handler, Message.RecipientType type) {
        try {
            return eachMessage.getRecipients(type);
        }
        catch (MessagingException e) {
            return (Address[])handler.valueAfterException(eachMessage, e);
        }
    }

    public static String getSubject(MimeMessage eachMessage, MsgExceptionHandler handler) {
        try {
            return eachMessage.getSubject();
        }
        catch (MessagingException e) {
            return (String)handler.valueAfterException(eachMessage, e);
        }
    }

    public static Date getReceivedDate(MimeMessage eachMessage, MsgExceptionHandler handler) {
        try {
            Date date = eachMessage.getReceivedDate();
            if (date == null) {
                try {
                    String rawHeader = eachMessage.getHeader("received", null);
                    if (rawHeader != null) {
                        int index = rawHeader.indexOf(";");
                        if (index != -1) {
                            rawHeader = rawHeader.substring(index + 1).trim();
                        }
                        rawHeader = rawHeader.replace("\r", "").replace("\n", "");
                        try {
                            return new SimpleDateFormat("E, d MMM yyyy H:m:s Z (z)").parse(rawHeader);
                        }
                        catch (ParseException e) {
                            return new SimpleDateFormat("E, d MMM yyyy H:m:s Z").parse(rawHeader);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Could not parse received date from header: " + eachMessage.getHeader("received", null), e);
                }
            }
            return date;
        }
        catch (MessagingException e) {
            return (Date)handler.valueAfterException(eachMessage, e);
        }
    }

    public static String getMessageId(MimeMessage eachMessage, MsgExceptionHandler handler) {
        try {
            String messageID = eachMessage.getMessageID();
            return messageID == null ? null : messageID.trim();
        }
        catch (MessagingException e) {
            return (String)handler.valueAfterException(eachMessage, e);
        }
    }

    public static String stringForFlag(MimeMessage eachMessage, MsgExceptionHandler handler, Flags.Flag flag) {
        try {
            return eachMessage.getFlags().contains(flag) ? "1" : "";
        }
        catch (MessagingException e) {
            return (String)handler.valueAfterException(eachMessage, e);
        }
    }
}

