/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageInputStream
extends InputStream {
    static final Pattern FROM__LINE_PATTERN = Pattern.compile("(\\A|\\n{2}|(\\r\\n){2})^From .*$\\s*^", 8);
    private CharsetDecoder decoder;
    private ByteBuffer buffer;

    public MessageInputStream(ByteBuffer b) throws CharacterCodingException {
        this(b, Charset.forName(System.getProperty("mstor.mbox.encoding", "ISO-8859-1")));
    }

    public MessageInputStream(ByteBuffer b, Charset charset) throws CharacterCodingException {
        this.buffer = b;
        this.decoder = charset.newDecoder();
        Matcher matcher = FROM__LINE_PATTERN.matcher(this.decoder.decode(this.buffer));
        if (matcher.find()) {
            this.buffer.rewind();
            this.buffer.position(this.buffer.position() + matcher.end());
            this.buffer.mark();
        }
        try {
            this.buffer.reset();
        }
        catch (InvalidMarkException ime) {
            this.buffer.rewind();
        }
    }

    @Override
    public final int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get();
    }

    @Override
    public final int read(byte[] bytes, int offset, int length) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int read = Math.min(length, this.buffer.remaining());
        this.buffer.get(bytes, offset, read);
        return read;
    }
}

