/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.aws.exception.SESException;
import com.prosc.core.FeedbackException;
import com.prosc.emailplugin.EmailerModel;
import com.prosc.io.IOUtils;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class MessageFromUrl {
    private static final Logger log = Logger.getLogger(MessageFromUrl.class.getName());

    public MimeMultipart loadHtmlMessage(URL htmlUrl, boolean embedResources) throws IOException, MessagingException {
        String html = IOUtils.getUrlContents(htmlUrl.toString());
        Matcher matcher = Pattern.compile("(<[^>]+src=\"|<[^>]+href=\")([^\"]+)(\")", 10).matcher(html);
        StringBuffer sb = new StringBuffer((int)((double)html.length() * 1.1));
        LinkedList<MimeBodyPart> resources = new LinkedList<MimeBodyPart>();
        while (matcher.find()) {
            String location = matcher.group(2);
            URL absoluteResourceUrl = new URL(htmlUrl, location);
            boolean didEmbed = false;
            if (embedResources && this.isEmbeddable(matcher.group())) {
                try {
                    log.log(Level.INFO, "Fetching HTML page resource " + location + " from tag " + matcher.group());
                    String contentId = "resource" + (resources.size() + 1);
                    MimeBodyPart resourcePart = new MimeBodyPart();
                    resourcePart.setContentID("<" + contentId + ">");
                    resourcePart.setDisposition("inline");
                    resourcePart.setDataHandler(new DataHandler(absoluteResourceUrl));
                    resources.add(resourcePart);
                    matcher.appendReplacement(sb, "$1cid:" + contentId + "$3");
                    didEmbed = true;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Could not get content for message resource " + matcher.group());
                }
            }
            if (didEmbed) continue;
            matcher.appendReplacement(sb, "$1" + absoluteResourceUrl + "$3");
        }
        matcher.appendTail(sb);
        MimeMultipart multipart1 = new MimeMultipart("related");
        MimeMultipart body = new MimeMultipart("alternative");
        MimeBodyPart plainTextPart = new MimeBodyPart();
        plainTextPart.setContent("This is a multipart message", "text/plain");
        body.addBodyPart(plainTextPart);
        MimeBodyPart htmlPart = new MimeBodyPart();
        htmlPart.setContent(sb.toString(), "text/html");
        body.addBodyPart(htmlPart);
        MimeBodyPart mbpBody = new MimeBodyPart();
        mbpBody.setContent(body);
        multipart1.addBodyPart(mbpBody);
        for (MimeBodyPart eachResourcePart : resources) {
            multipart1.addBodyPart(eachResourcePart);
        }
        return multipart1;
    }

    private boolean isEmbeddable(String s) {
        if (s.startsWith("<img ")) {
            return true;
        }
        return s.startsWith("<link ") && s.indexOf("\"stylesheet\"") > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws MessagingException, FeedbackException, IOException, SESException {
        MessageFromUrl messageFromUrl = new MessageFromUrl();
        EmailerModel model = new EmailerModel();
        try {
            model.connectSMTP("mail.360works.com:27", null, null, false, null, false, true);
            MimeMultipart mimeMultipart = messageFromUrl.loadHtmlMessage(new URL("http://360works.com/products/"), false);
            model.create("ssb_test@360works.com", "ssb_recipient@360works.com", "testing loadHtmlMessage", null);
            model.send();
        }
        finally {
            model.disconnect();
        }
    }
}

