/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.emailplugin.MessageInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MBoxFile {
    private static final Logger log = Logger.getLogger(MBoxFile.class.getName());
    public static final String KEY_BUFFER_STRATEGY = "mstor.mbox.bufferStrategy";
    public static final String READ_ONLY = "r";
    public static final String READ_WRITE = "rw";
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    public static final String FROM__PREFIX = "From ";
    private static final Pattern VALID_MBOX_PATTERN = Pattern.compile("^From .*", 32);
    static final Pattern FROM__LINE_PATTERN = Pattern.compile("(\\A|\\n{2}|(\\r\\n){2})^From .*$", 8);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static Charset charset = Charset.forName(System.getProperty("mstor.mbox.encoding", "ISO-8859-1"));
    private CharsetDecoder decoder = charset.newDecoder();
    private CharsetEncoder encoder = charset.newEncoder();
    private File file;
    private String mode;
    private RandomAccessFile raf;
    private FileChannel channel;
    private long[] messagePositions;

    public MBoxFile(File file) throws FileNotFoundException {
        this(file, READ_ONLY);
    }

    public MBoxFile(File file, String mode) {
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.file = file;
        this.mode = mode;
    }

    private RandomAccessFile getRaf() throws FileNotFoundException {
        if (this.raf == null) {
            this.raf = new RandomAccessFile(this.file, this.mode);
        }
        return this.raf;
    }

    private FileChannel getChannel() throws FileNotFoundException {
        if (this.channel == null) {
            this.channel = this.getRaf().getChannel();
        }
        return this.channel;
    }

    private ByteBuffer read(long position, int size) throws IOException {
        ByteBuffer buffer = null;
        try {
            BufferStrategy bufferStrategy = BufferStrategy.DEFAULT;
            if (BufferStrategy.MAPPED.equals((Object)bufferStrategy)) {
                buffer = this.getChannel().map(FileChannel.MapMode.READ_ONLY, position, size);
            } else {
                if (BufferStrategy.DIRECT.equals((Object)bufferStrategy)) {
                    buffer = ByteBuffer.allocateDirect(size);
                } else if (BufferStrategy.DEFAULT.equals((Object)bufferStrategy)) {
                    buffer = ByteBuffer.allocate(size);
                } else {
                    throw new IllegalArgumentException("Unrecognised buffer strategy: " + System.getProperty(KEY_BUFFER_STRATEGY));
                }
                this.getChannel().position(position);
                this.getChannel().read(buffer);
                buffer.flip();
            }
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "Error reading bytes using nio", ioe);
            this.getRaf().seek(position);
            byte[] buf = new byte[size];
            this.getRaf().read(buf);
            buffer = ByteBuffer.wrap(buf);
        }
        return buffer;
    }

    private long[] getMessagePositions() throws IOException {
        if (this.messagePositions == null) {
            ArrayList<Long> posList = new ArrayList<Long>();
            log.fine("Channel size [" + this.getChannel().size() + "] bytes");
            int bufferSize = (int)Math.min(this.getChannel().size(), 8192L);
            CharBuffer cs = null;
            ByteBuffer buffer = this.read(0L, bufferSize);
            cs = this.decoder.decode(buffer);
            log.fine("Buffer [" + cs + "]");
            long offset = 0L;
            while (true) {
                Matcher matcher = FROM__LINE_PATTERN.matcher(cs);
                while (matcher.find()) {
                    log.fine("Found match at [" + (offset + (long)matcher.start()) + "]");
                    posList.add(new Long(offset + (long)matcher.start()));
                }
                if (offset + (long)bufferSize >= this.getChannel().size()) break;
                bufferSize = (int)Math.min(this.getChannel().size() - (offset += (long)(bufferSize - FROM__PREFIX.length() - 2)), 8192L);
                buffer = this.read(offset, bufferSize);
                cs = this.decoder.decode(buffer);
            }
            this.messagePositions = new long[posList.size()];
            int count = 0;
            Iterator i = posList.iterator();
            while (i.hasNext()) {
                this.messagePositions[count] = (Long)i.next();
                ++count;
            }
        }
        return this.messagePositions;
    }

    public final int getMessageCount() throws IOException {
        return this.getMessagePositions().length;
    }

    public final InputStream getMessageAsStream(int index) throws IOException {
        ByteBuffer buffer = null;
        if (buffer == null) {
            long position = this.getMessagePositions()[index];
            long size = index < this.getMessagePositions().length - 1 ? this.getMessagePositions()[index + 1] - this.getMessagePositions()[index] : this.getChannel().size() - this.getMessagePositions()[index];
            buffer = this.read(position, (int)size);
        }
        return new MessageInputStream(buffer);
    }

    public final byte[] getMessage(int index) throws IOException {
        int read;
        InputStream in = this.getMessageAsStream(index);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((read = in.read()) != -1) {
            bout.write(read);
        }
        return bout.toByteArray();
    }

    public final void close() throws IOException {
        if (this.messagePositions != null) {
            this.messagePositions = null;
        }
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
            this.channel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValid(File file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            boolean bl = line == null || VALID_MBOX_PATTERN.matcher(line).matches();
            return bl;
        }
        catch (Exception e) {
            log.log(Level.INFO, "Not a valid mbox file [" + file + "]", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    log.log(Level.INFO, "Error closing stream [" + file + "]", ioe);
                }
            }
        }
        return false;
    }

    public static enum BufferStrategy {
        DEFAULT,
        MAPPED,
        DIRECT;

    }
}

