/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.aws.Region;
import com.prosc.aws.exception.SESException;
import com.prosc.core.FeedbackException;
import com.prosc.emailplugin.AmazonOutbound;
import com.prosc.emailplugin.AttachmentInfo;
import com.prosc.emailplugin.EmailInbound;
import com.prosc.emailplugin.EmailOutbound;
import com.prosc.emailplugin.EmailUtils;
import com.prosc.emailplugin.EmailerModel;
import com.prosc.emailplugin.FileChooserOptions;
import com.prosc.emailplugin.MsgExceptionHandler;
import com.prosc.emailplugin.MsgValueGetter;
import com.prosc.emailplugin.OAuthEmailerModel;
import com.prosc.emailplugin.PartExtractor;
import com.prosc.fm.FMFileUtils;
import com.prosc.fm.FMPXMLExport2;
import com.prosc.fmkit.FMFunction;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.GuiMode;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.RegisterablePlugin;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMNumber;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMTimestamp;
import com.prosc.fmkit.types.FMType;
import com.prosc.fmkit.types.InputStreamInfo;
import com.prosc.infrastructure.Platform;
import com.prosc.io.IOUtils;
import com.prosc.io.ZipCreator;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.oauth.OAuthWorkflow;
import com.prosc.oauth.TokenStore;
import com.prosc.oauth.exchange.Office365OAuthWorkflow;
import com.prosc.oauth.google.GoogleOAuthWorkflow;
import com.prosc.shared.CaseInsensitiveMap;
import com.prosc.swing.FMProgressDialog;
import com.prosc.swing.SwingUtils;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.pop3.POP3Folder;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.UIDFolder;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.util.SharedByteArrayInputStream;
import javax.swing.Timer;
import javax.xml.transform.TransformerConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class EmailerPlugin
extends RegisterablePlugin {
    private EmailerModel model;
    private EmailInbound inbound;
    private EmailOutbound outbound;
    private OAuthWorkflow oAuthWorkflow = null;
    private static final Logger log = Logger.getLogger(EmailerPlugin.class.getName());
    private List<Object[]> inMemoryMessages;
    private Iterator inMemoryIterator;
    private Object[] inMemoryMessageData;
    private DateFormat simpleDateFormat = DateFormat.getDateTimeInstance(3, 2);
    private static final int DATA_FROM = 0;
    private static final int DATA_TO = 1;
    private static final int DATA_CC = 2;
    private static final int DATA_BCC = 3;
    private static final int DATA_REPLY_TO = 4;
    private static final int DATA_SUBJECT = 5;
    private static final int DATA_MESSAGE_NUMBER = 6;
    private static final int DATA_SENT_DATE = 7;
    private static final int DATA_RECEIVED_DATE = 8;
    private static final int DATA_CONTENT = 9;
    private static final int DATA_MESSAGE_ID = 10;
    private static final int DATA_ATTACHMENTS = 11;
    private static final int DATA_READ = 12;
    private static final int DATA_FLAGGED = 13;
    private static final int DATA_REPLIED = 14;
    private static final int DATA_DELETED = 15;
    private static final int DATA_MESSAGE = 16;
    private static final int DATA_UID = 17;
    private static final int DATA_HTML = 18;
    private static final int DATA_ATTACHMENT_CONTENT_IDS = 19;
    private volatile boolean didCancel;
    private FMProgressDialog sendDialog;

    @Override
    public QuadChar getShortId() {
        return new QuadChar("3MLR");
    }

    @Override
    public String getName() {
        return "360Works Email";
    }

    @Override
    public String getHelpText() {
        return "Send and receive email messages from FileMaker client or web publishing engine";
    }

    @Override
    public void init(boolean isFirstInstance) {
        super.init(isFirstInstance);
        this.model = new EmailerModel();
        this.inbound = this.model;
        this.outbound = this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FMType invokeFunction(PluginFunction whichFunction, Object[] parameters) throws Exception {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            FMType fMType = super.invokeFunction(whichFunction, parameters);
            return fMType;
        }
        finally {
            Thread.currentThread().setContextClassLoader(null);
        }
    }

    @FMFunction(prototype="licenseKey ; registeredTo", resultName="License Info", description="Registers the Email Plugin.", typeAheadText={"emreg"})
    public void EmailRegister(String licenseKey, String registeredTo) throws InvalidLicenseException {
        this.defaultRegister(licenseKey, registeredTo);
    }

    @FMFunction(resultName="License Information", description="Retrieve information about the Email plugin licensing and version.", typeAheadText={"emli"})
    public FMType EmailLicenseInfo() {
        return this.defaultLicenseInfo();
    }

    @FMFunction(resultName="Plugin Version", description="Returns the version number of the Email plugin.", typeAheadText={"emv"})
    public FMType EmailVersion() {
        return this.defaultVersion();
    }

    @FMFunction(showInScriptSteps=false, resultName="Last Error", typeAheadText={"emle"})
    public FMType EmailLastError() {
        return this.defaultLastError();
    }

    @Override
    protected void setLastError(Throwable t, Object[] parameters) {
        LinkedHashMap<String, String> maskedArguments = new LinkedHashMap<String, String>();
        maskedArguments.put("password", "XXXXXXXX");
        super.setLastError(t, this.maskParameters(parameters, maskedArguments));
    }

    @FMFunction(prototype="errorCapture", showInScriptSteps=false, typeAheadText={"emsec"})
    public void EmailSetErrorCapture(boolean errorCapture) {
        super.defaultSetErrorCapture(errorCapture);
    }

    @FMFunction(prototype="windowManagement", showInScriptSteps=false)
    public void EmailSetWindowManagement(boolean windowManagement) {
        super.defaultSetWindowManagement(windowManagement);
    }

    @FMFunction(prototype="from ; to ; subject { ; content }", description="Create a new email message, clearing any previous recipients and attachments.", typeAheadText={"emcr"})
    public void EmailCreate(String from, String to, String subject, String content) throws MessagingException, FeedbackException {
        this.outbound.create(from, to, subject, content);
    }

    @FMFunction(prototype="body { ; contentType ; characterSet }", description="Sets a body part of the current message.", typeAheadText={"emsb"})
    public void EmailSetBody(String body, String contentType, String characterSet) throws MessagingException, FeedbackException, IOException {
        if (contentType != null) {
            contentType = contentType.toLowerCase();
        }
        String bodyMerged = EmailUtils.bodyTextMerged(this.getContext(), this.outbound, body, contentType);
        this.outbound.setBody(bodyMerged, contentType, characterSet);
    }

    @FMFunction(prototype="url ; embedResources", description="This is used to load an HTML document as the email body part.", typeAheadText={"emsbf"})
    public void EmailSetBodyFile(String url, boolean embedResources) throws FeedbackException, MessagingException, IOException {
        URL urlObject;
        if (url == null) {
            throw new FeedbackException("url must not be empty.");
        }
        PluginUtils.checkRead(url);
        try {
            urlObject = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new FeedbackException("Invalid URL");
        }
        try {
            this.outbound.setBodyFile(urlObject, embedResources);
        }
        catch (FileNotFoundException e) {
            throw new FeedbackException("File not found: " + url);
        }
    }

    @FMFunction(prototype="to_addresses { ; append }", description="Set the TO recipients for the current message.", typeAheadText={"emrcp"})
    public void EmailRecipients(String to_addresses, boolean append) throws MessagingException, FeedbackException {
        if (to_addresses != null) {
            this.outbound.newRecipients(to_addresses, MimeMessage.RecipientType.TO, append);
        }
    }

    @FMFunction(prototype="cc_addresses { ; append }", description="Set the CC (carbon copy) recipients for the current message.", typeAheadText={"emccr"})
    public void EmailCCRecipients(String cc_addresses, boolean append) throws MessagingException, FeedbackException {
        if (cc_addresses != null) {
            this.outbound.newRecipients(cc_addresses, MimeMessage.RecipientType.CC, append);
        }
    }

    @FMFunction(prototype="bcc_addresses { ; append }", description="Set the BCC (blank carbon copy) recipients for the current message.", typeAheadText={"embccr"})
    public void EmailBCCRecipients(String bcc_addresses, boolean append) throws MessagingException, FeedbackException {
        if (bcc_addresses != null) {
            this.outbound.newRecipients(bcc_addresses, MimeMessage.RecipientType.BCC, append);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FMFunction(prototype="data", description="Attach a file at a URL to an email message, from either a URL, container, or file path.", typeAheadText={"emaf"})
    public void EmailAttachFile(FMData data) throws MessagingException, IOException, FeedbackException {
        String attachName;
        File attachFile;
        if (data == null) {
            throw new FeedbackException("data parameter may not be empty.");
        }
        InputStreamInfo info = null;
        FileOutputStream out = null;
        PushbackInputStream pushbackInputStream = null;
        File dir = PluginUtils.fileForFMPath(data.getStringData(this.getContext()));
        try {
            if (dir.isDirectory()) {
                attachFile = File.createTempFile("360Email", ".zip");
                attachFile.deleteOnExit();
                log.log(Level.INFO, "Attach was passed a directory or a bundle at '" + dir + "'. Creating temporary zip file at '" + attachFile + "'");
                ZipCreator creator = new ZipCreator();
                creator.setMaximumZipSize(0x6400000L);
                creator.createZip(dir, attachFile);
                attachName = dir.getName() + ".zip";
            } else {
                info = PluginUtils.getInputStreamInfo(data, this.getContext());
                attachName = info.getName();
                boolean isCompressed = false;
                pushbackInputStream = new PushbackInputStream(info.getStream(), 2);
                byte[] fileHeaderNumbers = new byte[2];
                pushbackInputStream.read(fileHeaderNumbers, 0, 2);
                pushbackInputStream.unread(fileHeaderNumbers);
                if (fileHeaderNumbers[0] == 31 && fileHeaderNumbers[1] == -117) {
                    isCompressed = true;
                }
                if (info.getFile() != null) {
                    attachFile = info.getFile();
                } else {
                    attachFile = File.createTempFile("360Email", info.getName());
                    attachFile.deleteOnExit();
                    out = new FileOutputStream(attachFile);
                    if (isCompressed) {
                        IOUtils.writeInputToOutput((InputStream)new GZIPInputStream(pushbackInputStream), (OutputStream)out, 4096);
                        log.log(Level.INFO, "Attach was passed a compressed container field '" + info.getName() + "'. Creating     temporary zip file at '" + attachFile + "'");
                    } else {
                        IOUtils.writeInputToOutput((InputStream)pushbackInputStream, (OutputStream)out, 4096);
                        log.log(Level.INFO, "Attach was passed a container field '" + info.getName() + "'. Creating     temporary zip file at '" + attachFile + "'");
                    }
                }
            }
        }
        finally {
            if (info != null && info.getStream() != null) {
                info.getStream().close();
            }
            if (out != null) {
                out.close();
            }
            if (pushbackInputStream != null) {
                pushbackInputStream.close();
            }
        }
        this.outbound.addAttachment(attachFile, attachName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FMFunction(prototype="data ; contentId", description="Add an inline attachment to an HTML message.", typeAheadText={"emafi"})
    public void EmailAttachFileInline(FMData data, String contentId) throws IOException, MessagingException, FeedbackException {
        if (data == null) {
            throw new FeedbackException("data parameter may not be empty");
        }
        if (contentId == null) {
            throw new FeedbackException("You must supply a contentId to EmailAttachFileInline");
        }
        InputStreamInfo inputStreamInfo = PluginUtils.getInputStreamInfo(data, this.getContext());
        try (InputStream stream = inputStreamInfo.getStream();){
            this.outbound.addAttachmentInline(stream, inputStreamInfo.getName(), contentId);
        }
    }

    @FMFunction(prototype="{ progress=true ; progressLocation=100,200 ; ... }", description="Send the current email.", gui=GuiMode.Swing, typeAheadText={"ems"}, showInScriptSteps=false)
    public void EmailSend(String[] options) throws FeedbackException, IOException, SESException {
        Properties properties = PluginUtils.convertKeyValuesToMap(options);
        PluginUtils.clearZeroLengthStrings(properties);
        boolean showProgress = PluginUtils.booleanForString(properties.getProperty("progress", "false"));
        if (Boolean.getBoolean("java.awt.headless")) {
            showProgress = false;
        }
        String progressLocationString = properties.getProperty("progressLocation");
        this.send(showProgress, FMType.PointConverter.getPoint(progressLocationString));
    }

    @FMFunction(prototype="progress ; progressLocation", description="Send the current email.", gui=GuiMode.Swing, typeAheadText={"ems"}, showInCalcs=false)
    public void EmailSend(boolean showProgress, Point progressLocation) throws FeedbackException, IOException, SESException {
        if (Boolean.getBoolean("java.awt.headless")) {
            showProgress = false;
        }
        this.send(showProgress, progressLocation);
    }

    private void send(Boolean showProgress, Point progressLocation) throws FeedbackException, IOException, SESException {
        this.outbound.checkForExistingMessage();
        if (showProgress.booleanValue()) {
            int totalMessageSize;
            Callable<Integer> progressMonitor;
            final Throwable[] exception = new Throwable[1];
            try {
                progressMonitor = this.outbound.getProgressMonitor();
            }
            catch (MessagingException e) {
                throw new FeedbackException(e);
            }
            final Thread workerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        EmailerPlugin.this.outbound.send();
                    }
                    catch (Throwable e) {
                        exception[0] = e;
                    }
                    finally {
                        if (EmailerPlugin.this.sendDialog != null) {
                            log.log(Level.FINE, "Closing sendDialog");
                            EmailerPlugin.this.sendDialog.close();
                        }
                    }
                }
            });
            this.sendDialog = new FMProgressDialog(this.getFrame(), "Sending Message"){

                @Override
                public void onCancel() {
                    workerThread.interrupt();
                }
            };
            this.sendDialog.setProgressStringPainted(true);
            Timer timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (EmailerPlugin.this.sendDialog != null) {
                            EmailerPlugin.this.sendDialog.setValue((Integer)progressMonitor.call());
                        }
                    }
                    catch (Throwable e1) {
                        throw new RuntimeException(e1);
                    }
                }
            });
            timer.setRepeats(true);
            this.sendDialog.setIndeterminate(false);
            try {
                totalMessageSize = this.outbound.getPluginMessage().calculateMessageSize();
            }
            catch (MessagingException e) {
                throw new FeedbackException(e);
            }
            this.sendDialog.setMax(totalMessageSize);
            try {
                SwingUtils.invokeAndWaitImproved(() -> {
                    try {
                        workerThread.start();
                        log.log(Level.FINER, "Starting progress dialog timer");
                        timer.start();
                        log.log(Level.FINER, "Showing FMProgressDialog");
                        if (progressLocation != null) {
                            this.sendDialog.showDialog(progressLocation);
                        } else {
                            this.sendDialog.showDialog();
                        }
                        workerThread.join();
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Could not show dialog, maybe it has been disposed", e);
                    }
                    finally {
                        timer.stop();
                    }
                    if (exception[0] != null) {
                        throw new FeedbackException(exception[0]);
                    }
                    return 1;
                });
            }
            catch (Exception e) {
                throw new FeedbackException(e);
            }
        }
        try {
            this.outbound.send();
        }
        catch (IOException | MessagingException e) {
            throw new FeedbackException(e);
        }
    }

    private Point pointForProgressLocation(String progressLocation) throws FeedbackException {
        Point progressLocationPoint = null;
        if (progressLocation != null) {
            try {
                String[] xy = progressLocation.split(",");
                progressLocationPoint = new Point(Integer.parseInt(xy[0].trim()), Integer.parseInt(xy[1].trim()));
            }
            catch (NumberFormatException e) {
                throw new FeedbackException("Invalid progressLocation: " + progressLocation, e);
            }
        }
        return progressLocationPoint;
    }

    @FMFunction(prototype="header ; value", description="Set a custom header in the message.", typeAheadText={"emsh"})
    public void EmailSetHeader(String header, String value) throws MessagingException, FeedbackException {
        this.outbound.setHeader(header, value);
    }

    @FMFunction(resultName="Outgoing Message Id", description="Returns the Message-ID of the last message sent using the Emailer plugin.", typeAheadText={"emomi"})
    public FMType EmailOutgoingMessageId() {
        if (this.outbound.getLastSentMessageId() == null) {
            FeedbackException t = new FeedbackException("You must send a message before calling EmailOutgoingMessageId");
            log.log(Level.WARNING, "Invalid state", t);
            this.setLastError(t, new Object[0]);
        }
        return new FMText(this.getContext(), this.outbound.getLastSentMessageId());
    }

    @FMFunction(prototype="host_address_deprecated { ; user_deprecated ; password_deprecated }", showInScriptSteps=false, typeAheadText={"emc"})
    public FMType EmailConnect(String host_address, String user, FMData password) throws MessagingException, FeedbackException {
        String msg = "EmailConnect is deprecated! Use EmailConnectSMTP instead";
        log.log(Level.WARNING, "EmailConnect is deprecated! Use EmailConnectSMTP instead");
        throw new FeedbackException("EmailConnect is deprecated! Use EmailConnectSMTP instead");
    }

    @FMFunction(description="Close any open connections to email servers established via the EmailConnect... functions.", typeAheadText={"emd"})
    public void EmailDisconnect() throws MessagingException {
        this.outbound.disconnect();
        this.deleteDownloadedAttachments();
        this.inMemoryMessages = null;
        this.inMemoryIterator = null;
        this.inMemoryMessageData = null;
        this.model.setExpungeOverride(null);
    }

    private void deleteDownloadedAttachments() {
        if (this.inMemoryMessages != null) {
            for (Object[] message : this.inMemoryMessages) {
                PartExtractor extractor = (PartExtractor)message[19];
                extractor.clearDownloadDirectory();
            }
        }
    }

    @FMFunction(prototype="subject", description="This allows you to customize the subject of the current outgoing email message.", typeAheadText={"emss"})
    public void EmailSetSubject(String subject) throws MessagingException, FeedbackException {
        this.outbound.setSubject(subject);
    }

    @FMFunction(prototype="from ; to ; subject ; body {; attachment }", description="Convenient way to send a single simple message to one or more recipients.", gui=GuiMode.Swing, typeAheadText={"emqs"})
    public void EmailQuickSend(String from, String to, String subject, String body, FMData attachment) throws Throwable, IOException, FeedbackException {
        this.EmailCreate(from, to, subject, null);
        this.EmailSetBody(body, body.matches("^\\s*<html.*") || body.matches("^\\s*<!DOCTYPE html>.*") ? "text/html" : null, null);
        if (attachment != null && !attachment.isEmpty(this.getContext())) {
            this.EmailAttachFile(attachment);
        }
        this.EmailSend(null);
    }

    @FMFunction(prototype="email", description="Convenience function for validating an email address.", typeAheadText={"emive"})
    public FMType IsValidEmail(String email) {
        if (email == null || email.length() == 0) {
            return null;
        }
        try {
            EmailUtils.validateEmailAddress(email);
            return new FMNumber(1);
        }
        catch (AddressException e) {
            return new FMNumber(0);
        }
    }

    @FMFunction(prototype="{ parent ; recursive }", resultName="List Of Mailboxes", description="Gets a return-separated list of mailboxes in a specific folder on the currently connected inbound mail server.", typeAheadText={"emlm"})
    public FMType EmailListMailboxes(String parent, boolean recursive) throws MessagingException, FeedbackException {
        List<String> mailboxNames = this.inbound.listMailboxes(parent, recursive);
        StringBuilder result = new StringBuilder();
        String delim = "";
        Iterator<String> iterator = mailboxNames.iterator();
        while (iterator.hasNext()) {
            String mailboxName;
            String eachName = mailboxName = iterator.next();
            result.append(delim).append(eachName);
            delim = "\r";
        }
        return new FMText(this.getContext(), result.toString());
    }

    @FMFunction(prototype="{ flag1 ; flag2 ; ... }", resultName="Message Count", description="Returns a count of messages in a particular mailbox, INBOX is used if no mailbox is specified.", typeAheadText={"emgmc"})
    public FMType EmailGetMessageCount(String ... flags) throws FeedbackException, MessagingException {
        Properties p = new Properties();
        if (flags != null && flags.length > 0) {
            p = PluginUtils.convertKeyValuesToMap(flags);
        }
        log.log(Level.INFO, "EmailGetMessageCount called with flags=" + p);
        return new FMNumber(this.model.getMessageCount(p));
    }

    @FMFunction(prototype="{ flag1 ; flag2 ; ... }", resultName="Xml File Path", description="Reads messages from the currently connected inbound mail server.", gui=GuiMode.Swing, typeAheadText={"emrm"})
    public FMType EmailReadMessages(String[] flags) throws Throwable {
        boolean saveInMemory;
        final Properties p = PluginUtils.convertKeyValuesToMap(flags);
        PluginUtils.clearZeroLengthStrings(p);
        Point progressLocationPoint = this.pointForProgressLocation(p.getProperty("progresslocation"));
        log.log(Level.INFO, "EmailReadMessages called flags=" + p);
        boolean progress = PluginUtils.booleanForString(p.getProperty("progress"), false);
        if (Boolean.getBoolean("java.awt.headless")) {
            progress = false;
        }
        this.inMemoryMessages = (saveInMemory = PluginUtils.booleanForString(p.getProperty("cache"), true)) ? new LinkedList<Object[]>() : null;
        this.inMemoryIterator = null;
        this.inMemoryMessageData = null;
        this.didCancel = false;
        if (progress) {
            Point progressLocation = null;
            final Throwable[] exception = new Throwable[1];
            final String[] result = new String[1];
            final Thread workerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String resultString;
                        File file = EmailerPlugin.this._readMessages(p);
                        result[0] = resultString = FMFileUtils.convertToFileMaker(file);
                    }
                    catch (Throwable e) {
                        exception[0] = e;
                    }
                    finally {
                        if (EmailerPlugin.this.sendDialog != null) {
                            log.log(Level.FINE, "Closing sendDialog");
                            EmailerPlugin.this.sendDialog.close();
                        }
                    }
                }
            });
            this.sendDialog = new FMProgressDialog(this.getFrame(), "Reading Messages"){

                @Override
                public void onCancel() {
                    workerThread.interrupt();
                }
            };
            this.sendDialog.setIndeterminate(true);
            try {
                SwingUtils.invokeAndWaitImproved(() -> {
                    try {
                        workerThread.start();
                        if (progressLocation != null) {
                            this.sendDialog.showDialog(progressLocation);
                        } else {
                            this.sendDialog.showDialog();
                        }
                        workerThread.join();
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Could not show dialog, maybe it has been disposed", e);
                    }
                    if (exception[0] != null) {
                        throw new FeedbackException(exception[0]);
                    }
                    return 1;
                });
            }
            catch (Exception e) {
                throw new FeedbackException(e);
            }
            return new FMText(this.getContext(), result[0]);
        }
        File file = this._readMessages(p);
        String resultString = FMFileUtils.convertToFileMaker(file);
        return new FMText(this.getContext(), resultString);
    }

    private File _readMessages(Properties p) throws MessagingException, IOException, TransformerConfigurationException, SAXException, FeedbackException, InterruptedException {
        p.put("pluginContext", this.getContext());
        try {
            DateFormat dateFormat = PluginUtils.getDateFormat(this.getContext());
            DateFormat timeFormat = PluginUtils.getTimeFormat(this.getContext());
            DateFormat datetimeFormat = PluginUtils.getDateTimeFormat(this.getContext());
            this.inbound.setDateFormat(dateFormat);
            this.inbound.setTimeFormat(timeFormat);
            this.inbound.setDateTimeFormat(datetimeFormat);
        }
        catch (FmCalculationException | ParseException e) {
            throw new FeedbackException("Could not determine date/time format: " + e.getMessage(), e);
        }
        Message[] messages = this.inbound.readMessages(p);
        if (this.didCancel) {
            this.didCancel = false;
            throw new InterruptedException("Cancelled");
        }
        boolean downloadAttachments = PluginUtils.booleanForString(p.getProperty("attachments"), true);
        File prevFile = new File(System.getProperty("java.io.tmpdir"), "360email.xml");
        if (prevFile.exists()) {
            prevFile.delete();
        }
        File file = this.exportMessages(messages, downloadAttachments, p);
        return file;
    }

    @FMFunction(prototype="file { ; charset=UTF-8 }", description="This reads messages from an non-directory file or raw message content file, and stores the parsed messages in an FMPXML file, suitable for import into FileMaker.", typeAheadText={"emrmff"})
    public FMType EmailReadMessagesFromFile(FMData file, String[] flags) throws IOException, FeedbackException, TransformerConfigurationException, SAXException, MessagingException, InterruptedException {
        this.EmailDisconnect();
        if (file == null) {
            throw new FeedbackException("No input file was specified");
        }
        InputStreamInfo info = PluginUtils.getInputStreamInfo(file, this.getContext());
        if (info == null) {
            throw new FeedbackException("No input file was specified");
        }
        if (info.getFile() != null && info.getFile().isDirectory()) {
            throw new FeedbackException(info.getFile() + " is a directory, and EmailReadMessagesFromFile is expecting a file.");
        }
        CaseInsensitiveMap<String> map = PluginUtils.convertKeyValuesToCaseInsensitiveMap(flags, true);
        String charset = map.remove("charset");
        if (!map.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameter flag: " + map.keySet().iterator().next());
        }
        this.inMemoryIterator = null;
        this.inMemoryMessageData = null;
        this.inMemoryMessages = new ArrayList<Object[]>();
        List<MimeMessage> messageList = EmailUtils.messagesForFile(info, charset);
        File f = this.exportMessages(messageList.toArray(new Message[messageList.size()]), true, new Properties());
        return new FMText(this.getContext(), f.toURI().toURL().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportMessages(Message[] messages, boolean downloadAttachments, Properties p) throws IOException, TransformerConfigurationException, SAXException, MessagingException, InterruptedException {
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), "360email.xml");
        FMPXMLExport2.FieldElement[] fields = new FMPXMLExport2.FieldElement[]{new FMPXMLExport2.FieldElement("from", "TEXT"), new FMPXMLExport2.FieldElement("to", "TEXT"), new FMPXMLExport2.FieldElement("cc", "TEXT"), new FMPXMLExport2.FieldElement("bcc", "TEXT"), new FMPXMLExport2.FieldElement("replyTo", "TEXT"), new FMPXMLExport2.FieldElement("subject", "TEXT"), new FMPXMLExport2.FieldElement("messageNumber", "NUMBER"), new FMPXMLExport2.FieldElement("sentDate", "TIMESTAMP"), new FMPXMLExport2.FieldElement("receivedDate", "TIMESTAMP"), new FMPXMLExport2.FieldElement("text", "TEXT"), new FMPXMLExport2.FieldElement("messageId", "TEXT"), new FMPXMLExport2.FieldElement("attachments", "TEXT"), new FMPXMLExport2.FieldElement("viewed", "TEXT"), new FMPXMLExport2.FieldElement("flagged", "TEXT"), new FMPXMLExport2.FieldElement("replied", "TEXT"), new FMPXMLExport2.FieldElement("deleted", "TEXT"), new FMPXMLExport2.FieldElement("message", "TEXT"), new FMPXMLExport2.FieldElement("uid", "TEXT"), new FMPXMLExport2.FieldElement("html", "TEXT"), new FMPXMLExport2.FieldElement("attachmentContentIds", "TEXT")};
        try (FMPXMLExport2 export = new FMPXMLExport2(new BufferedOutputStream(new FileOutputStream(tmpFile)), fields, new Integer(messages.length));){
            Folder folder = this.inbound.getFolder();
            boolean isImap = folder instanceof IMAPFolder;
            boolean isPop = folder instanceof POP3Folder;
            MyMsgExceptionHandler handler = new MyMsgExceptionHandler();
            String tmpDir = System.getProperty("java.io.tmpdir");
            for (int i = 0; i < messages.length; ++i) {
                File downloadDir;
                String messageID;
                handler.msgNum = i;
                MimeMessage eachMessage = (MimeMessage)messages[i];
                try {
                    eachMessage.getMessageID();
                }
                catch (MessagingException e) {
                    if (e.getMessage().contains("Failed to load IMAP envelope")) {
                        log.log(Level.WARNING, "Error loading IMAP envelope.  Will attempt to construct the message locally, but this will prevent moving messages, or setting flags from working on the server.  Error Message: " + e.getMessage(), e);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        eachMessage.writeTo(bos);
                        bos.close();
                        SharedByteArrayInputStream bis = new SharedByteArrayInputStream(bos.toByteArray());
                        eachMessage = new MimeMessage(Session.getInstance(new Properties()), bis);
                        bis.close();
                    }
                    throw e;
                }
                String string = messageID = eachMessage.getMessageID() == null ? String.valueOf(new Random().nextInt() & 0xFFFF) : eachMessage.getMessageID().trim();
                if (downloadAttachments) {
                    if (p.getProperty("attachmentsDir") != null) {
                        downloadDir = new File(p.getProperty("attachmentsDir"));
                        IOUtils.ensureDirectoryIsReady(downloadDir);
                    } else {
                        boolean isFMServer = this.getApplicationType() == 3 || this.getApplicationType() == 7;
                        String uniqueFilename = UUID.randomUUID().toString().replaceAll("\\-", "");
                        downloadDir = isFMServer ? (Platform.isMac() ? new File("/Library/FileMaker Server/Data/Documents", uniqueFilename) : (Platform.isLin() ? new File("/opt/FileMaker/FileMaker Server/Database Server/Data/Documents", uniqueFilename) : new File("C:\\Program Files\\FileMaker\\FileMaker Server\\Data\\Documents", uniqueFilename))) : new File(tmpDir, uniqueFilename);
                    }
                } else {
                    downloadDir = null;
                }
                try {
                    String html;
                    PartExtractor partExtractor = new PartExtractor(downloadDir){

                        @Override
                        protected boolean isCancelled() {
                            return EmailerPlugin.this.didCancel;
                        }
                    };
                    partExtractor.extract(eachMessage, p);
                    String attachments = partExtractor.getAttachmentUrls();
                    String plainText = partExtractor.getPlainText();
                    if (plainText != null && plainText.indexOf(10) != -1) {
                        plainText = plainText.replaceAll("\n", plainText.indexOf("\r".charAt(0)) == -1 ? "\r" : "");
                    }
                    if ((html = partExtractor.getHtml()) != null) {
                        html = html.replace("\n".charAt(0), "\r".charAt(0));
                    }
                    Long uid = null;
                    try {
                        Long l = isImap ? new Long(((IMAPFolder)folder).getUID(eachMessage)) : (uid = isPop ? ((POP3Folder)folder).getUID(eachMessage) : null);
                        if (uid == null && folder instanceof UIDFolder) {
                            log.log(Level.WARNING, "Get UID From " + folder);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Unable to determine UID for message " + eachMessage, e);
                    }
                    String subject = MsgValueGetter.getSubject(eachMessage, handler);
                    Object[] eachDataRow = new Object[]{this.returnSeparatedAddresses(MsgValueGetter.getFrom(eachMessage, handler)), this.returnSeparatedAddresses(MsgValueGetter.getRecipients(eachMessage, handler, Message.RecipientType.TO)), this.returnSeparatedAddresses(MsgValueGetter.getRecipients(eachMessage, handler, Message.RecipientType.CC)), this.returnSeparatedAddresses(MsgValueGetter.getRecipients(eachMessage, handler, Message.RecipientType.BCC)), this.returnSeparatedAddresses(MsgValueGetter.getReplyTo(eachMessage, handler)), subject, new Integer(eachMessage.getMessageNumber()), MsgValueGetter.getSentDate(eachMessage, handler), MsgValueGetter.getReceivedDate(eachMessage, handler), plainText, MsgValueGetter.getMessageId(eachMessage, handler), attachments, MsgValueGetter.stringForFlag(eachMessage, handler, Flags.Flag.SEEN), MsgValueGetter.stringForFlag(eachMessage, handler, Flags.Flag.FLAGGED), MsgValueGetter.stringForFlag(eachMessage, handler, Flags.Flag.ANSWERED), MsgValueGetter.stringForFlag(eachMessage, handler, Flags.Flag.DELETED), eachMessage, uid, html, partExtractor};
                    export.addRow(eachDataRow);
                    if (this.inMemoryMessages == null) continue;
                    this.inMemoryMessages.add(eachDataRow);
                    continue;
                }
                catch (Throwable e) {
                    throw new IOException("Error while reading messages: " + e.getMessage(), e);
                }
            }
            File file = tmpFile;
            return file;
        }
    }

    private String returnSeparatedAddresses(Address[] from) {
        if (from == null || from.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String delim = "";
        for (int i = 0; i < from.length; ++i) {
            InternetAddress eachAddress = (InternetAddress)from[i];
            result.append(delim);
            String personal = eachAddress.getPersonal();
            if (personal != null && personal.startsWith("=?")) {
                try {
                    personal = MimeUtility.decodeText(personal);
                }
                catch (UnsupportedEncodingException e) {
                    log.log(Level.SEVERE, "Unable to decode personal name in email address: " + eachAddress, e);
                }
            }
            if (personal != null) {
                if (!personal.startsWith("\"")) {
                    personal = "\"" + personal;
                }
                if (!personal.endsWith("\"")) {
                    personal = personal + "\"";
                }
                result.append(personal).append("<").append(eachAddress.getAddress()).append(">");
            } else {
                result.append(eachAddress.getAddress());
            }
            delim = "\n";
        }
        return result.toString();
    }

    @FMFunction(resultName="Is Message Loaded", description="Loads a single message which was fetched in a previous call to the EmailReadMessages function.", typeAheadText={"emgnm"})
    public FMType EmailGetNextMessage() throws FeedbackException {
        if (this.inMemoryMessages == null) {
            throw new FeedbackException("You must call EmailReadMessages before calling EmailGetNextMessage");
        }
        if (this.inMemoryIterator == null) {
            this.inMemoryIterator = this.inMemoryMessages.iterator();
        }
        if (this.inMemoryIterator.hasNext()) {
            this.inMemoryMessageData = (Object[])this.inMemoryIterator.next();
            this.inbound.setCurrentMessage((MimeMessage)this.inMemoryMessageData[16]);
            return new FMNumber(1);
        }
        return new FMNumber(0);
    }

    @FMFunction(prototype="key", resultName="Message Value", description="Retrieves information about the last message which was gotten by the EmailGetNextMessage function.", typeAheadText={"emrmv"}, showInCalcs=false)
    public FMType EmailReadMessageValue(MessageValue key) throws FeedbackException {
        log.log(Level.FINE, "Getting message value {0}", (Object)key);
        if (key == null || key.name().length() == 0) {
            throw new FeedbackException("Key cannot be empty");
        }
        String keyString = key.name().toLowerCase();
        if ("count".equals(keyString)) {
            return new FMNumber(this.inMemoryMessages.size());
        }
        if (this.inMemoryMessageData == null) {
            throw new FeedbackException("You must call EmailGetNextMessage before calling EmailReadMessageValue");
        }
        return this.readMessageValue(keyString);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private FMType readMessageValue(String keyString) throws FeedbackException {
        if ("from".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[0]);
        }
        if ("to".equals(keyString)) {
            return new FMText(this.getContext(), PluginUtils.convertLineBreaksToFileMaker((String)this.inMemoryMessageData[1]));
        }
        if ("cc".equals(keyString)) {
            return new FMText(this.getContext(), PluginUtils.convertLineBreaksToFileMaker((String)this.inMemoryMessageData[2]));
        }
        if ("bcc".equals(keyString)) {
            return new FMText(this.getContext(), PluginUtils.convertLineBreaksToFileMaker((String)this.inMemoryMessageData[3]));
        }
        if ("reply".equals(keyString)) return new FMText(this.getContext(), (String)this.inMemoryMessageData[4]);
        if ("reply-to".equals(keyString)) return new FMText(this.getContext(), (String)this.inMemoryMessageData[4]);
        if ("replyto".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[4]);
        }
        if ("subject".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[5]);
        }
        if ("messagenumber".equals(keyString) || "message-number".equals(keyString)) {
            Number messageNumber = (Number)this.inMemoryMessageData[6];
            if (messageNumber == null) {
                return null;
            }
            FMNumber fMNumber = new FMNumber(messageNumber);
            return fMNumber;
        }
        if ("sent".equals(keyString) || "sentdate".equals(keyString) || "datesent".equals(keyString) || "date".equals(keyString)) {
            Date sentDate = (Date)this.inMemoryMessageData[7];
            if (sentDate == null) {
                return null;
            }
            FMTimestamp fMTimestamp = new FMTimestamp(sentDate);
            return fMTimestamp;
        }
        if ("received".equals(keyString) || "datereceived".equals(keyString) || "receiveddate".equals(keyString)) {
            Date receivedDate = (Date)this.inMemoryMessageData[8];
            if (receivedDate == null) {
                return null;
            }
            FMTimestamp fMTimestamp = new FMTimestamp(receivedDate);
            return fMTimestamp;
        }
        if ("messageid".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[10]);
        }
        if ("attachments".equals(keyString)) {
            PartExtractor extractor = (PartExtractor)this.inMemoryMessageData[19];
            return new FMText(this.getContext(), PluginUtils.convertLineBreaksToFileMaker(extractor.getAttachmentUrlsExcludingInlineDownloadedAttachments()));
        }
        if ("attachmentsinline".equals(keyString)) {
            PartExtractor extractor = (PartExtractor)this.inMemoryMessageData[19];
            return new FMText(this.getContext(), PluginUtils.convertLineBreaksToFileMaker(extractor.getInlineAttachments()));
        }
        if ("attachmentsall".equals(keyString)) {
            PartExtractor extractor = (PartExtractor)this.inMemoryMessageData[19];
            return new FMText(this.getContext(), PluginUtils.convertLineBreaksToFileMaker(extractor.getAttachmentUrls()));
        }
        if ("content".equals(keyString)) return new FMText(this.getContext(), (String)this.inMemoryMessageData[9]);
        if ("body".equals(keyString)) return new FMText(this.getContext(), (String)this.inMemoryMessageData[9]);
        if ("text".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[9]);
        }
        if ("html".equals(keyString)) {
            return new FMText(this.getContext(), this.htmlData());
        }
        if ("htmldata".equals(keyString)) {
            return new FMText(this.getContext(), this.htmlData());
        }
        if ("htmlraw".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[18]);
        }
        if ("read".equals(keyString)) return new FMText(this.getContext(), (String)this.inMemoryMessageData[12]);
        if ("viewed".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[12]);
        }
        if ("flagged".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[13]);
        }
        if ("replied".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[14]);
        }
        if ("deleted".equals(keyString)) {
            return new FMText(this.getContext(), (String)this.inMemoryMessageData[15]);
        }
        if ("uid".equals(keyString)) {
            return new FMText(this.getContext(), String.valueOf(this.inMemoryMessageData[17]));
        }
        if ("raw".equals(keyString)) {
            MimeMessage mimeMessage = (MimeMessage)this.inMemoryMessageData[16];
            try (BufferedReader source = new BufferedReader(new InputStreamReader(mimeMessage.getRawInputStream()));){
                FMText fMText = new FMText(this.getContext(), source);
                return fMText;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        }
        if ("headers".equals(keyString)) {
            MimeMessage mimeMessage = (MimeMessage)this.inMemoryMessageData[16];
            try {
                return FMType.bestTypeForJavaObject(this.getContext(), Collections.list(mimeMessage.getAllHeaderLines()));
            }
            catch (MessagingException e) {
                throw new FeedbackException("Could not retrieve headers for message: " + e.getMessage(), e);
            }
        }
        String headerName = keyString.startsWith("header:") ? keyString.substring(7).trim() : keyString;
        MimeMessage mimeMessage = (MimeMessage)this.inMemoryMessageData[16];
        try {
            String[] values = mimeMessage.getHeader(headerName);
            return FMType.bestTypeForJavaObject(this.getContext(), values);
        }
        catch (MessagingException e) {
            throw new FeedbackException("Unable to retrieve message header: " + e.getMessage(), e);
        }
    }

    @FMFunction(prototype="key", resultName="Message Value", description="Retrieves information about the last message which was gotten by the EmailGetNextMessage function.", typeAheadText={"emrmv"}, showInScriptSteps=false)
    public FMType EmailReadMessageValue(FMText key) throws FeedbackException {
        if (key == null || "".equals(key.getAsString(this.getContext()))) {
            throw new FeedbackException("Key cannot be empty");
        }
        String keyString = key.getAsString(this.getContext()).toLowerCase();
        return this.internalReadMessageValue(keyString);
    }

    private FMType internalReadMessageValue(String keyString) throws FeedbackException {
        log.log(Level.FINE, "Getting message value {0}", keyString);
        if ("count".equals(keyString)) {
            return new FMNumber(this.inMemoryMessages.size());
        }
        if (this.inMemoryMessageData == null) {
            throw new FeedbackException("You must call EmailGetNextMessage before calling EmailReadMessageValue");
        }
        return this.readMessageValue(keyString);
    }

    private String htmlData() {
        String html = (String)this.inMemoryMessageData[18];
        if (html == null || html.length() == 0) {
            return null;
        }
        PartExtractor extractor = (PartExtractor)this.inMemoryMessageData[19];
        if (extractor == null || !extractor.downloadAttachmentsEnabled()) {
            return html;
        }
        Pattern p = Pattern.compile("([\"\\(])cid:([^\"\\)]+)([\"\\)])");
        if (!p.matcher(html).find()) {
            return html;
        }
        Matcher m = p.matcher(html);
        StringBuffer result = new StringBuffer(html.length());
        while (m.find()) {
            String cid = m.group(2);
            try {
                AttachmentInfo info = extractor.getAttachmentInfoByContentId(cid);
                if (info != null) {
                    m.appendReplacement(result, "$1" + info.getAttachentDataUrl() + "$3");
                    continue;
                }
                m.appendReplacement(result, "$0");
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Could not get attachment with cid " + cid, e);
            }
        }
        m.appendTail(result);
        return result.toString();
    }

    @FMFunction(prototype="path { ; savePath }", description="Read a downloaded attachment into a FileMaker container field.", typeAheadText={"emra"})
    public FMType EmailReadAttachment(String path, String savePath) throws IOException, FeedbackException {
        if (path == null || path.length() == 0) {
            throw new FeedbackException("Path was not specified");
        }
        File currentAttachmentPath = PluginUtils.fileForFMPath(path.trim());
        if (savePath != null && savePath.length() != 0) {
            String fileName = currentAttachmentPath.getName();
            if (savePath.substring(savePath.length() - 1).equals("/")) {
                File savePathWithFileName = new File(savePath.trim() + fileName);
            } else {
                File savePathWithFileName = new File(savePath.trim() + "/" + fileName);
            }
            try {
                File source = PluginUtils.fileForFMPath(currentAttachmentPath.getAbsolutePath());
                File dest = PluginUtils.fileForFMPath(savePath);
                log.info(String.format("Moving email attachment from %s to %s", source.getAbsolutePath(), dest.getAbsolutePath()));
                IOUtils.moveFile(source, dest, true);
            }
            catch (IOException e) {
                throw new IOException("Error moving attachment to supplied path", e);
            }
            return new FMNumber(1);
        }
        return FMBinary.fmBinaryForFile(currentAttachmentPath, this.getContext());
    }

    @FMFunction(prototype="flag { ; value }", description="Applies a flag to the current message, as retrieved by the function EmailGetNextMessage.", typeAheadText={"emsf"})
    public void EmailMessageSetFlag(MessageFlag flag, String value) throws MessagingException, FeedbackException {
        Flags.Flag flagObject;
        if (value == null) {
            value = "true";
        }
        if (flag == null) {
            throw new FeedbackException("flag must not be empty.");
        }
        if (this.inbound.folderModeIsReadOnly()) {
            throw new IllegalStateException("You must specify readonly=false when fetching messages before setting flags");
        }
        String flagString = flag.name().toLowerCase();
        if (flagString.equals("deleted")) {
            flagObject = Flags.Flag.DELETED;
        } else if (flagString.equals("replied") || flagString.equals("answered")) {
            flagObject = Flags.Flag.ANSWERED;
        } else if (flagString.equals("draft")) {
            flagObject = Flags.Flag.DRAFT;
        } else if (flagString.equals("flagged")) {
            flagObject = Flags.Flag.FLAGGED;
        } else if (flagString.equals("read") || flagString.equals("seen") || flagString.equals("viewed")) {
            flagObject = Flags.Flag.SEEN;
        } else if (flagString.equals("recent")) {
            flagObject = Flags.Flag.RECENT;
        } else {
            throw new FeedbackException("Unknown flag: " + flagString);
        }
        boolean booleanValue = PluginUtils.booleanForString(value);
        log.log(Level.INFO, "Setting flag " + flagString + " to " + value);
        this._setCurrentMessageFlag(flagObject, booleanValue);
    }

    private void _setCurrentMessageFlag(Flags.Flag flag, boolean value) throws MessagingException, FeedbackException {
        if (this.inMemoryMessageData == null) {
            throw new FeedbackException("You must call EmailGetNextMessage before calling EmailReadMessageValue");
        }
        MimeMessage msg = (MimeMessage)this.inMemoryMessageData[16];
        msg.setFlag(flag, value);
        if (value && Flags.Flag.DELETED.equals(flag)) {
            this.model.setExpungeOverride(true);
        }
    }

    @FMFunction(prototype="host { ; username ; password ; secureConnection ; ssl=true ; forceTrust=true ; tls=true ; timeout=10 ; ... }", description="Connect to an outgoing SMTP mail server.", typeAheadText={"emcsmtp"}, timeoutSeconds=0)
    public void EmailConnectSMTP(String host, String username, FMData password, String[] args) throws MessagingException, FeedbackException {
        CaseInsensitiveMap<String> map = PluginUtils.convertKeyValuesToCaseInsensitiveMap(args, true);
        if (this.outbound.getClass() != EmailerModel.class) {
            this.outbound.disconnect();
            this.outbound = this.model;
        }
        Integer timeout = this.model.stringToInteger(map.remove("timeout"));
        boolean ssl = PluginUtils.booleanForString(map.remove("ssl"), false);
        boolean tls = PluginUtils.booleanForString(map.remove("tls"), false);
        boolean forceTrust = PluginUtils.booleanForString(map.remove("forceTrust"), false);
        boolean enableLogging = PluginUtils.booleanForString(map.remove("enableLogging"), false);
        boolean enableLegacyLogin = PluginUtils.booleanForString(map.remove("enableLegacyLogin"), true);
        if (!map.isEmpty()) {
            log.log(Level.WARNING, "Unknown key(s): " + map.keySet());
        }
        if (args != null && args.length > 0 && args[0] != null && (args[0].equals("1") || args[0].equalsIgnoreCase("true"))) {
            tls = true;
            ssl = true;
        }
        this.outbound.setLoggingEnabled(enableLogging);
        this.outbound.setStartTLS(tls);
        this.outbound.connectSMTP(host, username, password == null ? null : password.getStringData(this.getContext()), ssl, timeout, forceTrust, enableLegacyLogin);
    }

    @FMFunction(resultName="Is Connected", description="Checks if connected to an outbound mail server", typeAheadText={"emoic"})
    public FMType EmailOutboundIsConnected() {
        if (this.outbound.isOutboundConnected()) {
            return new FMNumber(1);
        }
        return new FMNumber(0);
    }

    @FMFunction(prototype="host ; username ; password { ; secureConnection ; tls=true ; ... }", description="Connect to an incoming POP mail server.", typeAheadText={"emcpop"})
    public void EmailConnectPOP(String host, String username, FMData password, String[] args) throws MessagingException, FeedbackException {
        CaseInsensitiveMap<String> map = PluginUtils.convertKeyValuesToCaseInsensitiveMap(args, true);
        String sslString = map.remove("ssl");
        String tlsString = map.remove("tls");
        String forceTrustString = map.remove("forceTrust");
        if (!map.isEmpty()) {
            log.log(Level.WARNING, "Unknown key(s): " + map.keySet());
        }
        boolean secureConnection = false;
        boolean forceTrust = false;
        boolean ssl = false;
        boolean enableLegacyLogin = PluginUtils.booleanForString(map.remove("enableLegacyLogin"), true);
        boolean enableLogging = PluginUtils.booleanForString(map.remove("enableLogging"), false);
        if (args != null) {
            if (tlsString != null) {
                secureConnection = PluginUtils.booleanForString(tlsString, false);
            } else if (args.length > 0 && args[0] != null && (args[0].equals("1") || args[0].equalsIgnoreCase("true"))) {
                secureConnection = true;
            }
            if (sslString != null) {
                ssl = PluginUtils.booleanForString(sslString, false);
            }
            if (forceTrustString != null) {
                forceTrust = PluginUtils.booleanForString(forceTrustString, false);
            }
        }
        this.inbound.setStartTLS(secureConnection);
        this.inbound.setLoggingEnabled(enableLogging);
        String protocol = ssl ? "pop3s" : "pop3";
        this.inbound.connectInbound(host, username, password == null ? null : password.getStringData(this.getContext()), protocol, forceTrust, enableLegacyLogin);
    }

    @FMFunction(prototype="host ; username ; password { ; secureConnection ; tls=true ; ... }", description="Connect to an incoming IMAP mail server.", typeAheadText={"emcimap"}, timeoutSeconds=0)
    public void EmailConnectIMAP(String host, String username, String password, String[] args) throws MessagingException, FeedbackException {
        if (this.inbound.getClass() != EmailerModel.class) {
            this.inbound = this.model;
        }
        CaseInsensitiveMap<String> map = PluginUtils.convertKeyValuesToCaseInsensitiveMap(args, true);
        boolean ssl = PluginUtils.booleanForString(map.remove("ssl"), false);
        boolean tls = PluginUtils.booleanForString(map.remove("tls"), false);
        boolean enableLegacyLogin = PluginUtils.booleanForString(map.remove("enableLegacyLogin"), true);
        boolean forceTrust = PluginUtils.booleanForString(map.remove("forceTrust"), false);
        boolean expunge = PluginUtils.booleanForString(map.remove("expunge"));
        boolean enableLogging = PluginUtils.booleanForString(map.remove("enableLogging"), false);
        boolean enableSASL = PluginUtils.booleanForString(map.remove("enableSASL"));
        if (!map.isEmpty()) {
            log.log(Level.WARNING, "Unknown key(s): " + map.keySet());
        }
        boolean secureConnection = false;
        if (args != null) {
            if (tls) {
                secureConnection = tls;
            } else if (args.length > 0 && args[0] != null && (args[0].equals("1") || args[0].equalsIgnoreCase("true"))) {
                secureConnection = true;
            }
        }
        this.inbound.setStartTLS(secureConnection);
        String protocol = ssl ? "imaps" : "imap";
        this.inbound.setExpungeOverride(expunge);
        this.inbound.setLoggingEnabled(enableLogging);
        this.inbound.setSASLOverIMAP(enableSASL);
        this.inbound.connectInbound(host, username, password, protocol, forceTrust, enableLegacyLogin);
    }

    @FMFunction(resultName="Is Connected Inbound", typeAheadText={"emiic"})
    public FMType EmailInboundIsConnected() {
        if (this.inbound.isInboundConnected()) {
            return new FMNumber(1);
        }
        return new FMNumber(0);
    }

    @FMFunction(prototype="accessKey ; secretKey { ; region }", description="Connect to the Amazon Simple Email Service (SES) servers for sending email.", typeAheadText={"emca"})
    public void EmailConnectAmazon(String accessKey, String secretKey, String region) throws FeedbackException, MessagingException {
        Region regionByCode = null;
        if (region != null) {
            regionByCode = Region.getRegionByCode(region);
        }
        this.outbound = new AmazonOutbound(accessKey, secretKey, regionByCode);
        this.model = (EmailerModel)this.outbound;
    }

    @FMFunction(prototype="tokenStore ; googleClientId ; googleClientSecret { ; state }", minimumVersion="4.0")
    public FMType EmailGoogleGetLoginUrl(@Nullable String tokenStore, String googleClientId, String googleClientSecret, @Nullable String state) throws FeedbackException {
        if (googleClientId == null || googleClientSecret == null) {
            throw new FeedbackException("You must provide the googleClientId and googleClientSecret to connect to Google services");
        }
        this.oAuthWorkflow = new GoogleOAuthWorkflow(googleClientId, googleClientSecret, this.getScopesForGmail());
        return this.getLoginUrlForOAuthWorkflow(tokenStore, state, this.oAuthWorkflow);
    }

    @FMFunction(prototype="username ; tokenStore { ; googleClientId ; googleClientSecret ; state }", minimumVersion="4.0")
    public FMType EmailGoogleConnectIMAP(String username, @Nullable String tokenStore, @Nullable String googleClientId, @Nullable String googleClientSecret, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        return this.EmailGoogleConnect(username, tokenStore, googleClientId, googleClientSecret, state);
    }

    private String googleConnectIMAP(String username, @Nullable String tokenStore, @Nullable String googleClientId, @Nullable String googleClientSecret, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        if (state == null && this.oAuthWorkflow == null) {
            throw new FeedbackException("You must either call EmailGoogleGetLoginUrl first, or supply the parameters: state, googleClientId, and googelClientSecret");
        }
        if (state != null && this.oAuthWorkflow == null) {
            this.oAuthWorkflow = new GoogleOAuthWorkflow(googleClientId, googleClientSecret, this.getScopesForGmail());
        }
        TokenStore newTokenStore = OAuthWorkflow.fetchTokenWorkflow(this.oAuthWorkflow, tokenStore, state);
        this.inbound = new OAuthEmailerModel();
        this.inbound.connectInbound("imap.gmail.com:993", username, newTokenStore.access_token, "imaps", false, false);
        return newTokenStore.toString();
    }

    @FMFunction(prototype="username ; tokenStore { ; googleClientId ; googleClientSecret ; state }", minimumVersion="4.0")
    public FMType EmailGoogleConnectSMTP(String username, @Nullable String tokenStore, @Nullable String googleClientId, @Nullable String googleClientSecret, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        return this.EmailGoogleConnect(username, tokenStore, googleClientId, googleClientSecret, state);
    }

    private String googleConnectSMTP(String username, @Nullable String tokenStore, @Nullable String googleClientId, @Nullable String googleClientSecret, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        if (state == null && this.oAuthWorkflow == null) {
            throw new FeedbackException("You must either call EmailGoogleGetLoginUrl first, or supply the parameters: state, googleClientId, and googelClientSecret");
        }
        if (state != null && this.oAuthWorkflow == null) {
            this.oAuthWorkflow = new GoogleOAuthWorkflow(googleClientId, googleClientSecret, this.getScopesForGmail());
        }
        TokenStore newTokenStore = OAuthWorkflow.fetchTokenWorkflow(this.oAuthWorkflow, tokenStore, state);
        this.outbound = new OAuthEmailerModel();
        this.outbound.connectSMTP("smtp.gmail.com:587", username, newTokenStore.access_token, false, null, false, false);
        return newTokenStore.toString();
    }

    @FMFunction(prototype="username ; tokenStore { ; googleClientId ; googleClientSecret ; state }", minimumVersion="4.0")
    public FMType EmailGoogleConnect(String username, @Nullable String tokenStore, @Nullable String googleClientId, @Nullable String googleClientSecret, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        if (state == null && this.oAuthWorkflow == null) {
            throw new FeedbackException("You must either call EmailGoogleGetLoginUrl first, or supply the parameters: state, googleClientId, and googelClientSecret");
        }
        if (state != null && this.oAuthWorkflow == null) {
            this.oAuthWorkflow = new GoogleOAuthWorkflow(googleClientId, googleClientSecret, this.getScopesForGmail());
        }
        TokenStore newTokenStore = OAuthWorkflow.fetchTokenWorkflow(this.oAuthWorkflow, tokenStore, state);
        OAuthEmailerModel emailerModel = new OAuthEmailerModel();
        this.inbound = emailerModel;
        this.inbound.connectInbound("imap.gmail.com:993", username, newTokenStore.access_token, "imaps", false, false);
        this.outbound = emailerModel;
        this.outbound.connectSMTP("smtp.gmail.com:587", username, newTokenStore.access_token, false, null, false, false);
        return FMType.bestTypeForJavaObject(this.getContext(), newTokenStore.toString());
    }

    @NotNull
    private List<String> getScopesForGmail() {
        List<String> list = Collections.singletonList("https://mail.google.com/");
        if (list == null) {
            EmailerPlugin.$$$reportNull$$$0(0);
        }
        return list;
    }

    @FMFunction(prototype="tokenStore { ; office365ClientId ; office365ClientSecret ; office365TenantId ; state }", minimumVersion="4.0")
    public FMType EmailOffice365GetLoginUrl(@Nullable String tokenStore, String office365ClientId, String office365ClientSecret, @Nullable String office365TenantId, @Nullable String state) throws FeedbackException {
        this.oAuthWorkflow = this.getOffice365OAuthWorkflow(office365ClientId, office365ClientSecret, office365TenantId);
        return this.getLoginUrlForOAuthWorkflow(tokenStore, state, this.oAuthWorkflow);
    }

    @Nullable
    private FMType getLoginUrlForOAuthWorkflow(@Nullable String tokenStore, @Nullable String state, OAuthWorkflow workflow) {
        TokenStore currentTokenStore = TokenStore.createFromFMString(tokenStore);
        String tokenStatus = OAuthWorkflow.checkToken(currentTokenStore);
        boolean tokenRevoked = false;
        if (!"NO_TOKENS_VALID".equals(tokenStatus)) {
            try {
                TokenStore tokenStore2 = workflow.refreshTokenStore(currentTokenStore);
            }
            catch (IOException e) {
                log.warning("Token failed to refresh with error, will return a new login url.  Error message: " + e.getMessage());
                tokenRevoked = true;
            }
        }
        if (tokenRevoked || "NO_TOKENS_VALID".equals(tokenStatus)) {
            String url = workflow.getLoginUrl(state);
            return FMType.bestTypeForJavaObject(this.getContext(), url);
        }
        return FMType.bestTypeForJavaObject(this.getContext(), null);
    }

    @FMFunction(prototype="username ; tokenStore { ; office365ClientId ; office365ClientSecret ; office365TenantId ; state }", minimumVersion="4.0")
    public FMType EmailOffice365ConnectIMAP(String username, @Nullable String tokenStore, String office365ClientId, String office365ClientSecret, @Nullable String office365TenantId, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        String newTokenStoreString = this.office365ConnectIMAP(username, tokenStore, office365ClientId, office365ClientSecret, office365TenantId, state);
        return FMType.bestTypeForJavaObject(this.getContext(), newTokenStoreString);
    }

    private String office365ConnectIMAP(String username, @Nullable String tokenStore, String office365ClientId, String office365ClientSecret, @Nullable String office365TenantId, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        if (state == null && this.oAuthWorkflow == null) {
            throw new FeedbackException("You must either call EmailOffice365GetLoginUrl first, or pass in a \"state\" parameter");
        }
        if (state != null && this.oAuthWorkflow == null) {
            this.oAuthWorkflow = this.getOffice365OAuthWorkflow(office365ClientId, office365ClientSecret, office365TenantId);
        } else if (office365TenantId != null && this.oAuthWorkflow == null) {
            this.oAuthWorkflow = this.getOffice365OAuthWorkflow(office365ClientId, office365ClientSecret, office365TenantId);
        }
        TokenStore newTokenStore = OAuthWorkflow.fetchTokenWorkflow(this.oAuthWorkflow, tokenStore, state);
        this.inbound = new OAuthEmailerModel();
        this.inbound.connectInbound("outlook.office365.com:993", username, newTokenStore.access_token, "imaps", false, false);
        return newTokenStore.toString();
    }

    private Office365OAuthWorkflow getOffice365OAuthWorkflow(@Nullable String office365ClientId, @Nullable String office365ClientSecret, @Nullable String office365TenantId) {
        if (office365ClientId != null && office365ClientSecret != null) {
            log.log(Level.INFO, "Custom Office 365 Keys detected.  Office 365 Client ID: " + office365ClientId + "Office 365 Tenant ID: " + office365TenantId);
            if (office365TenantId != null) {
                return new Office365OAuthWorkflow(office365ClientId, office365ClientSecret, office365TenantId, this.getScopesForOffice365());
            }
            return new Office365OAuthWorkflow(office365ClientId, office365ClientSecret, this.getScopesForOffice365());
        }
        return Office365OAuthWorkflow.getDefault();
    }

    @FMFunction(prototype="username ; tokenStore { ; office365ClientId ; office365ClientSecret ; office365TenantId ; state }", minimumVersion="4.0")
    public FMType EmailOffice365ConnectSMTP(String username, @Nullable String tokenStore, @Nullable String office365ClientId, @Nullable String office365ClientSecret, @Nullable String office365TenantId, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        String newTokenStoreString = this.office365ConnectSMTP(username, tokenStore, office365ClientId, office365ClientSecret, office365TenantId, state);
        return FMType.bestTypeForJavaObject(this.getContext(), newTokenStoreString);
    }

    private String office365ConnectSMTP(String username, @Nullable String tokenStore, @Nullable String office365ClientId, @Nullable String office365ClientSecret, @Nullable String office365TenantId, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        if (state == null && this.oAuthWorkflow == null) {
            throw new FeedbackException("You must either call EmailOffice365GetLoginUrl first, or pass in a \"state\" parameter");
        }
        if (state != null && this.oAuthWorkflow == null) {
            this.oAuthWorkflow = this.getOffice365OAuthWorkflow(office365ClientId, office365ClientSecret, office365TenantId);
        }
        TokenStore newTokenStore = OAuthWorkflow.fetchTokenWorkflow(this.oAuthWorkflow, tokenStore, state);
        this.outbound = new OAuthEmailerModel();
        this.outbound.connectSMTP("smtp.office365.com:587", username, newTokenStore.access_token, false, null, false, false);
        return newTokenStore.toString();
    }

    @FMFunction(prototype="username ; tokenStore { ; office365ClientId ; office365ClientSecret ; office365TenantId ; state }", minimumVersion="4.0")
    public FMType EmailOffice365Connect(String username, @Nullable String tokenStore, @Nullable String office365ClientId, @Nullable String office365ClientSecret, @Nullable String office365TenantId, @Nullable String state) throws FeedbackException, IOException, MessagingException {
        if (state == null && this.oAuthWorkflow == null) {
            throw new FeedbackException("You must either call EmailOffice365GetLoginUrl first, or pass in a \"state\" parameter");
        }
        if (state != null && this.oAuthWorkflow == null) {
            this.oAuthWorkflow = this.getOffice365OAuthWorkflow(office365ClientId, office365ClientSecret, office365TenantId);
        }
        TokenStore newTokenStore = OAuthWorkflow.fetchTokenWorkflow(this.oAuthWorkflow, tokenStore, state);
        OAuthEmailerModel emailerModel = new OAuthEmailerModel();
        this.outbound = emailerModel;
        this.outbound.connectSMTP("smtp.office365.com:587", username, newTokenStore.access_token, false, null, false, false);
        this.inbound = emailerModel;
        this.inbound.connectInbound("outlook.office365.com:993", username, newTokenStore.access_token, "imaps", false, false);
        return FMType.bestTypeForJavaObject(this.getContext(), newTokenStore.toString());
    }

    @NotNull
    private List<String> getScopesForOffice365() {
        List<String> list = Arrays.asList("openid", "offline_access", "https://outlook.office.com/SMTP.Send", "https://outlook.office.com/IMAP.AccessAsUser.All", "https://outlook.office.com/POP.AccessAsUser.All");
        if (list == null) {
            EmailerPlugin.$$$reportNull$$$0(1);
        }
        return list;
    }

    @FMFunction(prototype="searchString ; replaceString", description="Perform a substitute operation an the HTML or plain-text portion of the current HTML message.", typeAheadText={"embs"})
    public void EmailBodySubstitute(String searchString, String replaceString) throws FeedbackException, MessagingException {
        if (searchString == null) {
            throw new FeedbackException("searchString must not be null.");
        }
        if (replaceString == null) {
            replaceString = "";
        }
        this.outbound.getPluginMessage().bodySubstitute(searchString, replaceString);
    }

    @FMFunction(prototype="folder", description="Moves a message on an IMAP mailbox.", typeAheadText={"emmcm"})
    public void EmailMoveCurrentMessage(String folder) throws MessagingException, FeedbackException, IOException {
        this.inbound.moveCurrentMessage(folder);
    }

    @FMFunction(prototype="{ initialPath ; fileType ; title }", resultName="Path To File", description="Shows a file chooser dialog where a user can browse her local hard drive.", gui=GuiMode.Swing, typeAheadText={"emcf"})
    public FMText EmailChooseFile(String initialPath, String fileType, String title) throws FeedbackException {
        int fileTypeInt;
        Properties p = new Properties();
        PluginUtils.clearZeroLengthStrings(p);
        if (fileType == null || fileType.length() == 0 || fileType.startsWith("file")) {
            fileTypeInt = 0;
            if (title == null) {
                title = "Select File";
            }
        } else if (fileType.indexOf(43) > 0 || fileType.indexOf(38) > 0 || fileType.indexOf(" and ") > 0 || fileType.contains("all")) {
            fileTypeInt = 2;
            if (title == null) {
                title = "Select Files";
            }
        } else if (fileType.startsWith("dir") || fileType.startsWith("folder")) {
            fileTypeInt = 1;
            if (title == null) {
                title = "Select Directory";
            }
        } else {
            throw new IllegalArgumentException("fileType must be one of \"files\", \"directories\", or \"files + directories\"");
        }
        FileChooserOptions options = new FileChooserOptions(PluginUtils.fileForFMPath(initialPath), fileTypeInt, title);
        File selections = this.model.chooseFile(this.getFrame(), options);
        if (selections == null) {
            return null;
        }
        return new FMText(this.getContext(), FMFileUtils.convertToFileMaker(selections));
    }

    @FMFunction(prototype="emailAddress ; problemDescription", description="Send a problem report to 360Works.", typeAheadText={"emrp"})
    public void EmailReportProblem(String emailAddress, String problemDescription) throws FeedbackException, IOException, InvalidLicenseException {
        if (emailAddress == null || emailAddress.equals("")) {
            throw new FeedbackException("You must enter an email address");
        }
        int orderId = this.getRegistration().getLicense().getOrderID();
        String licenseInfo = this.getRegistration().getLicenseInfo();
        this.reportProblem(emailAddress, problemDescription, "", orderId, licenseInfo, true);
    }

    @FMFunction(prototype="accessKey ; secretKey ; recipient ; body { ; region }")
    public void EmailSMSSend(@NotNull String accessKey, @NotNull String secretKey, @NotNull String recipient, @NotNull String body, @Nullable String region) throws FeedbackException, IOException, NoSuchAlgorithmException {
        if (accessKey == null) {
            EmailerPlugin.$$$reportNull$$$0(2);
        }
        if (secretKey == null) {
            EmailerPlugin.$$$reportNull$$$0(3);
        }
        if (recipient == null) {
            EmailerPlugin.$$$reportNull$$$0(4);
        }
        if (body == null) {
            EmailerPlugin.$$$reportNull$$$0(5);
        }
        this.model.sendSMS(accessKey, secretKey, recipient, body, Region.getRegionByCode(region));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/emailplugin/EmailerPlugin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secretKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recipient";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopesForGmail";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopesForOffice365";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/emailplugin/EmailerPlugin";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "EmailSMSSend";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyMsgExceptionHandler
    implements MsgExceptionHandler {
        int msgNum;

        MyMsgExceptionHandler() {
        }

        @Override
        public Object valueAfterException(MimeMessage message, MessagingException e) {
            log.log(Level.WARNING, "Error reading value from message #" + this.msgNum + " (" + message + "), returning null instead.", e);
            return null;
        }
    }

    private static enum MessageFlag {
        deleted,
        replied,
        draft,
        flagged,
        viewed,
        recent;

    }

    public static enum MessageValue {
        count,
        from,
        to,
        cc,
        bcc,
        replyTo,
        subject,
        messageNumber,
        sent,
        received,
        text,
        messageId,
        attachments,
        attachmentsall,
        viewed,
        flagged,
        replied,
        deleted,
        headers,
        uid,
        html,
        htmlRaw,
        htmldata,
        raw;

    }
}

