/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.aws.Region;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.SESException;
import com.prosc.aws.sns.CreateTopic;
import com.prosc.aws.sns.Publish;
import com.prosc.aws.sns.Subscribe;
import com.prosc.core.FeedbackException;
import com.prosc.deployment.DeploymentInfo;
import com.prosc.emailplugin.EmailInbound;
import com.prosc.emailplugin.EmailOutbound;
import com.prosc.emailplugin.EmailUtils;
import com.prosc.emailplugin.FileChooserOptions;
import com.prosc.emailplugin.PluginMessage;
import com.prosc.fmkit.PluginUtils;
import com.prosc.security.EncryptionUtils;
import com.prosc.shared.StringUtils;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.pop3.POP3Folder;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.activation.MailcapCommandMap;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.AuthenticationFailedException;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.UIDFolder;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import javax.mail.util.ByteArrayDataSource;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.xml.transform.TransformerConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class EmailerModel
implements EmailOutbound,
EmailInbound {
    protected Session session;
    protected Transport smtpTransport;
    protected String activeSmtpConnect;
    protected static final Logger log = Logger.getLogger(EmailerModel.class.getName());
    private static final Object connectionLock = new Object();
    public static final String VERSION_NAME;
    public static final boolean DEFAULT_ATTACHMENT_ENABLE = true;
    public static final String PROP_ATTACHMENTS = "attachments";
    public static final String PROP_SKIP = "skip";
    public static final String PROP_MAX = "max";
    public static final String ATTACHMENTS_DIR = "attachmentsDir";
    protected Store inboundStore;
    protected String activeInboundConnect;
    protected Folder lastAccessedFolder;
    private PluginMessage pluginMessage;
    private int folderMode;
    private DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.getDefault());
    private DateFormat timeFormat = DateFormat.getTimeInstance(2, Locale.getDefault());
    private DateFormat datetimeFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
    private Object currentMessage;
    protected String lastSentMessageId;
    @Nullable
    private Boolean expungeOverride;
    protected long lastSmtpConnectTime;
    private boolean startTLS;
    private boolean enableLogging;
    private boolean enableLegacyLogin;
    private boolean enableSASLOverIMAP;

    @Override
    public void setLoggingEnabled(boolean enableLogging) {
        this.enableLogging = enableLogging;
        if (this.enableLogging) {
            System.setProperty("com.prosc.devmode", "true");
        } else {
            System.setProperty("com.prosc.devmode", "false");
        }
    }

    @Override
    public void setLegacyLoginEnabled(boolean enableLegacyLogin) {
        this.enableLegacyLogin = enableLegacyLogin;
    }

    @Override
    public void setSASLOverIMAP(boolean enableSASLOverIMAP) {
        this.enableSASLOverIMAP = enableSASLOverIMAP;
    }

    @Override
    public boolean isOutboundConnected() {
        return this.activeSmtpConnect != null && this.smtpTransport.isConnected() && System.currentTimeMillis() - this.lastSmtpConnectTime < 30000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connectSMTP(String smtpHost, String username, String password, boolean ssl, @Nullable Integer timeout, boolean forceTrust, boolean enableLegacyLogin) throws MessagingException, FeedbackException {
        if (smtpHost == null) {
            throw new FeedbackException("smtpHost must not be empty.");
        }
        Object object = connectionLock;
        synchronized (object) {
            String uniqueCheck = smtpHost + ":" + username + ":" + password + ":" + ssl;
            if (uniqueCheck.equals(this.activeSmtpConnect) && this.smtpTransport.isConnected() && System.currentTimeMillis() - this.lastSmtpConnectTime < 30000L) {
                return;
            }
            if (this.smtpTransport != null) {
                log.log(Level.INFO, "Auto-closing SMTP connection which was opened previously");
                this.closeQuietly(this.smtpTransport);
            }
            int port = -1;
            int colonIndex = smtpHost.indexOf(58);
            if (colonIndex > 0) {
                port = Integer.parseInt(smtpHost.substring(colonIndex + 1));
                smtpHost = smtpHost.substring(0, colonIndex);
            }
            if (username != null && password != null && !username.equals("") && !password.equals("")) {
                System.setProperty("mail.smtp.auth", "true");
                System.setProperty("mail.smtps.auth", "true");
            } else {
                System.getProperties().remove("mail.smtp.auth");
                System.getProperties().remove("mail.smtps.auth");
            }
            if (timeout != null) {
                System.setProperty("mail.smtp.timeout", Integer.toString(timeout * 1000));
                System.setProperty("mail.smtp.connectiontimeout", Integer.toString(timeout * 1000));
                System.setProperty("mail.smtps.timeout", Integer.toString(timeout * 1000));
                System.setProperty("mail.smtps.connectiontimeout", Integer.toString(timeout * 1000));
            } else {
                System.setProperty("mail.smtp.timeout", Integer.toString(30000));
                System.setProperty("mail.smtp.connectiontimeout", Integer.toString(30000));
                System.setProperty("mail.smtps.timeout", Integer.toString(30000));
                System.setProperty("mail.smtps.connectiontimeout", Integer.toString(30000));
            }
            this.setupForceTrust(smtpHost, forceTrust);
            this.preemptivelySetStartTLS();
            this.setupLegacyLogin(enableLegacyLogin);
            try {
                this.activeSmtpConnect = uniqueCheck;
                try {
                    this.smtpTransport = this.getSession().getTransport(ssl ? "smtps" : "smtp");
                    this.lastSmtpConnectTime = System.currentTimeMillis();
                    log.info("Connecting to SMTP server " + smtpHost + ", username " + username + ", port=" + port);
                    this.smtpTransport.connect(smtpHost, port, username, password);
                }
                catch (AuthenticationFailedException e) {
                    log.info("Authentication failed, will enable TLS and try again");
                    System.setProperty("mail.smtp.starttls.enable", "true");
                    System.setProperty("mail.smtps.starttls.enable", "true");
                    this.session = null;
                    this.smtpTransport = this.getSession().getTransport(ssl ? "smtps" : "smtp");
                    this.lastSmtpConnectTime = System.currentTimeMillis();
                    log.info("Connecting to SMTP server " + smtpHost + ", username " + username + ", port=" + port);
                    this.smtpTransport.connect(smtpHost, port, username, password);
                }
                log.info("Connected.");
            }
            catch (AuthenticationFailedException e) {
                throw new FeedbackException("Authentication failed, please check authentication info.", e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendSMS(@NotNull String accessKey, @NotNull String secretKey, String recipient, String body, @Nullable Region region) throws FeedbackException, IOException {
        void var10_15;
        Object[] allRecipientsNumeric;
        if (accessKey == null) {
            EmailerModel.$$$reportNull$$$0(0);
        }
        if (secretKey == null) {
            EmailerModel.$$$reportNull$$$0(1);
        }
        if (StringUtils.isEmpty(recipient)) {
            throw new FeedbackException("recipient must not be empty.");
        }
        if (StringUtils.isEmpty(body)) {
            throw new FeedbackException("body must not be empty.");
        }
        for (String string : allRecipientsNumeric = recipient.replaceAll("[^0-9,\n]", "").split("[\n,\r]")) {
            if (string.length() >= 11) continue;
            throw new FeedbackException("Enter a 11-digit phone number for recipient (with country code). Separate multiple values with a comma or newline");
        }
        Signer signer = new Signer(accessKey, secretKey, region);
        Arrays.sort(allRecipientsNumeric);
        String recipList = StringUtils.join(allRecipientsNumeric, "_");
        if (recipList.length() > 256) {
            ByteArrayInputStream target = new ByteArrayInputStream(recipList.getBytes());
            byte[] bytes = EncryptionUtils.generateSHA256Digest(target);
            String hashValue = Base64.getEncoder().encodeToString(bytes);
            String string = hashValue.replaceAll("[+,=,/]", "");
        } else {
            String string = recipList;
        }
        log.info("Topic name: " + (String)var10_15);
        String topicArn = new CreateTopic(signer, false, (String)var10_15).call();
        for (Object eachRecipient : allRecipientsNumeric) {
            new Subscribe(signer, false, topicArn, "SMS", (String)eachRecipient).call();
        }
        Arrays.sort(allRecipientsNumeric);
        new Publish(signer, false, body, false, topicArn).call();
    }

    private void setupLegacyLogin(boolean enableLegacyLogin) {
        if (enableLegacyLogin) {
            log.log(Level.INFO, "Enabling Legacy Login.");
            System.setProperty("mail.imaps.auth.plain.disable", "true");
            System.setProperty("mail.imap.auth.plain.disable", "true");
            System.setProperty("mail.imaps.auth.ntlm.disable", "true");
            System.setProperty("mail.imap.auth.ntlm.disable", "true");
            System.setProperty("mail.imaps.auth.gssapi.disable", "true");
            System.setProperty("mail.imap.auth.gssapi.disable", "true");
            System.setProperty("mail.smtps.auth.plain.disable", "true");
            System.setProperty("mail.smtp.auth.plain.disable", "true");
            System.setProperty("mail.smtps.auth.ntlm.disable", "true");
            System.setProperty("mail.smtp.auth.ntlm.disable", "true");
            System.setProperty("mail.smtps.auth.gssapi.disable", "true");
            System.setProperty("mail.smtp.auth.gssapi.disable", "true");
            this.clearAuthMechanisms();
            System.setProperty("mail.smtp.auth.mechanisms", "LOGIN PLAIN DIGEST-MD5 NTLM CRAM-MD5");
        } else {
            log.log(Level.INFO, "Disabling Legacy Login.");
            System.setProperty("mail.imaps.auth.plain.disable", "false");
            System.setProperty("mail.imap.auth.plain.disable", "false");
            System.setProperty("mail.imap.auth.login.disable", "false");
            System.setProperty("mail.imaps.auth.login.disable", "false");
            System.setProperty("mail.imaps.auth.ntlm.disable", "false");
            System.setProperty("mail.imap.auth.ntlm.disable", "false");
            System.setProperty("mail.imaps.auth.gssapi.disable", "false");
            System.setProperty("mail.imap.auth.gssapi.disable", "false");
            System.setProperty("mail.smtps.auth.plain.disable", "false");
            System.setProperty("mail.smtp.auth.plain.disable", "false");
            System.setProperty("mail.smtps.auth.login.disable", "false");
            System.setProperty("mail.smtp.auth.login.disable", "false");
            System.setProperty("mail.smtps.auth.ntlm.disable", "false");
            System.setProperty("mail.smtp.auth.ntlm.disable", "false");
            System.setProperty("mail.smtps.auth.gssapi.disable", "false");
            System.setProperty("mail.smtp.auth.gssapi.disable", "false");
            this.clearAuthMechanisms();
            System.setProperty("mail.imap.auth.mechanisms", "XOAUTH2");
            System.setProperty("mail.imaps.auth.mechanisms", "XOAUTH2");
            System.setProperty("mail.smtp.auth.mechanisms", "XOAUTH2");
            System.setProperty("mail.smtps.auth.mechanisms", "XOAUTH2");
        }
    }

    public void clearAuthMechanisms() {
        System.clearProperty("mail.imap.auth.mechanisms");
        System.clearProperty("mail.imaps.auth.mechanisms");
        System.clearProperty("mail.smtp.auth.mechanisms");
        System.clearProperty("mail.smtps.auth.mechanisms");
    }

    private void setupForceTrust(String smtpHost, boolean forceTrust) {
        if (forceTrust) {
            System.setProperty("mail.smtp.ssl.trust", smtpHost);
            System.setProperty("mail.smtps.ssl.trust", smtpHost);
            System.setProperty("mail.imap.ssl.trust", smtpHost);
            System.setProperty("mail.imaps.ssl.trust", smtpHost);
            System.setProperty("mail.pop.ssl.trust", smtpHost);
            System.setProperty("mail.pops.ssl.trust", smtpHost);
        } else {
            System.getProperties().remove("mail.smtp.ssl.trust");
            System.getProperties().remove("mail.smtps.ssl.trust");
            System.getProperties().remove("mail.imap.ssl.trust");
            System.getProperties().remove("mail.imaps.ssl.trust");
            System.getProperties().remove("mail.pop.ssl.trust");
            System.getProperties().remove("mail.pops.ssl.trust");
        }
    }

    protected Session getSession() {
        if (this.session == null) {
            log.log(Level.INFO, "Setting encoding system properties to correctly encode unicode characters in SMTP headers");
            System.setProperty("mail.mime.decodetext.strict", "false");
            System.setProperty("mail.mime.encodefilename", "true");
            System.setProperty("mail.mime.decodefilename", "true");
            System.setProperty("mail.mime.decodeparameters", "true");
            System.setProperty("mail.mime.encodeparameters", "true");
            System.setProperty("mail.mime.charset", "UTF-8");
            System.setProperty("mail.smtp.connectiontimeout", "30000");
            System.setProperty("mail.smtps.connectiontimeout", "30000");
            System.setProperty("mail.smtp.timeout", "30000");
            System.setProperty("mail.smtps.timeout", "30000");
            System.setProperty("mail.pop3.connectiontimeout", "30000");
            System.setProperty("mail.pop3s.connectiontimeout", "30000");
            System.setProperty("mail.pop3.timeout", "30000");
            System.setProperty("mail.pop3s.timeout", "30000");
            System.setProperty("mail.imap.connectiontimeout", "30000");
            System.setProperty("mail.imaps.connectiontimeout", "30000");
            System.setProperty("mail.imap.timeout", "30000");
            System.setProperty("mail.imaps.timeout", "30000");
            System.setProperty("mail.imap.partialfetch", "false");
            System.setProperty("mail.imaps.partialfetch", "false");
            System.setProperty("mail.mime.uudecode.ignoreerrors", "true");
            System.setProperty("mail.mime.uudecode.ignoremissingbeginend", "true");
            System.setProperty("mail.mime.multipart.allowempty", "true");
            System.setProperty("mail.mime.multipart.ignoreexistingboundaryparameter", "true");
            System.setProperty("mail.mime.ignoreunknownencoding", "true");
            System.setProperty("mail.mime.parameters.strict", "false");
            this.session = Session.getDefaultInstance(System.getProperties());
            if (Boolean.getBoolean("com.prosc.devmode")) {
                log.log(Level.INFO, "Enabling debug mode in javamail");
                this.session.setDebug(true);
                System.setProperty("mail.debug", "true");
            }
        }
        return this.session;
    }

    @Override
    public synchronized Transport getSmtpTransport() {
        return this.smtpTransport;
    }

    protected void closeQuietly(Service service) {
        try {
            if (service != null) {
                service.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Couldn't close service " + service, e);
        }
    }

    @Override
    public synchronized void disconnect() throws MessagingException {
        try {
            this.closeLastAccessedFolder();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Could not close last accessed folder " + this.lastAccessedFolder, e);
        }
        this.lastAccessedFolder = null;
        this.closeQuietly(this.smtpTransport);
        this.smtpTransport = null;
        this.closeQuietly(this.inboundStore);
        this.inboundStore = null;
        this.activeSmtpConnect = null;
        this.activeInboundConnect = null;
        this.session = null;
        this.setCurrentMessage((PluginMessage)null);
    }

    public void verify(MimeMessage testMessage) {
        throw new AbstractMethodError("Not Implemented");
    }

    protected void closeLastAccessedFolder() throws MessagingException {
        if (this.lastAccessedFolder != null && this.lastAccessedFolder.isOpen()) {
            boolean expunge = this.expungeOverride == null ? this.lastAccessedFolder.getPermanentFlags().contains(Flags.Flag.DELETED) : this.expungeOverride.booleanValue();
            log.log(Level.INFO, "Closing " + this.lastAccessedFolder.getName() + " Folder, expunge=" + expunge);
            this.lastAccessedFolder.close(expunge);
        }
        this.lastAccessedFolder = null;
    }

    @Override
    public synchronized void quickSend(String from, String to, String subject, String body, InputStream attachmentStream, String attachmentName) throws MessagingException, IOException, FeedbackException {
        if (from == null) {
            throw new FeedbackException("from address must not be empty.");
        }
        if (to == null) {
            throw new FeedbackException("to address must not be empty.");
        }
        if (body == null && attachmentStream == null) {
            throw new FeedbackException("You must specify either a body or attachment.");
        }
        if (attachmentStream != null && attachmentName == null) {
            throw new FeedbackException("attachmentName must not be empty.");
        }
        PluginMessage quickMessage = new PluginMessage(this.getSession());
        quickMessage.setFrom(new InternetAddress(from));
        quickMessage.setRecipients(MimeMessage.RecipientType.TO, to);
        if (subject != null) {
            quickMessage.setSubject(subject);
        }
        if (body != null) {
            quickMessage.setBody(body);
        }
        if (attachmentStream != null) {
            MimeBodyPart attachPart = new MimeBodyPart();
            ByteArrayDataSource ds = this._dataSourceForContainerData(attachmentStream, attachmentName);
            ds.setName(attachmentName);
            attachPart.setDataHandler(new DataHandler(ds));
            attachPart.setFileName(attachmentName);
            quickMessage.addAttachment(ds);
        }
        this.setCurrentMessage(quickMessage);
        this._sendMessage(quickMessage);
    }

    private ByteArrayDataSource _dataSourceForContainerData(InputStream attachmentStream, String attachmentName) throws IOException {
        String attachmentContentType = new MimetypesFileTypeMap().getContentType(attachmentName);
        ByteArrayDataSource ds = new ByteArrayDataSource(attachmentStream, attachmentContentType);
        ds.setName(attachmentName);
        return ds;
    }

    @Override
    public void checkForExistingMessage() throws FeedbackException {
        if (this.pluginMessage == null) {
            throw new FeedbackException("You must call EmailCreate before calling this function");
        }
    }

    public synchronized void createFromRaw(String raw) {
        this.pluginMessage = new PluginMessage(this.getSession());
        try {
            this.pluginMessage.setRawMessageContent(this.session, raw);
            this.pluginMessage.setHeader("X-Mailer", "360Works FileMaker Email Plugin (" + this.getVersionName() + ")");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        this.setCurrentMessage(this.pluginMessage);
    }

    @Override
    public synchronized void create(String from, String to, String subject, String content) throws MessagingException, FeedbackException {
        this.pluginMessage = null;
        boolean fromRaw = false;
        if (!StringUtils.isEmpty(content) && content.contains("Content-Type:")) {
            this.createFromRaw(content);
            fromRaw = true;
        } else {
            if (from == null) {
                throw new FeedbackException("from address must not be empty.");
            }
            EmailUtils.validateEmailAddress(from);
            if (to != null) {
                EmailUtils.validateEmailAddress(to);
            }
            this.pluginMessage = new PluginMessage(this.getSession());
            this.setCurrentMessage(this.pluginMessage);
            this.pluginMessage.setHeader("X-Mailer", "360Works FileMaker Email Plugin (" + this.getVersionName() + ")");
        }
        if (to != null) {
            this.pluginMessage.setRecipients(Message.RecipientType.TO, to);
        }
        if (from != null) {
            this.pluginMessage.addFroms(from);
        }
        if (subject != null) {
            if (subject.length() > 997) {
                subject = subject.substring(0, 997);
            }
            subject = subject.replaceAll("\n", " ");
            subject = subject.replaceAll("\r", " ");
            this.pluginMessage.setSubject(subject);
        }
        if (!fromRaw && content != null) {
            this.pluginMessage.setBody(content);
        }
    }

    @Override
    public void setBody(String body, String contentType, String characterSet) throws MessagingException, FeedbackException {
        this.checkForExistingMessage();
        String subtype = contentType;
        if (subtype != null && subtype.toLowerCase().startsWith("text/")) {
            subtype = subtype.substring(5);
        }
        if (characterSet != null) {
            this.pluginMessage.setCharacterSet(characterSet);
        }
        if ("html".equals(subtype)) {
            this.pluginMessage.setHtmlText(body);
        } else if ("plain".equals(subtype) || subtype == null) {
            this.pluginMessage.setPlainText(body);
        } else {
            this.pluginMessage.setUnknownText(body, contentType);
        }
    }

    @Override
    public synchronized void setBodyFile(URL url, boolean embedResources) throws FeedbackException, MessagingException, IOException {
        this.checkForExistingMessage();
        this.pluginMessage.setBodyFile(url, embedResources);
    }

    @Override
    public synchronized void clearRecipients() throws MessagingException, FeedbackException {
        this.checkForExistingMessage();
        this.pluginMessage.clearRecipients();
    }

    @Override
    public synchronized void newRecipients(String recipientList, Message.RecipientType type, boolean append) throws MessagingException, FeedbackException {
        this.checkForExistingMessage();
        if (append) {
            this.pluginMessage.addRecipients(type, recipientList);
        } else {
            this.pluginMessage.setRecipients(type, recipientList);
        }
    }

    @Override
    public synchronized void addAttachment(InputStream stream, String name) throws IOException, MessagingException, FeedbackException {
        this.checkForExistingMessage();
        if (stream == null) {
            throw new FeedbackException("stream must not be empty.");
        }
        if (name == null) {
            throw new FeedbackException("name must not be empty.");
        }
        ByteArrayDataSource ds = this._dataSourceForContainerData(stream, name);
        ds.setName(name);
        this.pluginMessage.addAttachment(ds);
    }

    @Override
    public synchronized void addAttachmentInline(InputStream stream, String name, String contentId) throws FeedbackException, IOException, MessagingException {
        this.checkForExistingMessage();
        if (stream == null) {
            throw new FeedbackException("stream must not be empty.");
        }
        if (name == null) {
            throw new FeedbackException("name must not be empty.");
        }
        ByteArrayDataSource ds = this._dataSourceForContainerData(stream, name);
        this.pluginMessage.addInlineAttachment(contentId, new DataHandler(ds));
    }

    @Override
    public void addAttachment(File attachFile, final String attachName) throws FeedbackException {
        this.checkForExistingMessage();
        if (attachFile == null) {
            throw new FeedbackException("attachFile must not be null.");
        }
        this.pluginMessage.addAttachment(new FileDataSource(attachFile){

            @Override
            public String getName() {
                return attachName;
            }
        });
    }

    @Override
    public synchronized void setHeader(String header, String value) throws MessagingException, FeedbackException {
        this.checkForExistingMessage();
        if (header == null) {
            throw new FeedbackException("header must not be empty.");
        }
        if (value != null) {
            if (value.length() > 947) {
                value = value.substring(0, 947);
            }
            value = value.replaceAll("\n", " ");
            value = value.replaceAll("\t", " ");
            this.pluginMessage.setHeader(header, value);
        } else {
            this.pluginMessage.removeHeader(header);
        }
    }

    @Override
    public synchronized void setSubject(String subject) throws MessagingException, FeedbackException {
        this.checkForExistingMessage();
        if (subject == null) {
            subject = "";
        }
        this.pluginMessage.setSubject(subject);
    }

    @Override
    public synchronized void send() throws MessagingException, FeedbackException, IOException, SESException {
        this.checkForExistingMessage();
        if (this.pluginMessage.getAllRecipients() == null || this.pluginMessage.getAllRecipients().length == 0) {
            throw new FeedbackException("No recipients were specified in the message");
        }
        try {
            this._sendMessage(this.pluginMessage);
        }
        catch (SendFailedException e) {
            if (e.getInvalidAddresses() != null && e.getInvalidAddresses().length != 0) {
                throw new FeedbackException("Sending failed with error message: " + e.getMessage() + "\nCould not send to these addresses: " + StringUtils.join(", ", e.getInvalidAddresses()), e);
            }
            throw e;
        }
        catch (MessagingException e) {
            if (e.getMessage().equals("[EOF]") && e.getClass().getName().endsWith("SMTPSendFailedException")) {
                throw new FeedbackException("You have been disconnected from the outgoing mail server, try disconnecting and reconnecting", e);
            }
            throw e;
        }
    }

    @Override
    public PluginMessage getPluginMessage() {
        return this.pluginMessage;
    }

    private void _sendMessage(PluginMessage msg) throws MessagingException, FeedbackException, IOException {
        if (msg.getAllRecipients() == null) {
            throw new FeedbackException("No recipients were specified for this e-mail");
        }
        log.log(Level.FINE, "Delivering " + msg + " to " + msg.getAllRecipients().length + " recipient(s)");
        if (this.smtpTransport == null) {
            throw new FeedbackException("You must call EmailConnectSMTP before using this function");
        }
        PluginMessage.MyMimeMessage message = msg.buildMimeMessage();
        message.setSentDate(new Date());
        message.saveChanges();
        if (this.smtpTransport != null) {
            this.smtpTransport.sendMessage(message, msg.getAllRecipients());
        } else {
            Transport.send(message);
        }
        this.lastSentMessageId = message.getMessageID();
        msg.setDidSend(true);
        log.fine("Finished delivering message");
    }

    @Override
    public synchronized String getLastSentMessageId() {
        return this.lastSentMessageId;
    }

    @Override
    public void setStartTLS(boolean b) {
        this.startTLS = b;
    }

    public synchronized String getVersionName() {
        return VERSION_NAME;
    }

    @Override
    public boolean isInboundConnected() {
        return this.activeInboundConnect != null && this.inboundStore.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connectInbound(String mailServer, String username, String password, String protocol, boolean forceTrust, boolean enableLegacyLogin) throws MessagingException, FeedbackException {
        if (mailServer == null) {
            throw new FeedbackException("mailServer must not be empty.");
        }
        if (protocol == null) {
            throw new FeedbackException("protocol must not be empty.");
        }
        Object object = connectionLock;
        synchronized (object) {
            protocol = protocol.toLowerCase();
            String uniqueCheck = mailServer + ":" + username + ":" + password + ":" + protocol;
            if (uniqueCheck.equals(this.activeInboundConnect) && this.inboundStore.isConnected()) {
                log.log(Level.INFO, "Already connected to " + protocol + " server " + mailServer + ", username " + username);
                return;
            }
            this.closeQuietly(this.inboundStore);
            this.preemptivelySetStartTLS();
            this.setupLegacyLogin(enableLegacyLogin);
            System.setProperty("mail.mime.encodeeol.strict", "true");
            if (this.enableLogging) {
                System.setProperty("com.prosc.devmode", "true");
            } else {
                System.setProperty("com.prosc.devmode", "false");
            }
            if (this.enableSASLOverIMAP) {
                System.setProperty("mail.imap.sasl.enable", "true");
                System.setProperty("mail.imaps.sasl.enable", "true");
                System.setProperty("mail.imap.sasl.mechanisms", "PLAIN CRAM-MD5");
                System.setProperty("mail.imaps.sasl.mechanisms", "PLAIN CRAM-MD5");
            }
            int port = -1;
            int colonIndex = mailServer.indexOf(58);
            if (colonIndex > 0) {
                port = Integer.parseInt(mailServer.substring(colonIndex + 1));
                mailServer = mailServer.substring(0, colonIndex);
            }
            this.inboundStore = this.getSession().getStore(protocol);
            log.info("Connecting to " + protocol + " server " + mailServer + ", username " + username + ", port=" + port);
            this.setupForceTrust(mailServer, forceTrust);
            boolean retryWithStartTLS = false;
            this.preemptivelySetStartTLS();
            try {
                this.inboundStore.connect(mailServer, port, username, password);
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeException("protocol should be one of 'pop3', 'pop3s' (ssl), 'imap', 'imaps' (ssl).", e);
            }
            catch (AuthenticationFailedException e) {
                if (!this.startTLS) {
                    log.info("Inbound Authentication failed, will enable TLS and try again");
                    retryWithStartTLS = true;
                }
                throw e;
            }
            catch (MessagingException e) {
                if (!this.startTLS && e.getMessage().toLowerCase().contains("no login methods supported")) {
                    retryWithStartTLS = true;
                }
                throw e;
            }
            catch (Exception e) {
                log.info(e.toString() + ", will enable TLS and try again");
                retryWithStartTLS = true;
            }
            if (retryWithStartTLS) {
                System.setProperty("mail.imap.starttls.enable", "true");
                System.setProperty("mail.imaps.starttls.enable", "true");
                System.setProperty("mail.pop3.starttls.enable", "true");
                System.setProperty("mail.pop3s.starttls.enable", "true");
                this.inboundStore = this.getSession().getStore(protocol);
                log.info("Connecting to inbound server " + mailServer + ", username " + username + ", port=" + port);
                this.inboundStore.connect(mailServer, port, username, password);
            }
            this.activeInboundConnect = uniqueCheck;
            this.setCurrentMessage((PluginMessage)null);
            log.info("Connected to " + mailServer);
        }
    }

    private void preemptivelySetStartTLS() {
        if (this.startTLS) {
            System.setProperty("mail.imap.starttls.enable", "true");
            System.setProperty("mail.imaps.starttls.enable", "true");
            System.setProperty("mail.pop3.starttls.enable", "true");
            System.setProperty("mail.pop3s.starttls.enable", "true");
            System.setProperty("mail.smtp.starttls.enable", "true");
            System.setProperty("mail.smtps.starttls.enable", "true");
        } else {
            System.clearProperty("mail.imap.starttls.enable");
            System.clearProperty("mail.imaps.starttls.enable");
            System.clearProperty("mail.pop3.starttls.enable");
            System.clearProperty("mail.pop3s.starttls.enable");
            System.clearProperty("mail.smtp.starttls.enable");
            System.clearProperty("mail.smtps.starttls.enable");
        }
    }

    @Override
    public synchronized boolean connectionIsPop() {
        return this.activeInboundConnect != null && (this.activeInboundConnect.endsWith("pop") || this.activeInboundConnect.endsWith("pop3") || this.activeInboundConnect.endsWith("pop3s") || this.activeInboundConnect.endsWith("pops"));
    }

    @Override
    public synchronized List<String> listMailboxes(String whichFolder, boolean recursive) throws MessagingException, FeedbackException {
        Folder[] folders;
        this._checkInboundConnection();
        LinkedList<String> result = new LinkedList<String>();
        Folder folder = whichFolder == null ? this.inboundStore.getDefaultFolder() : this.inboundStore.getFolder(whichFolder);
        for (Folder eachFolder : folders = folder.list()) {
            this._addFolderToList(eachFolder, result, recursive);
        }
        return result;
    }

    private void _addFolderToList(Folder folder, List<String> result, boolean recursive) throws MessagingException {
        String folderName = folder.getFullName();
        result.add(folderName);
        if (recursive && (folder.getType() & 2) > 0) {
            try {
                Folder[] folders;
                for (Folder eachFolder : folders = folder.list()) {
                    this._addFolderToList(eachFolder, result, recursive);
                }
            }
            catch (MessagingException e) {
                log.log(Level.SEVERE, "Could not list subfolders for " + folderName);
            }
        }
    }

    public int getMessageCount(Properties p) throws FeedbackException, MessagingException {
        if (this.inboundStore == null || !this.inboundStore.isConnected()) {
            throw new FeedbackException("You must call EmailConnectPOP or EmailConnectIMAP before reading messages");
        }
        if (p == null) {
            throw new FeedbackException("properties must not be empty.");
        }
        String mailboxName = p.getProperty("mailbox");
        if (mailboxName == null) {
            mailboxName = "INBOX";
        }
        Folder folder = this.inboundStore.getFolder(mailboxName);
        try {
            this.closeLastAccessedFolder();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not close last accessed folder " + this.lastAccessedFolder, e);
        }
        folder.open(1);
        this.lastAccessedFolder = folder;
        List terms = this.createSearchTerms(p);
        log.log(Level.INFO, "Searching for messages in folder " + folder + " using terms " + terms);
        AndTerm masterTerm = new AndTerm(terms.toArray(new SearchTerm[0]));
        Message[] messages = folder.search(masterTerm);
        return messages.length;
    }

    @Override
    public synchronized Message[] readMessages(Properties properties) throws MessagingException, IOException, TransformerConfigurationException, SAXException, FeedbackException {
        Message[] messages;
        if (this.inboundStore == null || !this.inboundStore.isConnected()) {
            throw new FeedbackException("You must call EmailConnectPOP or EmailConnectIMAP before reading messages");
        }
        if (properties == null) {
            throw new FeedbackException("properties must not be empty.");
        }
        String mailboxName = properties.getProperty("mailbox");
        if (mailboxName == null) {
            mailboxName = "INBOX";
        }
        Folder folder = this.inboundStore.getFolder(mailboxName);
        this.folderMode = PluginUtils.booleanForString(properties.getProperty("readonly"), !this.connectionIsPop()) ? 1 : 2;
        try {
            this.closeLastAccessedFolder();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not close last accessed folder " + this.lastAccessedFolder, e);
        }
        folder.open(this.folderMode);
        this.lastAccessedFolder = folder;
        List terms = this.createSearchTerms(properties);
        Integer skip = this.stringToInteger(properties.getProperty(PROP_SKIP));
        if (skip != null && skip < 0) {
            throw new FeedbackException("skip parameter cannot be a negative number");
        }
        Integer max = this.stringToInteger(properties.getProperty(PROP_MAX));
        if (max != null && max < 0) {
            throw new FeedbackException("max parameter cannot be a negative number");
        }
        String uidProperty = properties.getProperty("uid");
        if (folder instanceof IMAPFolder && properties.containsKey("uid") && !StringUtils.isEmpty(uidProperty)) {
            IMAPFolder imapFolder = (IMAPFolder)folder;
            long uidRange = Long.parseLong(uidProperty) + 1L;
            messages = imapFolder.getMessagesByUID(uidRange, -1L);
            if (messages.length == 1 && imapFolder.getUID(messages[0]) < uidRange) {
                messages = new Message[]{};
            } else if (max != null && max < messages.length) {
                messages = Arrays.copyOfRange(messages, 0, (int)max);
            }
        } else if (folder instanceof POP3Folder && properties.containsKey("uid") && !StringUtils.isEmpty(uidProperty)) {
            POP3Folder pop3Folder = (POP3Folder)folder;
            FetchProfile fetchProfile = new FetchProfile();
            fetchProfile.add(UIDFolder.FetchProfileItem.UID);
            Message[] allMessages = pop3Folder.getMessages();
            pop3Folder.fetch(allMessages, fetchProfile);
            LinkedList<Message> messageList = new LinkedList<Message>();
            for (Message eachMessage : allMessages) {
                String uid = pop3Folder.getUID(eachMessage);
                if (uid.compareTo(uidProperty) <= 0) continue;
                messageList.add(eachMessage);
            }
            messages = messageList.toArray(new Message[messageList.size()]);
        } else if (terms.isEmpty()) {
            if (skip == null && max == null) {
                log.log(Level.INFO, "Getting all messages from folder " + folder);
                messages = folder.getMessages();
            } else {
                log.log(Level.INFO, "Getting messages from folder " + folder + ", skip=" + skip + ", max=" + max);
                int start = skip == null ? 1 : 1 + skip;
                int end = max == null ? Integer.MAX_VALUE : start + max - 1;
                int messageCount = folder.getMessageCount();
                if (start > messageCount) {
                    return new Message[0];
                }
                end = Math.min(end, messageCount);
                messages = folder.getMessages(start, end);
            }
        } else {
            log.log(Level.INFO, "Searching for messages in folder " + folder + " using terms " + terms);
            AndTerm masterTerm = new AndTerm(terms.toArray(new SearchTerm[terms.size()]));
            messages = folder.search(masterTerm);
            if (skip != null || max != null) {
                Message[] tmpMessages;
                int skipInt = skip == null ? 0 : skip;
                int length = Math.max(0, messages.length - skipInt);
                if (max != null && max < length && max > 0) {
                    length = max;
                }
                if ((tmpMessages = new Message[length]).length < 1) {
                    messages = tmpMessages;
                } else {
                    System.arraycopy(messages, skipInt, tmpMessages, 0, length);
                    messages = tmpMessages;
                }
            }
        }
        log.log(Level.INFO, "Fetching found messages");
        FetchProfile fetchProfile = new FetchProfile();
        if (PluginUtils.booleanForString(properties.getProperty(PROP_ATTACHMENTS), true)) {
            // empty if block
        }
        fetchProfile.add(FetchProfile.Item.CONTENT_INFO);
        fetchProfile.add(FetchProfile.Item.ENVELOPE);
        fetchProfile.add(FetchProfile.Item.FLAGS);
        try {
            folder.fetch(messages, fetchProfile);
        }
        catch (MessagingException e) {
            log.log(Level.WARNING, "Error while reading messages. Disabling fetch profile to fetch only envelopes. This results in slower performance, but errors can be caught on a per-message basis", e);
            folder.fetch(messages, new FetchProfile());
        }
        if (!folder.isOpen()) {
            log.log(Level.WARNING, "Calling fetch() closed the folder " + folder + ", re-opening it");
            folder.open(this.folderMode);
        }
        return messages;
    }

    private List createSearchTerms(Properties properties) {
        String viewed;
        String deleted;
        String flagged;
        String sentDateTo;
        String sentDateFrom;
        String dateTo;
        String dateFrom;
        String body;
        String messageId;
        String subject;
        String recipient;
        LinkedList<SearchTerm> terms = new LinkedList<SearchTerm>();
        String from = properties.getProperty("from");
        if (from != null) {
            terms.add(new FromStringTerm(from));
        }
        if ((recipient = properties.getProperty("to")) != null) {
            terms.add(new RecipientStringTerm(Message.RecipientType.TO, recipient));
        }
        if ((subject = properties.getProperty("subject")) != null) {
            terms.add(new SubjectTerm(subject));
        }
        if ((messageId = properties.getProperty("messageId")) != null) {
            String[] messageIds = messageId.split("\n");
            if (messageIds.length > 0) {
                SearchTerm[] messageIDTerms = new MessageIDTerm[messageIds.length];
                for (int i = 0; i < messageIds.length; ++i) {
                    String id = messageIds[i];
                    messageIDTerms[i] = new MessageIDTerm(id);
                }
                terms.add(new OrTerm(messageIDTerms));
            } else {
                terms.add(new MessageIDTerm(messageId));
            }
        }
        if ((body = properties.getProperty("body")) != null) {
            terms.add(new BodyTerm(body));
        }
        if ((dateFrom = properties.getProperty("dateFrom")) != null) {
            Date date = this.stringToDate(dateFrom);
            terms.add(new SentDateTerm(6, date));
        }
        if ((dateTo = properties.getProperty("dateTo")) != null) {
            Date date = this.stringToDate(dateTo);
            terms.add(new SentDateTerm(1, date));
        }
        if ((sentDateFrom = properties.getProperty("receivedDateFrom")) != null) {
            Date date = this.stringToDate(sentDateFrom);
            terms.add(new ReceivedDateTerm(6, date));
        }
        if ((sentDateTo = properties.getProperty("receivedDateTo")) != null) {
            Date date = this.stringToDate(sentDateTo);
            terms.add(new ReceivedDateTerm(1, date));
        }
        if ((flagged = properties.getProperty("flagged")) != null) {
            terms.add(new FlagTerm(new Flags(Flags.Flag.FLAGGED), PluginUtils.booleanForString(flagged, false)));
        }
        if ((deleted = properties.getProperty("deleted", "false")) != null && !"any".equalsIgnoreCase(deleted)) {
            terms.add(new FlagTerm(new Flags(Flags.Flag.DELETED), PluginUtils.booleanForString(deleted, false)));
        }
        if ((viewed = properties.getProperty("read")) == null) {
            viewed = properties.getProperty("viewed");
        }
        if (viewed != null) {
            terms.add(new FlagTerm(new Flags(Flags.Flag.SEEN), PluginUtils.booleanForString(viewed, false)));
        }
        return terms;
    }

    private void _checkInboundConnection() throws FeedbackException {
        if (this.inboundStore == null) {
            throw new FeedbackException("You must call EmailConnectIMAP or EmailConnectPOP before reading/writing data from an email server");
        }
    }

    public Integer stringToInteger(String s) {
        return s == null || s.length() == 0 ? null : Integer.valueOf(s);
    }

    private Date stringToDate(String dateFrom) {
        try {
            return this.dateforFmString(dateFrom, null);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private Date dateforFmString(String dateFrom, @Nullable TimeZone timeZone) throws ParseException {
        DateFormat df = dateFrom.indexOf(32) != -1 && dateFrom.indexOf(47) != -1 ? this.datetimeFormat : (dateFrom.indexOf(58) != -1 ? this.timeFormat : this.dateFormat);
        if (timeZone != null) {
            df.setTimeZone(timeZone);
        }
        return df.parse(dateFrom);
    }

    @Override
    public synchronized Folder getFolder() {
        return this.lastAccessedFolder;
    }

    @Override
    public synchronized void bodySubstitute(String searchString, String replaceString) throws FeedbackException, MessagingException {
        this.checkForExistingMessage();
        this.pluginMessage.bodySubstitute(searchString, replaceString);
    }

    @Override
    public synchronized boolean folderModeIsReadOnly() {
        return this.folderMode == 1;
    }

    @Override
    public synchronized void moveCurrentMessage(String folder) throws FeedbackException, MessagingException, IOException {
        Message toAppend;
        if (folder == null) {
            throw new FeedbackException("You did not specify a folder to move the message to");
        }
        this._checkInboundConnection();
        if (this.connectionIsPop()) {
            throw new FeedbackException("Moving messages is only supported by IMAP mailboxes");
        }
        if (this.currentMessage == null) {
            throw new FeedbackException("Before moving a message you must call EmailCreate (for copying outgoing message) or EmailGetNextMessage (for moving incoming messages)");
        }
        Folder f = this.inboundStore.getFolder(folder);
        if (f == null) {
            throw new FeedbackException("Could not get folder '" + folder + "'");
        }
        if (!f.exists()) {
            f.create(1);
        }
        Folder oldFolder = null;
        if (this.currentMessage instanceof Message) {
            toAppend = (Message)this.currentMessage;
            oldFolder = toAppend.getFolder();
        } else if (this.currentMessage instanceof PluginMessage) {
            toAppend = ((PluginMessage)this.currentMessage).buildMimeMessage();
            if (toAppend.getSentDate() == null) {
                toAppend.setSentDate(new Date());
            }
        } else {
            throw new IllegalStateException("currentMessage is not a javax.mail.Message or com.prosc.emailplugin.PluginMessage");
        }
        f.appendMessages(new Message[]{toAppend});
        if (oldFolder != null && oldFolder.getMode() != 1 && this.currentMessage instanceof Message) {
            ((Message)this.currentMessage).setFlag(Flags.Flag.DELETED, true);
        }
    }

    @Override
    public synchronized void setCurrentMessage(PluginMessage currentMessage) {
        this.currentMessage = currentMessage;
    }

    @Override
    public synchronized void setCurrentMessage(MimeMessage currentMessage) {
        this.currentMessage = currentMessage;
    }

    @Override
    public synchronized void setExpungeOverride(Boolean b) {
        this.expungeOverride = b;
    }

    @Override
    public synchronized Callable<Integer> getProgressMonitor() throws MessagingException, IOException {
        return this.pluginMessage.getProgressMonitor();
    }

    File chooseFile(Component parent, FileChooserOptions options) throws FeedbackException {
        log.log(Level.FINE, "Showing file chooser dialog");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(options.getFileSelectionMode());
        chooser.setDialogTitle(options.getTitle());
        chooser.setCurrentDirectory(options.getInitialDir());
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal != 0) {
            throw new FeedbackException("User cancelled File Chooser");
        }
        File file = chooser.getSelectedFile();
        System.out.println(file.getAbsolutePath());
        return file;
    }

    @Override
    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public void setTimeFormat(DateFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    @Override
    public void setDateTimeFormat(DateFormat datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
    }

    static {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap(mc);
        VERSION_NAME = DeploymentInfo.getApplicationInstance().getVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "accessKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "secretKey";
                break;
            }
        }
        objectArray[1] = "com/prosc/emailplugin/EmailerModel";
        objectArray[2] = "sendSMS";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CenteredFileChooser
    extends JFileChooser {
        public CenteredFileChooser() {
        }

        public CenteredFileChooser(FileChooserOptions options) {
            super(options.getInitialDir().getAbsolutePath());
        }

        @Override
        protected JDialog createDialog(Component parent) throws HeadlessException {
            JDialog result = super.createDialog(parent);
            if (parent.getWidth() == 0 || parent.getHeight() == 0) {
                result.setLocationRelativeTo(null);
            }
            return result;
        }
    }
}

