/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.core.FeedbackException;
import com.prosc.emailplugin.ContainerEmbedderFormat;
import com.prosc.emailplugin.EmailOutbound;
import com.prosc.emailplugin.MBoxFile;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.types.InputStreamInfo;
import com.prosc.io.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;

public final class EmailUtils {
    private EmailUtils() {
    }

    public static void validateEmailAddress(@NotNull String email) throws AddressException {
        InternetAddress[] internetAddresses;
        if (email == null) {
            EmailUtils.$$$reportNull$$$0(0);
        }
        for (InternetAddress internetAddress : internetAddresses = InternetAddress.parse(email, true)) {
            String s = internetAddress.toString();
            int atIndex = s.indexOf(64);
            if (atIndex <= 0) {
                throw new AddressException("Missing '@' sign");
            }
            if (s.indexOf(46, atIndex) != -1) continue;
            throw new AddressException("Invalid domain");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MimeMessage> messagesForFile(InputStreamInfo info, String charset) throws MessagingException, IOException, FeedbackException {
        String firstLine;
        File f = info.getFile();
        if (f == null) {
            f = File.createTempFile("EmailPlugin", info.getName());
            InputStream stream = info.getStream();
            try {
                IOUtils.writeInputToOutput(stream, (OutputStream)new FileOutputStream(f), 4096);
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        ArrayList<MimeMessage> result = new ArrayList<MimeMessage>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), charset == null ? "UTF-8" : charset));){
            firstLine = br.readLine();
        }
        if (firstLine == null) {
            throw new IOException("Message file is empty");
        }
        if (firstLine.toLowerCase().startsWith("from ")) {
            MBoxFile file = new MBoxFile(f);
            int count = file.getMessageCount();
            Session s = Session.getDefaultInstance(System.getProperties());
            for (int i = 0; i < count; ++i) {
                try (InputStream is = file.getMessageAsStream(i);){
                    result.add(new MimeMessage(s, is));
                    continue;
                }
            }
        } else {
            boolean emlx = firstLine.trim().matches("[0-9]+");
            if (firstLine.indexOf(58) != -1 || emlx) {
                FileInputStream is = new FileInputStream(f);
                if (emlx) {
                    // empty if block
                }
                try {
                    result.add(new MimeMessage(Session.getDefaultInstance(System.getProperties()), is));
                }
                finally {
                    ((InputStream)is).close();
                }
            } else {
                throw new FeedbackException("Unable to parse messages from " + f.getName());
            }
        }
        return result;
    }

    public static String bodyTextMerged(PluginContext context, EmailOutbound model, String body, String contentType) {
        String subtype = contentType;
        if (subtype != null && subtype.toLowerCase().startsWith("text/")) {
            subtype = subtype.substring(5);
        }
        if ("html".equals(subtype)) {
            String newBody = body.replaceAll("&lt;&lt;", "<<").replaceAll("&gt;&gt;", ">>");
            return PluginUtils.mergeString(context, body, new ContainerEmbedderFormat(model, context), true);
        }
        body = PluginUtils.mergeString(context, body, null, true);
        return body;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/prosc/emailplugin/EmailUtils", "validateEmailAddress"));
    }
}

