/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class EmailSenderSocketFactory
extends SocketFactory {
    private static final Logger log = Logger.getLogger(EmailSenderSocketFactory.class.getName());

    public EmailSenderSocketFactory() {
        log.log(Level.FINE, "Creating custom " + this.getClass().getName());
    }

    @Override
    public Socket createSocket() {
        return new ProgressSocket();
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
        return new ProgressSocket(s, i);
    }

    @Override
    public Socket createSocket(InetAddress inetaddress, int i) throws IOException {
        return new ProgressSocket(inetaddress, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetaddress, int j) throws IOException, UnknownHostException {
        return new ProgressSocket(s, i, inetaddress, j);
    }

    @Override
    public Socket createSocket(InetAddress inetaddress, int i, InetAddress inetaddress1, int j) throws IOException {
        return new ProgressSocket(inetaddress, i, inetaddress1, j);
    }

    private static class ProgressSocket
    extends Socket {
        public ProgressSocket() {
        }

        public ProgressSocket(String s, int i) throws IOException {
            super(s, i);
        }

        public ProgressSocket(InetAddress inetaddress, int i) throws IOException {
            super(inetaddress, i);
        }

        public ProgressSocket(String s, int i, InetAddress inetaddress, int j) throws IOException {
            super(s, i, inetaddress, j);
        }

        public ProgressSocket(InetAddress inetaddress, int i, InetAddress inetaddress1, int j) throws IOException {
            super(inetaddress, i, inetaddress1, j);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new FilterOutputStream(super.getOutputStream()){
                private int bytesWritten;
                {
                    super(x0);
                    this.bytesWritten = 0;
                }

                @Override
                public void write(int b) throws IOException {
                    super.write(b);
                    ++this.bytesWritten;
                }

                @Override
                public void write(byte[] b) throws IOException {
                    super.write(b);
                    this.bytesWritten += b.length;
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    super.write(b, off, len);
                    this.bytesWritten += len;
                }
            };
        }
    }
}

