/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.emailplugin.EmailOutbound;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.FMData;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.logging.Level;
import java.util.logging.Logger;

class ContainerEmbedderFormat
extends Format {
    private static final Logger log = Logger.getLogger(ContainerEmbedderFormat.class.getName());
    private int attachCount = 1;
    private EmailOutbound emailerModel;
    private final PluginContext context;

    public ContainerEmbedderFormat(EmailOutbound emailerModel, PluginContext context) {
        this.emailerModel = emailerModel;
        this.context = context;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        FMData data = (FMData)obj;
        FMBinaryInterface fmBinary = data.getFMBinary(this.context);
        if (fmBinary.getStreamTypes(this.context).isEmpty()) {
            String stringData = data.getStringData(this.context);
            toAppendTo.append(stringData);
            log.log(Level.FINE, "Converting merge field '" + stringData + "'");
        } else {
            String cid = "att" + System.currentTimeMillis() + "x" + this.attachCount;
            log.log(Level.INFO, "Inlining container " + obj + " into email image as contentId " + cid);
            try {
                this.emailerModel.addAttachmentInline(fmBinary.getBestInputStream(this.context), fmBinary.getFileName(this.context), cid);
                toAppendTo.append("cid:").append(cid);
                ++this.attachCount;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Could not attach inline binary data for " + fmBinary, e);
            }
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new AbstractMethodError("Not Implemented");
    }
}

